/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@ParametersAreNonnullByDefault
public class EntityTextureOverlayLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Nullable
    private PlayerModel<T> extraPlayerModel;

    public EntityTextureOverlayLayer(RenderLayerParent<T, M> context, boolean slim, EntityModelSet loader) {
        super(context);
        if (context.m_7200_() instanceof PlayerModel) {
            this.extraPlayerModel = new PlayerModel(loader.m_171103_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim);
        }
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (entity.m_20145_() && !Minecraft.m_91087_().m_91314_(entity)) {
            return;
        }
        Services.POWER.getPowers((LivingEntity)entity, ApugliPowers.ENTITY_TEXTURE_OVERLAY.get()).forEach(power -> {
            if (power.getTextureLocation() == null && power.getTextureUrl() == null) {
                return;
            }
            RenderType renderLayer = null;
            if (TextureUtilClient.getUrls().containsKey(power.getUrlTextureIdentifier())) {
                renderLayer = Minecraft.m_91087_().m_91314_((Entity)entity) && entity.m_20145_() ? RenderType.m_110491_((ResourceLocation)power.getUrlTextureIdentifier()) : RenderType.m_110473_((ResourceLocation)power.getUrlTextureIdentifier());
            } else if (power.getTextureLocation() != null) {
                RenderType renderType = renderLayer = Minecraft.m_91087_().m_91314_((Entity)entity) && entity.m_20145_() ? RenderType.m_110491_((ResourceLocation)power.getTextureLocation()) : RenderType.m_110473_((ResourceLocation)power.getTextureLocation());
            }
            if (renderLayer != null) {
                matrices.m_85836_();
                float red = 1.0f;
                float green = 1.0f;
                float blue = 1.0f;
                float alpha = 1.0f;
                if (power.shouldUseRenderingPowers()) {
                    float[] rgba = Services.PLATFORM.getColorPowerRgba((LivingEntity)entity);
                    red = rgba[0];
                    green = rgba[1];
                    blue = rgba[2];
                    alpha = rgba[3];
                }
                EntityModel entityModel = this.extraPlayerModel != null ? this.extraPlayerModel : this.m_117386_();
                EntityModel patt3345$temp = this.m_117386_();
                if (patt3345$temp instanceof PlayerModel) {
                    PlayerModel originalModel = (PlayerModel)patt3345$temp;
                    PlayerModel extraModel = (PlayerModel)entityModel;
                    originalModel.m_102872_((HumanoidModel)extraModel);
                    extraModel.f_103378_.m_104315_(originalModel.f_103378_);
                    extraModel.f_103374_.m_104315_(originalModel.f_103374_);
                    extraModel.f_103375_.m_104315_(originalModel.f_103375_);
                    extraModel.f_103376_.m_104315_(originalModel.f_103376_);
                    extraModel.f_103377_.m_104315_(originalModel.f_103377_);
                }
                entityModel.m_7695_(matrices, vertexConsumers.m_6299_(renderLayer), light, OverlayTexture.f_118083_, red, green, blue, alpha);
                matrices.m_85849_();
            }
        });
    }
}

