/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.capability.entity;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.merchantpug.apugli.capability.entity.IKeyPressCapability;
import net.merchantpug.apugli.network.ApugliPacketHandler;
import net.merchantpug.apugli.network.s2c.SyncKeyPressCapabilityPacket;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyPressCapability
implements IKeyPressCapability,
ICapabilityProvider {
    private int previousPowerSize = 0;
    private final Set<IActivePower.Key> keysToCheck = new HashSet<IActivePower.Key>();
    private Set<IActivePower.Key> previouslyUsedKeys = new HashSet<IActivePower.Key>();
    private final Set<IActivePower.Key> currentlyUsedKeys = new HashSet<IActivePower.Key>();
    Player provider;
    public static final Capability<KeyPressCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<KeyPressCapability>(){});
    private final LazyOptional<KeyPressCapability> thisOptional = LazyOptional.of(() -> this);

    public KeyPressCapability(Player provider) {
        this.provider = provider;
    }

    @Override
    public Set<IActivePower.Key> getCurrentlyUsedKeys() {
        return this.currentlyUsedKeys;
    }

    @Override
    public Set<IActivePower.Key> getPreviouslyUsedKeys() {
        return this.previouslyUsedKeys;
    }

    @Override
    public void setPreviouslyUsedKeys() {
        this.previouslyUsedKeys = this.currentlyUsedKeys.stream().filter(IActivePower.Key::continuous).collect(Collectors.toSet());
    }

    @Override
    public Set<IActivePower.Key> getKeysToCheck() {
        return this.keysToCheck;
    }

    @Override
    public void addKeyToCheck(IActivePower.Key key) {
        this.keysToCheck.add(key);
    }

    @Override
    public void addKey(IActivePower.Key key) {
        this.currentlyUsedKeys.add(key);
    }

    @Override
    public void addPreviousKey(IActivePower.Key key) {
        this.previouslyUsedKeys.add(key);
    }

    @Override
    public void removeKey(IActivePower.Key key) {
        this.currentlyUsedKeys.remove(key);
    }

    public void tick() {
        int powerSize;
        int n = powerSize = IPowerContainer.get((Entity)this.provider).resolve().isEmpty() ? 0 : ((IPowerContainer)IPowerContainer.get((Entity)this.provider).resolve().get()).getPowers().size();
        if (this.previousPowerSize != powerSize) {
            this.keysToCheck.clear();
            this.previouslyUsedKeys.clear();
            this.currentlyUsedKeys.clear();
        }
        this.previousPowerSize = powerSize;
    }

    @Override
    public void setFrom(IKeyPressCapability cap) {
        if (!(cap instanceof KeyPressCapability)) {
            return;
        }
        KeyPressCapability classCap = (KeyPressCapability)cap;
        this.previousPowerSize = classCap.previousPowerSize;
        this.keysToCheck.clear();
        this.keysToCheck.addAll(classCap.keysToCheck);
        this.previouslyUsedKeys.clear();
        this.previouslyUsedKeys.addAll(classCap.previouslyUsedKeys);
        this.currentlyUsedKeys.clear();
        this.currentlyUsedKeys.addAll(classCap.currentlyUsedKeys);
    }

    public void sync() {
        if (this.provider.m_9236_().f_46443_) {
            return;
        }
        ApugliPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.provider), (Object)new SyncKeyPressCapabilityPacket(this.provider.m_19879_(), this.previouslyUsedKeys, this.currentlyUsedKeys));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.thisOptional);
    }
}

