/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.network.s2c.SendParticlesPacket;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class SpawnParticlesAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE).add("count", SerializableDataTypes.INT).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("force", SerializableDataTypes.BOOLEAN, (Object)false).add("velocity", SerializableDataTypes.VECTOR, null).add("spread", SerializableDataTypes.VECTOR, (Object)new Vec3(0.5, 0.25, 0.5)).add("offset_y", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.5f));
    }

    @Override
    public void execute(SerializableData.Instance data, Entity instance) {
        if (instance.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)instance.m_9236_();
        int count = (Integer)data.get("count");
        if (count <= 0) {
            return;
        }
        boolean force = (Boolean)data.get("force");
        float speed = ((Float)data.get("speed")).floatValue();
        Vec3 spread = (Vec3)data.get("spread");
        float deltaX = (float)((double)instance.m_20205_() * spread.f_82479_);
        float deltaY = (float)((double)instance.m_20206_() * spread.f_82480_);
        float deltaZ = (float)((double)instance.m_20205_() * spread.f_82481_);
        float offsetY = instance.m_20206_() * data.getFloat("offset_y");
        Vec3 velocity = (Vec3)data.get("velocity");
        this.sendParticlePacket(serverWorld, (ParticleOptions)data.get("particle"), force, instance.m_20185_(), instance.m_20186_() + (double)offsetY, instance.m_20189_(), deltaX, deltaY, deltaZ, Optional.ofNullable(velocity), speed, count);
    }

    private void sendParticlePacket(ServerLevel world, ParticleOptions effect, boolean force, double x, double y, double z, float offsetX, float offsetY, float offsetZ, Optional<Vec3> velocity, float speed, int count) {
        for (int j = 0; j < world.m_6907_().size(); ++j) {
            ServerPlayer player = (ServerPlayer)world.m_6907_().get(j);
            if (player.m_9236_() != world) {
                return;
            }
            BlockPos blockPos = player.m_20097_();
            if (!blockPos.m_203195_((Position)new Vec3(x, y, z), force ? 512.0 : 32.0)) continue;
            Services.PLATFORM.sendS2C(new SendParticlesPacket(effect, force, x, y, z, offsetX, offsetY, offsetZ, speed, velocity, count), player);
        }
    }
}

