/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli;

import io.github.apace100.apoli.integration.PowerLoadEvent;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerDataCache;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.fabric.FabricPowerFactory;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ItemStackAccess;
import net.merchantpug.apugli.action.configuration.FabricActionConfiguration;
import net.merchantpug.apugli.action.factory.entity.CustomProjectileAction;
import net.merchantpug.apugli.capability.entity.EntitiesHitCapability;
import net.merchantpug.apugli.capability.entity.HitsOnTargetCapability;
import net.merchantpug.apugli.capability.entity.IEntitiesHitCapability;
import net.merchantpug.apugli.capability.entity.KeyPressCapability;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.mixin.forge.common.accessor.FabricPowerFactoryAccessor;
import net.merchantpug.apugli.network.ApugliPacketHandler;
import net.merchantpug.apugli.network.s2c.UpdateUrlTexturesPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.ActionOnJumpPower;
import net.merchantpug.apugli.power.ClientActionOverTime;
import net.merchantpug.apugli.power.CrawlingPower;
import net.merchantpug.apugli.power.CustomProjectilePower;
import net.merchantpug.apugli.power.EdibleItemPower;
import net.merchantpug.apugli.power.PreventBreedingPower;
import net.merchantpug.apugli.power.TextureOrUrlPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.merchantpug.apugli.util.TextureUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="apugli")
public class ApugliForgeEventHandler {
    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(KeyPressCapability.ID, (ICapabilityProvider)new KeyPressCapability(player));
        }
        if ((object = event.getObject()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            event.addCapability(HitsOnTargetCapability.ID, (ICapabilityProvider)new HitsOnTargetCapability(living));
        }
        if (event.getObject() instanceof Projectile) {
            event.addCapability(IEntitiesHitCapability.ID, (ICapabilityProvider)new EntitiesHitCapability());
        }
    }

    @SubscribeEvent
    public static void onCalioDynamicRegistryLoadComplete(CalioDynamicRegistryEvent.LoadComplete event) {
        MappedRegistry registry = event.getRegistryManager().get(ApoliDynamicRegistries.CONFIGURED_ENTITY_ACTION_KEY);
        registry.forEach(action -> {
            IDynamicFeatureConfiguration patt4353$temp = action.getConfiguration();
            if (patt4353$temp instanceof FabricActionConfiguration) {
                FabricActionConfiguration fabricConfig = (FabricActionConfiguration)patt4353$temp;
                if (action.getFactory() == ((IForgeRegistry)ApoliRegistries.ENTITY_ACTION.get()).getValue(Apugli.asResource("custom_projectile")) && fabricConfig.data().isPresent("texture_url")) {
                    String url = fabricConfig.data().getString("texture_url");
                    ResourceLocation textureLocation = null;
                    if (fabricConfig.data().isPresent("texture_location")) {
                        textureLocation = ResourceLocation.m_135822_((String)fabricConfig.data().getString("texture_location"), (char)':');
                    }
                    TextureUtil.cacheOneOff(CustomProjectileAction.getTextureUrl(url), url, textureLocation);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onStruckByLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Services.POWER.getPowers(living, ApugliPowers.ACTION_WHEN_LIGHTNING_STRUCK.get()).forEach(p -> ApugliPowers.ACTION_WHEN_LIGHTNING_STRUCK.get().execute(p, living, event.getLightning()));
        }
    }

    @SubscribeEvent
    public static void onGroundJump(LivingEvent.LivingJumpEvent event) {
        Services.POWER.getPowers(event.getEntity(), ApugliPowers.ACTION_ON_JUMP.get()).forEach(ActionOnJumpPower::executeAction);
    }

    @SubscribeEvent
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        Optional<EdibleItemPower> power = Services.POWER.getPowers(event.getEntity(), ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(event.getEntity().m_9236_(), stack)).findFirst();
        if (power.isPresent()) {
            EdibleItemPower.executeEntityActions(event.getEntity(), stack);
            ItemStack newStack = event.getEntity().m_5584_(event.getEntity().m_9236_(), stack);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!player.m_150110_().f_35937_) {
                    if (power.get().getReturnStack() != null) {
                        ItemStack returnStack = power.get().getReturnStack().m_41777_();
                        if (newStack.m_41619_()) {
                            event.setResultStack(EdibleItemPower.executeItemActions(event.getEntity(), returnStack, stack));
                        } else {
                            ItemStack stack2 = EdibleItemPower.executeItemActions(event.getEntity(), returnStack, stack);
                            if (!player.m_36356_(stack2)) {
                                player.m_36176_(stack2, false);
                            }
                        }
                    } else {
                        event.setResultStack(EdibleItemPower.executeItemActions(event.getEntity(), newStack, stack));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBonemeal(BonemealEvent event) {
        BonemealableBlock bonemeal;
        Block block;
        if (Services.POWER.hasPower((LivingEntity)event.getEntity(), ApugliPowers.ACTION_ON_BONEMEAL.get()) && (block = event.getBlock().m_60734_()) instanceof BonemealableBlock && (bonemeal = (BonemealableBlock)block).m_7370_((LevelReader)event.getLevel(), event.getPos(), event.getBlock(), event.getLevel().f_46443_) && event.getLevel() instanceof ServerLevel && bonemeal.m_214167_(event.getLevel(), event.getLevel().f_46441_, event.getPos(), event.getBlock())) {
            Services.POWER.getPowers((LivingEntity)event.getEntity(), ApugliPowers.ACTION_ON_BONEMEAL.get()).stream().filter(p -> p.doesApply(new BlockInWorld((LevelReader)event.getLevel(), event.getPos(), true))).forEach(p -> p.executeActions(event.getLevel(), event.getPos(), Direction.UP));
        }
    }

    @SubscribeEvent
    public static void modifyAerialBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!Services.POWER.hasPower((LivingEntity)event.getEntity(), ApugliPowers.AERIAL_AFFINITY.get()) || event.getEntity().m_20096_()) {
            return;
        }
        event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(KeyPressCapability.INSTANCE).ifPresent(KeyPressCapability::tick);
        if (event.getEntity().m_21224_()) {
            return;
        }
        InventoryUtil.forEachStack((Entity)event.getEntity(), (stackMutable, slotAccess) -> ((ItemStackAccess)slotAccess.m_142196_()).apugli$setEntity((Entity)event.getEntity()));
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CrawlingPower.tickOnceForge(player);
        }
        Services.POWER.getPowers(event.getEntity(), ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get()).forEach(p -> ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().tick(p, (Entity)event.getEntity()));
        if (ModList.get().isLoaded("pehkui") && !Services.POWER.getPowers(event.getEntity(), ApugliPowers.MODIFY_SCALE.get(), true).isEmpty()) {
            PehkuiUtil.tickScalePowers(event.getEntity());
        }
        if (Services.POWER.hasPower(event.getEntity(), ApugliPowers.HOVER.get())) {
            event.getEntity().m_20256_(event.getEntity().m_20184_().m_82542_(1.0, 0.0, 1.0));
            event.getEntity().f_19789_ = 0.0f;
        }
        if (event.getEntity().m_9236_().f_46443_) {
            Services.POWER.getPowers(event.getEntity(), ApugliPowers.CLIENT_ACTION_OVER_TIME.get()).forEach(ClientActionOverTime::clientTick);
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            event.getEntity().getCapability(HitsOnTargetCapability.INSTANCE).ifPresent(HitsOnTargetCapability::serverTick);
            ApugliPowers.BUNNY_HOP.get().onTravel(event.getEntity(), new Vec3((double)event.getEntity().f_20900_, (double)event.getEntity().f_20901_, (double)event.getEntity().f_20902_));
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onMobTargetChange(LivingChangeTargetEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        List powers = Services.POWER.getPowers(event.getOriginalTarget(), ApugliPowers.MOBS_IGNORE.get());
        if (powers.stream().anyMatch(power -> power.shouldIgnore((Entity)event.getEntity()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity;
        if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY) {
            LivingEntity living;
            Entity entity2 = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
            if (entity2 instanceof LivingEntity) {
                living = (LivingEntity)entity2;
                Services.POWER.getPowers(living, ApugliPowers.ACTION_WHEN_PROJECTILE_HIT.get()).forEach(power -> ApugliPowers.ACTION_WHEN_PROJECTILE_HIT.get().execute(power, living, event.getProjectile()));
            }
            if ((entity2 = event.getProjectile().m_19749_()) instanceof LivingEntity) {
                living = (LivingEntity)entity2;
                Services.POWER.getPowers(living, ApugliPowers.ACTION_ON_PROJECTILE_HIT.get()).forEach(power -> {
                    event.getProjectile().getCapability(EntitiesHitCapability.INSTANCE).ifPresent(cap -> cap.addHitEntity(Services.POWER.getPowerId(power)));
                    ApugliPowers.ACTION_ON_PROJECTILE_HIT.get().execute(power, living, ((EntityHitResult)event.getRayTraceResult()).m_82443_(), event.getProjectile(), event.getProjectile().getCapability(EntitiesHitCapability.INSTANCE).map(cap -> cap.getPowerValue(Services.POWER.getPowerId(power))).orElse(0));
                });
            }
        } else if (event.getRayTraceResult().m_6662_() == HitResult.Type.BLOCK && (entity = event.getProjectile().m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            List aophPowers = Services.POWER.getPowers(living, ApugliPowers.ACTION_ON_PROJECTILE_HIT.get(), true);
            aophPowers.forEach(power -> {
                if (ApugliPowers.ACTION_ON_PROJECTILE_HIT.get().canUse(power, (Entity)living) && event.getProjectile().getCapability(EntitiesHitCapability.INSTANCE).map(inst -> inst.apugli$powersThatHaveLanded().contains(Services.POWER.getPowerId(power))).orElse(false).booleanValue()) {
                    ApugliPowers.ACTION_ON_PROJECTILE_HIT.get().use(power, (Entity)living);
                }
            });
            event.getProjectile().getCapability(EntitiesHitCapability.INSTANCE).ifPresent(EntitiesHitCapability::clearHitEntities);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        float extraEnchantmentDamage = ApugliForgeEventHandler.calculateEnchantmentDamage(target, source, amount);
        float finalAmount = amount + extraEnchantmentDamage;
        event.setAmount(finalAmount);
        if (finalAmount != amount && finalAmount == 0.0f) {
            event.setCanceled(true);
        }
        if (!event.isCanceled()) {
            TamableAnimal tamable;
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                Services.POWER.getPowers(living, ApugliPowers.ACTION_ON_HARM.get()).forEach(p -> ApugliPowers.ACTION_ON_HARM.get().execute(p, living, source, amount, target));
                Services.POWER.getPowers(living, ApugliPowers.DAMAGE_NEARBY_ON_HIT.get()).forEach(p -> ApugliPowers.DAMAGE_NEARBY_ON_HIT.get().execute(p, living, source, amount, target));
            }
            Services.POWER.getPowers(target, ApugliPowers.ACTION_WHEN_HARMED.get()).forEach(p -> ApugliPowers.ACTION_WHEN_HARMED.get().execute(p, target, source, amount));
            Services.POWER.getPowers(target, ApugliPowers.DAMAGE_NEARBY_WHEN_HIT.get()).forEach(p -> ApugliPowers.DAMAGE_NEARBY_WHEN_HIT.get().execute(p, target, source, amount));
            if (target.m_21188_() != null) {
                ApugliPowers.ACTION_ON_ATTACKER_HURT.get().execute(target, source, amount);
                ApugliPowers.ACTION_ON_TARGET_HURT.get().execute(target, source, amount);
            }
            if (target instanceof TamableAnimal) {
                tamable = (TamableAnimal)target;
                ApugliPowers.ACTION_WHEN_TAME_HIT.get().execute(tamable, source, amount);
            }
            if ((entity = source.m_7639_()) instanceof TamableAnimal) {
                tamable = (TamableAnimal)entity;
                ApugliPowers.ACTION_ON_TAME_HIT.get().execute(tamable, source, amount, target);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onLivingAttack(LivingAttackEvent event) {
        Player attacker;
        float enchantmentDamageBonus;
        Entity entity;
        float amount = event.getAmount();
        float extraEnchantmentDamage = ApugliForgeEventHandler.calculateEnchantmentDamage(event.getEntity(), event.getSource(), event.getAmount());
        float finalAmount = amount + extraEnchantmentDamage;
        if (extraEnchantmentDamage > 0.0f && (entity = event.getSource().m_7639_()) instanceof Player && (enchantmentDamageBonus = EnchantmentHelper.m_44833_((ItemStack)(attacker = (Player)entity).m_21205_(), (MobType)event.getEntity().m_6336_())) <= 0.0f && !event.getEntity().m_9236_().f_46443_) {
            attacker.m_5700_((Entity)event.getEntity());
        }
        if (finalAmount != event.getAmount() && finalAmount == 0.0f) {
            event.setCanceled(true);
        }
    }

    private static float calculateEnchantmentDamage(LivingEntity powerHolder, DamageSource source, float amount) {
        LivingEntity attacker;
        float additionalValue = 0.0f;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            attacker = (LivingEntity)entity;
            if (!source.m_269014_()) {
                additionalValue += ApugliPowers.MODIFY_ENCHANTMENT_DAMAGE_DEALT.get().applyModifiers(attacker, source, amount, powerHolder);
            }
        }
        if ((entity = source.m_7639_()) instanceof LivingEntity) {
            attacker = (LivingEntity)entity;
            additionalValue += ApugliPowers.MODIFY_ENCHANTMENT_DAMAGE_TAKEN.get().applyModifiers(powerHolder, source, attacker, amount);
        }
        return additionalValue;
    }

    @SubscribeEvent
    public static void onLivingKilled(LivingDeathEvent event) {
        IPowerDataCache.get((LivingEntity)event.getEntity()).map(IPowerDataCache::getDamage).ifPresent(x -> {
            DamageSource source = event.getSource();
            Entity attacker = source.m_7639_();
            LivingEntity target = event.getEntity();
            LivingEntity killCredit = event.getEntity().m_21232_();
            if (killCredit != null && (attacker == null || attacker != killCredit)) {
                ApugliPowers.ACTION_ON_TARGET_DEATH.get().onTargetDeath(killCredit, (Entity)target, event.getSource(), x.floatValue(), true);
                return;
            }
            if (!(attacker instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)attacker;
            ApugliPowers.ACTION_ON_TARGET_DEATH.get().onTargetDeath(living, (Entity)target, source, x.floatValue(), false);
        });
    }

    @SubscribeEvent
    public static void onStartPlayerTrack(PlayerEvent.StartTracking event) {
        event.getTarget().getCapability(KeyPressCapability.INSTANCE).ifPresent(KeyPressCapability::sync);
        event.getTarget().getCapability(HitsOnTargetCapability.INSTANCE).ifPresent(HitsOnTargetCapability::sync);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onMobInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        int i;
        Animal animal;
        Entity entity;
        List<PreventBreedingPower> preventBreedingPowerList = Services.POWER.getPowers((LivingEntity)event.getEntity(), ApugliPowers.PREVENT_BREEDING.get()).stream().filter(power -> power.doesApply(event.getTarget())).collect(Collectors.toList());
        if (!preventBreedingPowerList.isEmpty() && (entity = event.getTarget()) instanceof Animal && (animal = (Animal)entity).m_6898_(event.getItemStack()) && (i = animal.m_146764_()) == 0 && animal.m_5957_()) {
            if (preventBreedingPowerList.stream().anyMatch(PreventBreedingPower::hasAction)) {
                preventBreedingPowerList.forEach(power -> power.executeAction(event.getTarget()));
                animal.m_27601_((int)Services.PLATFORM.applyModifiers((LivingEntity)event.getEntity(), ApugliPowers.MODIFY_BREEDING_COOLDOWN.get(), 6000.0));
                event.setResult(Event.Result.ALLOW);
                event.setCanceled(true);
            } else {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getEntity().getCapability(KeyPressCapability.INSTANCE).ifPresent(cap -> event.getOriginal().getCapability(KeyPressCapability.INSTANCE).ifPresent(cap::setFrom));
        event.getEntity().getCapability(HitsOnTargetCapability.INSTANCE).ifPresent(cap -> event.getOriginal().getCapability(HitsOnTargetCapability.INSTANCE).ifPresent(cap::setFrom));
    }

    @SubscribeEvent
    public static void prePowerLoad(AddReloadListenerEvent event) {
        TextureUtil.getCache().clear();
    }

    @SubscribeEvent
    public static void postPowerLoad(PowerLoadEvent.Post event) {
        ApugliForgeEventHandler.handleUrlPower(event.getId(), event.getPower());
    }

    private static void handleUrlPower(ResourceLocation id, ConfiguredPower<?, ?> power) {
        TextureOrUrlPower texturePower;
        Object object;
        if (power.getFactory() instanceof FabricPowerFactory && (object = ((FabricPowerFactoryAccessor)power.getFactory()).apugli$invokeGetPower(power, null)) instanceof TextureOrUrlPower && (texturePower = (TextureOrUrlPower)((Object)object)).getTextureUrl() != null) {
            TextureUtil.cachePower(id, texturePower);
        } else {
            object = power.getFactory();
            if (object instanceof CustomProjectilePower) {
                CustomProjectilePower projectilePower = (CustomProjectilePower)object;
                if (ApugliPowers.CUSTOM_PROJECTILE.get().getDataFromPower(power).isPresent("texture_url")) {
                    ApugliPowers.CUSTOM_PROJECTILE.get().cacheTextureUrl(id, projectilePower);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ApugliPacketHandler.sendS2C(new UpdateUrlTexturesPacket(TextureUtil.getCache()), event.getPlayer());
    }
}

