/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.item.custom;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SanctumCompassItem
extends ProjectileWeaponItem {
    public static final String STRUCTURE_POS = "StructurePos";
    public static final String STRUCTURE_DIMENSION = "StructureDimension";
    public static final String TRACKED_STRUCTURE = "TrackedStructure";
    public static final String IS_ACTIVE = "IsActive";
    private int cooldown = 4800;

    public SanctumCompassItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_150930_((Item)JNEItems.WRAITHING_FLESH.get());
    }

    public int m_6615_() {
        return 15;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        CompoundTag nbt = stack.m_41784_();
        boolean isActive = nbt.m_128471_(IS_ACTIVE);
        if (!level.m_5776_() && isActive) {
            --this.cooldown;
            if (this.cooldown <= 0) {
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12104_, SoundSource.PLAYERS, 0.7f, 1.0f);
                nbt.m_128473_("CustomModelData");
                nbt.m_128379_(IS_ACTIVE, false);
                this.cooldown = 4800;
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = stack.m_41784_();
        boolean isActive = nbt.m_128471_(IS_ACTIVE);
        boolean trackedStructure = nbt.m_128471_(TRACKED_STRUCTURE);
        if (!isActive) {
            player.m_6672_(hand);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!trackedStructure) {
                    BlockPos structurePos = serverLevel.m_215011_(JNETags.Structures.SANCTUM_COMPASS_LOCATED, player.m_20183_(), 100, false);
                    if (structurePos != null) {
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 0.7f, 1.0f);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        player.m_21011_(hand, true);
                        nbt.m_128379_(TRACKED_STRUCTURE, true);
                        nbt.m_128365_(STRUCTURE_POS, (Tag)NbtUtils.m_129224_((BlockPos)structurePos));
                        DataResult structureDimension = Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)level.m_46472_());
                        structureDimension.result().ifPresent(currentDimension -> nbt.m_128365_(STRUCTURE_DIMENSION, currentDimension));
                        this.useWraithingFlesh(stack, (LivingEntity)player);
                        nbt.m_128405_("CustomModelData", 1);
                        nbt.m_128379_(IS_ACTIVE, true);
                        JNECriteriaTriggers.ACTIVATE_SANCTUM_COMPASS.m_222618_((ServerPlayer)player);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 0.7f, 1.0f);
                    this.useWraithingFlesh(stack, (LivingEntity)player);
                    nbt.m_128405_("CustomModelData", 1);
                    nbt.m_128379_(IS_ACTIVE, true);
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Nullable
    public static GlobalPos getStructurePosition(CompoundTag nbt) {
        Optional<ResourceKey<Level>> currentDimension;
        boolean pos = nbt.m_128441_(STRUCTURE_POS);
        boolean dimension = nbt.m_128441_(STRUCTURE_DIMENSION);
        if (pos && dimension && (currentDimension = SanctumCompassItem.getStructureDimension(nbt)).isPresent()) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(STRUCTURE_POS));
            return GlobalPos.m_122643_(currentDimension.get(), (BlockPos)blockPos);
        }
        return null;
    }

    private static Optional<ResourceKey<Level>> getStructureDimension(CompoundTag arg) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)arg.m_128423_(STRUCTURE_DIMENSION)).result();
    }

    private void useWraithingFlesh(ItemStack stack, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            boolean creative = player.m_150110_().f_35937_;
            ItemStack projectileStack = player.m_6298_(stack);
            if (!projectileStack.m_41619_() || creative) {
                boolean bl;
                if (projectileStack.m_41619_()) {
                    projectileStack = new ItemStack((ItemLike)JNEItems.WRAITHING_FLESH.get());
                }
                boolean bl2 = bl = projectileStack.m_41720_() == JNEItems.WRAITHING_FLESH.get();
                if (bl && !creative) {
                    projectileStack.m_41774_(1);
                    if (projectileStack.m_41619_()) {
                        player.m_150109_().m_36057_(projectileStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_(TRACKED_STRUCTURE)) {
            tooltip.add((Component)Component.m_237115_((String)"sanctum_compass.tracking").m_130940_(ChatFormatting.GRAY));
        }
        if (!nbt.m_128471_(IS_ACTIVE)) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"sanctum_compass.to_activate").m_130940_(ChatFormatting.BLUE));
            tooltip.add((Component)Component.m_237115_((String)"item.netherexp.wraithing_flesh").m_130940_(ChatFormatting.DARK_PURPLE));
        }
    }
}

