/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.fluid;

import dev.architectury.core.fluid.ArchitecturyFlowingFluid;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.core.fluid.SimpleArchitecturyFluidAttributes;
import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.block.custom.EctoplasmLiquidBlock;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class JNEFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((String)"netherexp", (ResourceKey)Registries.f_256808_);
    public static final RegistrySupplier<FlowingFluid> ECTOPLASM = FLUIDS.register("ectoplasm", () -> new ArchitecturyFlowingFluid.Source(ECTOPLASM_ATTRIBUTE){

        protected void m_213811_(Level level, BlockPos pos, FluidState state, RandomSource random) {
            JNEFluids.ectoplasmParticles(level, pos, random);
        }
    });
    public static final RegistrySupplier<FlowingFluid> FLOWING_ECTOPLASM = FLUIDS.register("flowing_ectoplasm", () -> new ArchitecturyFlowingFluid.Flowing(ECTOPLASM_ATTRIBUTE));
    public static final RegistrySupplier<LiquidBlock> ECTOPLASM_BLOCK = JNEBlocks.BLOCKS.register("ectoplasm", () -> new EctoplasmLiquidBlock((Supplier<? extends FlowingFluid>)ECTOPLASM, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283869_).m_280170_().m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_60953_(state -> 7).m_222994_().m_278788_().m_60918_(SoundType.f_279557_)));
    public static final RegistrySupplier<Item> ECTOPLASM_BUCKET = JNEItems.ITEMS.register("ectoplasm_bucket", () -> new ArchitecturyBucketItem(ECTOPLASM, new Item.Properties().m_41487_(1)));
    public static final ArchitecturyFluidAttributes ECTOPLASM_ATTRIBUTE = SimpleArchitecturyFluidAttributes.ofSupplier(() -> FLOWING_ECTOPLASM, () -> ECTOPLASM).convertToSource(true).slopeFindDistance(4).dropOff(1).tickDelay(5).explosionResistance(100.0f).luminosity(15).density(-1).temperature(50).viscosity(2000).lighterThanAir(false).sourceTexture(new ResourceLocation("netherexp:block/ectoplasm_still")).flowingTexture(new ResourceLocation("netherexp:block/ectoplasm_flow")).overlayTexture(new ResourceLocation("netherexp:textures/block/ectoplasm_overlay.png")).color(0xFFFFFF).rarity(Rarity.COMMON).blockSupplier(() -> ECTOPLASM_BLOCK).bucketItemSupplier(() -> ECTOPLASM_BUCKET);

    private static void ectoplasmParticles(Level level, BlockPos pos, RandomSource random) {
        BlockPos abovePos = pos.m_7494_();
        if (level.m_8055_(abovePos).m_60795_() && !level.m_8055_(abovePos).m_60804_((BlockGetter)level, abovePos) && JNEConfigs.ENABLE_ECTOPLASM_PARTICLES.get().booleanValue()) {
            double f;
            double e;
            double d;
            if (random.m_188503_(55) == 0) {
                d = (double)pos.m_123341_() + random.m_188500_();
                e = (double)pos.m_123342_() + 1.0;
                f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)JNEParticleTypes.ECTORAYS.get(), d, e, f, 0.0, -0.03, 0.0);
            }
            if (random.m_188503_(18) == 0 && JNEConfigs.ENABLE_ECTOPLASM_PARTICLES.get().booleanValue()) {
                d = (double)pos.m_123341_() + random.m_188500_();
                e = (double)pos.m_123342_() + 1.0;
                f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)JNEParticleTypes.ECTOPLASMA.get(), d, e, f, 0.0, 0.0, 0.0);
            }
            if (random.m_188503_(600) == 0 && JNEConfigs.ENABLE_ECTOPLASM_SOUNDS.get().booleanValue()) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)JNESoundEvents.ECTOPLASM_WHISPERING.get(), SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    public static void init() {
        FLUIDS.register();
    }
}

