/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.EnumSet;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.block.custom.EctoSoulSandBlock;
import net.jadenxgamer.netherexp.registry.entity.custom.Bottleable;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wisp
extends AgeableMob
implements FlyingAnimal,
Bottleable {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    public int boredDelay = 1000;
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.m_135353_(Wisp.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SALTED = SynchedEntityData.m_135353_(Wisp.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Wisp(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.f_21364_ = 1;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.isMoving()) {
                this.idleAnimationState.m_216973_();
                this.walkAnimationState.m_216982_(this.f_19797_);
            } else {
                this.walkAnimationState.m_216973_();
                this.idleAnimationState.m_216982_(this.f_19797_);
            }
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_165924_() > (double)0.01f;
    }

    public boolean m_29443_() {
        return true;
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(false);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        this.f_19789_ = 0.0f;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6126_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AgeableMob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22280_, 1.2).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42053_}), false));
        this.f_21345_.m_25352_(3, new WispAvoidEntityGoal<Piglin>(this, Piglin.class, 8.0f, 0.4, 0.8));
        this.f_21345_.m_25352_(3, new WispAvoidEntityGoal<PiglinBrute>(this, PiglinBrute.class, 8.0f, 0.4, 0.8));
        this.f_21345_.m_25352_(3, new WispAvoidEntityGoal<Hoglin>(this, Hoglin.class, 8.0f, 0.4, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new BurrowInSoulSandGoal(this, 16));
        this.f_21345_.m_25352_(4, (Goal)new WispWanderAroundGoal());
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.getBoredDelay() > 0 && !this.getSalted()) {
                --this.boredDelay;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.WISP.get(), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BOTTLE, (Object)false);
        this.f_19804_.m_135372_(SALTED, (Object)false);
    }

    public void setBoredDelay(int boredDelay) {
        this.boredDelay = boredDelay;
    }

    public int getBoredDelay() {
        return this.boredDelay;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("FromBottle", this.fromBottle());
        nbt.m_128379_("Salted", this.getSalted());
        nbt.m_128405_("BoredDelay", this.boredDelay);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setFromBottle(nbt.m_128471_("FromBottle"));
        this.setSalted(nbt.m_128471_("Salted"));
        this.boredDelay = nbt.m_128451_("BoredDelay");
    }

    @Override
    public boolean fromBottle() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOTTLE);
    }

    @Override
    public void setFromBottle(boolean bl) {
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)bl);
    }

    public boolean getSalted() {
        return (Boolean)this.f_19804_.m_135370_(SALTED);
    }

    public void setSalted(boolean bl) {
        this.f_19804_.m_135381_(SALTED, (Object)bl);
    }

    @Override
    public void saveToBottleTag(ItemStack stack) {
        Bottleable.saveDefaultDataToBottleTag((Mob)this, stack);
    }

    @Override
    public void loadFromBottleTag(CompoundTag nbt) {
        Bottleable.loadDefaultDataFromBottleTag((Mob)this, nbt);
    }

    @Override
    public ItemStack getBottleItemStack() {
        return new ItemStack((ItemLike)JNEItems.WISP_BOTTLE.get());
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.f_11770_;
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_(Items.f_42784_) && !this.getSalted()) {
            if (!this.m_9236_().f_46443_) {
                this.setSalted(true);
                itemStack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            return InteractionResult.CONSUME;
        }
        return Bottleable.bottleMobPickup(player, interactionHand, this).orElse(super.m_6071_(player, interactionHand));
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.getSalted();
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.getSalted() && !this.m_8077_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JNESoundEvents.ENTITY_WISP_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JNESoundEvents.ENTITY_WISP_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JNESoundEvents.ENTITY_WISP_HURT.get();
    }

    static class WispAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public WispAvoidEntityGoal(Wisp wisp, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super((PathfinderMob)wisp, fleeFromType, distance, slowSpeed, fastSpeed);
        }
    }

    static class BurrowInSoulSandGoal
    extends MoveToBlockGoal {
        private final Wisp wisp;

        public BurrowInSoulSandGoal(Wisp entity, int range) {
            super((PathfinderMob)entity, 1.0, range, range);
            this.wisp = entity;
        }

        public double m_8052_() {
            return 2.0;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState blockState = level.m_8055_(pos);
            return blockState.m_60713_(Blocks.f_50135_);
        }

        @NotNull
        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos target = this.m_6669_();
            Level level = this.wisp.m_9236_();
            if (this.m_25625_()) {
                level.m_7731_(target, (BlockState)((Block)JNEBlocks.ECTO_SOUL_SAND.get()).m_49966_().m_61124_((Property)EctoSoulSandBlock.SALTED, (Comparable)Boolean.valueOf(false)), 2);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.wisp.m_20185_(), this.wisp.m_20186_(), this.wisp.m_20189_(), 0.0, 0.0, 0.0);
                this.wisp.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }

        public boolean m_8036_() {
            return this.wisp.getBoredDelay() == 0 && !this.wisp.getSalted() && super.m_8036_();
        }

        public boolean m_8045_() {
            BlockPos target = this.m_6669_();
            return this.wisp.m_9236_().m_8055_(target).m_60713_(Blocks.f_50135_) && super.m_8045_();
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    class WispWanderAroundGoal
    extends Goal {
        WispWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Wisp.this.f_21344_.m_26571_() && Wisp.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return Wisp.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.getRandomLocation();
            if (vec3 != null) {
                Wisp.this.f_21344_.m_26536_(Wisp.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2 = Wisp.this.m_20252_(0.0f);
            Vec3 vec3d3 = HoverRandomPos.m_148465_((PathfinderMob)Wisp.this, (int)8, (int)7, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Wisp.this, (int)8, (int)4, (int)-2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (double)1.5707963705062866);
        }
    }
}

