/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Carcass
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> IS_REANIMATED = SynchedEntityData.m_135353_(Carcass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> REANIMATION_COOLDOWN = SynchedEntityData.m_135353_(Carcass.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> REANIMATION_FLAG = SynchedEntityData.m_135353_(Carcass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState moveAnimationState = new AnimationState();
    public final AnimationState reanimateAnimationState = new AnimationState();
    public final AnimationState deactivateAnimationState = new AnimationState();
    private int deactivationAnimationTimer = 25;
    private int reanimationAnimationTimer = 22;

    public Carcass(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getReanimationFlag()) {
            this.reanimateCarcass();
        }
        if (this.getIsReanimated() && this.m_21223_() <= 0.0f) {
            this.deactivateCarcass();
        }
        if (this.m_9236_().f_46443_) {
            if (this.getIsReanimated()) {
                if (this.isMoving()) {
                    this.idleAnimationState.m_216973_();
                    this.moveAnimationState.m_216982_(this.f_19797_);
                } else {
                    this.moveAnimationState.m_216973_();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                }
            } else if (!this.getIsReanimated() && !this.getReanimationFlag() && this.deactivationAnimationTimer == 25) {
                this.deactivateAnimationState.m_216982_(this.f_19797_);
                this.idleAnimationState.m_216973_();
                this.moveAnimationState.m_216973_();
            }
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_165924_() > (double)0.01f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.21000000417232512).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CarcassMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new CarcassMoveTowardsTargetGoal(this, 0.9, 32.0f));
        this.f_21345_.m_25352_(7, (Goal)new CarcassLookAtPlayerGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new CarcassRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new CarcassRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof Enemy && !(livingEntity instanceof Creeper)));
    }

    public boolean m_21224_() {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (!this.getIsReanimated()) {
            Projectile projectile;
            if (damageSource.m_19390_() || damageSource.m_269533_(DamageTypeTags.f_268738_)) {
                this.m_146870_();
                return true;
            }
            Entity entity = damageSource.m_7640_();
            if (entity instanceof Projectile && (projectile = (Projectile)entity).m_6060_()) {
                this.setReanimationFlag(true);
            } else {
                return false;
            }
        }
        return super.m_6469_(damageSource, f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.deactivateAnimationState.m_216982_(this.f_19797_);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public boolean m_21515_() {
        return super.m_21515_();
    }

    private void reanimateCarcass() {
        if (this.reanimationAnimationTimer == 22) {
            this.reanimateAnimationState.m_216982_(this.f_19797_);
            this.deactivateAnimationState.m_216973_();
        }
        if (this.reanimationAnimationTimer > 0) {
            --this.reanimationAnimationTimer;
        }
        if (this.reanimationAnimationTimer <= 0) {
            this.reanimateAnimationState.m_216973_();
            this.setIsReanimated(true);
            this.setReanimationFlag(false);
            this.reanimationAnimationTimer = 22;
        }
    }

    private void deactivateCarcass() {
        this.idleAnimationState.m_216973_();
        this.moveAnimationState.m_216973_();
        this.reanimateAnimationState.m_216973_();
        if (this.deactivationAnimationTimer > 0) {
            --this.deactivationAnimationTimer;
        }
        if (this.deactivationAnimationTimer <= 0) {
            this.setIsReanimated(false);
            this.m_21153_(this.m_21233_());
            this.setReanimationCooldown(36000);
            this.deactivationAnimationTimer = 25;
            this.idleAnimationState.m_216973_();
            this.moveAnimationState.m_216973_();
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42409_) && !this.getIsReanimated()) {
            this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.setReanimationFlag(true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                JNECriteriaTriggers.REVIVE_CARCASS.m_222618_(serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42613_) && !this.getIsReanimated()) {
            this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.setReanimationFlag(true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                JNECriteriaTriggers.REVIVE_CARCASS.m_222618_(serverPlayer);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_REANIMATED, (Object)false);
        this.f_19804_.m_135372_(REANIMATION_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(REANIMATION_FLAG, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("IsReanimated", this.getIsReanimated());
        nbt.m_128405_("ReanimationCooldown", this.getReanimationCooldown());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setIsReanimated(nbt.m_128471_("IsReanimated"));
        this.setReanimationCooldown(nbt.m_128451_("ReanimationCooldown"));
    }

    public boolean getIsReanimated() {
        return (Boolean)this.f_19804_.m_135370_(IS_REANIMATED);
    }

    public void setIsReanimated(boolean reanimated) {
        this.f_19804_.m_135381_(IS_REANIMATED, (Object)reanimated);
    }

    public int getReanimationCooldown() {
        return (Integer)this.f_19804_.m_135370_(REANIMATION_COOLDOWN);
    }

    public void setReanimationCooldown(int cooldown) {
        this.f_19804_.m_135381_(REANIMATION_COOLDOWN, (Object)cooldown);
    }

    public boolean getReanimationFlag() {
        return (Boolean)this.f_19804_.m_135370_(REANIMATION_FLAG);
    }

    public void setReanimationFlag(boolean flag) {
        this.f_19804_.m_135381_(REANIMATION_FLAG, (Object)flag);
    }

    private static class CarcassMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Carcass carcass;

        public CarcassMeleeAttackGoal(Carcass carcass, double d, boolean bl) {
            super((PathfinderMob)carcass, d, bl);
            this.carcass = carcass;
        }

        public boolean m_8036_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    private static class CarcassMoveTowardsTargetGoal
    extends MoveTowardsTargetGoal {
        private final Carcass carcass;

        public CarcassMoveTowardsTargetGoal(Carcass carcass, double d, float f) {
            super((PathfinderMob)carcass, d, f);
            this.carcass = carcass;
        }

        public boolean m_8036_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    private static class CarcassLookAtPlayerGoal
    extends LookAtPlayerGoal {
        private final Carcass carcass;

        public CarcassLookAtPlayerGoal(Carcass carcass, Class<? extends LivingEntity> entity, float f) {
            super((Mob)carcass, entity, f);
            this.carcass = carcass;
        }

        public boolean m_8036_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    private static class CarcassRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        private final Carcass carcass;

        public CarcassRandomStrollGoal(Carcass carcass, double d) {
            super((PathfinderMob)carcass, d);
            this.carcass = carcass;
        }

        public boolean m_8036_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    private static class CarcassRandomLookAroundGoal
    extends RandomLookAroundGoal {
        private final Carcass carcass;

        public CarcassRandomLookAroundGoal(Carcass carcass) {
            super((Mob)carcass);
            this.carcass = carcass;
        }

        public boolean m_8036_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (!this.carcass.getIsReanimated()) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

