/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.block.custom.GargoyleStatueBlock;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Banshee;
import net.jadenxgamer.netherexp.registry.entity.custom.EctoSlab;
import net.jadenxgamer.netherexp.registry.entity.custom.Stampede;
import net.jadenxgamer.netherexp.registry.entity.custom.Vessel;
import net.jadenxgamer.netherexp.registry.entity.custom.Wisp;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Apparition
extends Monster
implements FlyingAnimal {
    public int cooldown = 0;
    private static final EntityDataAccessor<Integer> PREFERENCE = SynchedEntityData.m_135353_(Apparition.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idle1AnimationState = new AnimationState();
    public final AnimationState walk1AnimationState = new AnimationState();
    public final AnimationState idle2AnimationState = new AnimationState();
    public final AnimationState walk2AnimationState = new AnimationState();
    public final AnimationState idle3AnimationState = new AnimationState();
    public final AnimationState walk3AnimationState = new AnimationState();
    public final AnimationState idle4AnimationState = new AnimationState();
    public final AnimationState walk4AnimationState = new AnimationState();

    public Apparition(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            AnimationState idle;
            AnimationState walk = switch (this.getPreference()) {
                default -> {
                    idle = this.idle1AnimationState;
                    yield this.walk1AnimationState;
                }
                case 2 -> {
                    idle = this.idle2AnimationState;
                    yield this.walk2AnimationState;
                }
                case 3 -> {
                    idle = this.idle3AnimationState;
                    yield this.walk3AnimationState;
                }
                case 4 -> {
                    idle = this.idle4AnimationState;
                    yield this.walk4AnimationState;
                }
            };
            if (this.isMoving()) {
                idle.m_216973_();
                walk.m_216982_(this.f_19797_);
            } else {
                walk.m_216973_();
                idle.m_216982_(this.f_19797_);
            }
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    private boolean isMoving() {
        return this.m_20184_().m_165924_() > (double)0.01f;
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(false);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        this.f_19789_ = 0.0f;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    public boolean m_29443_() {
        return true;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6126_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22280_, 0.8).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.getCooldown() > 0) {
            --this.cooldown;
        }
        if (this.f_19796_.m_188503_(30) == 0) {
            this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_APPARITION_FLY.get(), 0.15f, 1.0f);
        }
        super.m_8107_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PossessGargoyleStatueGoal(this, 12));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new ApparitionWanderAroundGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (this.getPreference() == 0) {
            this.setPreference(Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)4));
        }
        if (level instanceof ServerLevel) {
            this.activePreferredTargetGoal();
        }
        return super.m_6518_(level, difficulty, mobSpawnType, spawnGroupData, compoundTag);
    }

    private void activePreferredTargetGoal() {
        int p = this.getPreference();
        if (p == 1) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, true));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        } else if (p == 2) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Strider.class, true));
        } else if (p == 3) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, true));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
            this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        } else if (p == 4) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Blaze.class, true));
            this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
            this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
    }

    private boolean hurtWithCleanWater(ThrownPotion thrownPotion) {
        ItemStack itemStack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        return potion == Potions.f_43599_ && list.isEmpty();
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        ThrownPotion thrownPotion;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownPotion && this.hurtWithCleanWater(thrownPotion = (ThrownPotion)entity)) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.m_146870_();
        }
        return super.m_6469_(damageSource, f);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        for (int i = 0; i < this.m_9236_().m_213780_().m_188503_(2) + 1; ++i) {
            Wisp wisp = (Wisp)((EntityType)JNEEntityType.WISP.get()).m_20615_(this.m_9236_());
            if (wisp == null) continue;
            wisp.setBoredDelay(0);
            wisp.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_7967_((Entity)wisp);
        }
    }

    public boolean m_214076_(ServerLevel serverLevel, LivingEntity livingEntity) {
        Blaze blaze;
        Banshee banshee;
        if (livingEntity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)livingEntity;
            Vessel vessel = (Vessel)skeleton.m_21406_((EntityType)JNEEntityType.VESSEL.get(), false);
            if (vessel != null) {
                vessel.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(vessel.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
                if (skeleton.m_8077_()) {
                    vessel.m_6593_(skeleton.m_7770_());
                }
                this.m_146870_();
                return false;
            }
        } else if (livingEntity instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)livingEntity;
            EctoSlab ectoSlab = (EctoSlab)((EntityType)JNEEntityType.ECTO_SLAB.get()).m_20615_(this.m_9236_());
            if (ectoSlab != null) {
                ectoSlab.m_7839_(magmaCube.m_33632_(), true);
                ectoSlab.m_146884_(this.m_20182_());
                if (magmaCube.m_8077_()) {
                    ectoSlab.m_6593_(magmaCube.m_7770_());
                }
                this.m_9236_().m_7967_((Entity)ectoSlab);
                this.m_146870_();
                magmaCube.m_146870_();
                return false;
            }
        } else if (livingEntity instanceof Strider) {
            Strider strider = (Strider)livingEntity;
            Stampede stampede = (Stampede)strider.m_21406_((EntityType)JNEEntityType.STAMPEDE.get(), false);
            if (stampede != null) {
                stampede.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(stampede.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
                if (strider.m_8077_()) {
                    stampede.m_6593_(strider.m_7770_());
                }
                this.m_146870_();
                return false;
            }
        } else if (livingEntity instanceof Blaze && (banshee = (Banshee)(blaze = (Blaze)livingEntity).m_21406_((EntityType)JNEEntityType.BANSHEE.get(), false)) != null) {
            banshee.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(banshee.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
            if (blaze.m_8077_()) {
                banshee.m_6593_(blaze.m_7770_());
            }
            this.m_146870_();
            return false;
        }
        return super.m_214076_(serverLevel, livingEntity);
    }

    public boolean m_7327_(Entity entity) {
        this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_APPARITION_ATTACK.get(), 1.0f, 1.0f);
        return super.m_7327_(entity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREFERENCE, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Preference", this.getPreference());
        nbt.m_128405_("Cooldown", this.cooldown);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setPreference(nbt.m_128451_("Preference"));
        this.cooldown = nbt.m_128451_("Cooldown");
    }

    public int getPreference() {
        return (Integer)this.f_19804_.m_135370_(PREFERENCE);
    }

    public void setPreference(int preference) {
        this.f_19804_.m_135381_(PREFERENCE, (Object)preference);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JNESoundEvents.ENTITY_APPARITION_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JNESoundEvents.ENTITY_APPARITION_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_APPARITION_FLY.get(), 0.15f, 1.0f);
    }

    static class PossessGargoyleStatueGoal
    extends MoveToBlockGoal {
        private final Apparition apparition;

        public PossessGargoyleStatueGoal(Apparition entity, int range) {
            super((PathfinderMob)entity, 1.0, range, range);
            this.apparition = entity;
        }

        public double m_8052_() {
            return 2.0;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState blockState = level.m_8055_(pos);
            return blockState.m_204336_(JNETags.Blocks.POSSESSABLE_GARGOYLE_STATUES) && (Boolean)blockState.m_61143_((Property)GargoyleStatueBlock.SALTED) == false;
        }

        @NotNull
        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos target = this.m_6669_();
            Level level = this.apparition.m_9236_();
            RandomSource random = level.f_46441_;
            if (this.m_25625_()) {
                Direction[] var5;
                if (level.m_8055_(target).m_60713_((Block)JNEBlocks.PHASE_GARGOYLE_STATUE.get())) {
                    EctoSlab ectoSlab = (EctoSlab)((EntityType)JNEEntityType.ECTO_SLAB.get()).m_20615_(level);
                    if (ectoSlab != null) {
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            ectoSlab.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(this.f_25602_), MobSpawnType.MOB_SUMMONED, null, null);
                        }
                        ectoSlab.m_6034_(this.apparition.m_20185_(), this.apparition.m_20186_(), this.apparition.m_20189_());
                        ectoSlab.m_7839_(4, true);
                        ectoSlab.setChangeType(0);
                        if (this.apparition.m_8077_()) {
                            ectoSlab.m_6593_(this.apparition.m_7770_());
                        }
                        level.m_7967_((Entity)ectoSlab);
                    }
                } else if (level.m_8055_(target).m_60713_((Block)JNEBlocks.GHOUL_GARGOYLE_STATUE.get())) {
                    Banshee banshee = (Banshee)((EntityType)JNEEntityType.BANSHEE.get()).m_20615_(level);
                    if (banshee != null) {
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            banshee.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(this.f_25602_), MobSpawnType.MOB_SUMMONED, null, null);
                        }
                        banshee.m_6034_(this.apparition.m_20185_(), this.apparition.m_20186_(), this.apparition.m_20189_());
                        banshee.setChangeType(0);
                        if (this.apparition.m_8077_()) {
                            banshee.m_6593_(this.apparition.m_7770_());
                        }
                        level.m_7967_((Entity)banshee);
                    }
                } else if (level.m_8055_(target).m_60713_((Block)JNEBlocks.TRAMPLE_GARGOYLE_STATUE.get()) && this.apparition.getPreference() == 2) {
                    Stampede stampede = (Stampede)((EntityType)JNEEntityType.STAMPEDE.get()).m_20615_(level);
                    if (stampede != null) {
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            stampede.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(this.f_25602_), MobSpawnType.MOB_SUMMONED, null, null);
                        }
                        stampede.m_6034_(this.apparition.m_20185_(), this.apparition.m_20186_(), this.apparition.m_20189_());
                        stampede.setChangeType(0);
                        if (this.apparition.m_8077_()) {
                            stampede.m_6593_(this.apparition.m_7770_());
                        }
                        level.m_7967_((Entity)stampede);
                    }
                } else {
                    Vessel vessel = (Vessel)((EntityType)JNEEntityType.VESSEL.get()).m_20615_(level);
                    if (vessel != null) {
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            vessel.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(this.f_25602_), MobSpawnType.MOB_SUMMONED, null, null);
                        }
                        vessel.m_6034_(this.apparition.m_20185_(), this.apparition.m_20186_(), this.apparition.m_20189_());
                        vessel.setChangeType(0);
                        if (this.apparition.m_8077_()) {
                            vessel.m_6593_(this.apparition.m_7770_());
                        }
                        level.m_7967_((Entity)vessel);
                    }
                }
                this.apparition.m_142687_(Entity.RemovalReason.DISCARDED);
                for (Direction direction : var5 = Direction.values()) {
                    BlockPos directionPos = this.f_25602_.m_121945_(direction);
                    if (level.m_8055_(directionPos).m_60804_((BlockGetter)level, directionPos)) continue;
                    Direction.Axis axis = direction.m_122434_();
                    double e = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
                    double f = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.m_188501_();
                    double g = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)target.m_123341_() + e, (double)target.m_123342_() + f, (double)target.m_123343_() + g, 0.0, 0.0, 0.0);
                }
            }
        }

        public boolean m_8036_() {
            return this.apparition.getCooldown() <= 0 && super.m_8036_();
        }

        public boolean m_8045_() {
            BlockPos target = this.m_6669_();
            BlockState blockState = this.apparition.m_9236_().m_8055_(target);
            return blockState.m_204336_(JNETags.Blocks.POSSESSABLE_GARGOYLE_STATUES) && (Boolean)blockState.m_61143_((Property)GargoyleStatueBlock.SALTED) == false && super.m_8045_();
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    class ApparitionWanderAroundGoal
    extends Goal {
        ApparitionWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Apparition.this.f_21344_.m_26571_() && Apparition.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return Apparition.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.getRandomLocation();
            if (vec3 != null) {
                Apparition.this.f_21344_.m_26536_(Apparition.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2 = Apparition.this.m_20252_(0.0f);
            Vec3 vec3d3 = HoverRandomPos.m_148465_((PathfinderMob)Apparition.this, (int)8, (int)7, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Apparition.this, (int)8, (int)4, (int)-2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (double)1.5707963705062866);
        }
    }
}

