/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlockEntityType;
import net.jadenxgamer.netherexp.registry.block.custom.TreacherousCandleBlock;
import net.jadenxgamer.netherexp.registry.effect.JNEMobEffects;
import net.jadenxgamer.netherexp.registry.entity.ai.AttackTreacherousCandleGoal;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TreacherousCandleBlockEntity
extends BlockEntity {
    private int fireRewarded = 1;
    private int maximumWaves = 5;
    private int currentWave = 1;
    private int maximumWaveDelay = 650;
    private int currentWaveDelay = 80;
    private int spawnRadius = 8;
    private int mobsPerWave = 4;
    private int resetMobsPerWave = 4;
    private int increaseInMobsPerWave = 2;
    private int health = 20;
    private int maximumHealth = 20;
    private int completionCooldown = JNEConfigs.TREACHEROUS_CANDLE_COMPLETION_COOLDOWN.get() * 20;
    private int playersNearby = 1;
    private List<EntityType<?>> spawnableMobs = new ArrayList();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"treacherous_candle.health"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);

    public TreacherousCandleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)JNEBlockEntityType.TREACHEROUS_CANDLE.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fireRewarded = nbt.m_128451_("FireRewarded");
        this.maximumWaves = nbt.m_128451_("MaximumWaves");
        this.currentWave = nbt.m_128451_("CurrentWave");
        this.maximumWaveDelay = nbt.m_128451_("MaximumWaveDelay");
        this.currentWaveDelay = nbt.m_128451_("CurrentWaveDelay");
        this.spawnRadius = nbt.m_128451_("SpawnRadius");
        this.mobsPerWave = nbt.m_128451_("MobsPerWave");
        this.resetMobsPerWave = nbt.m_128451_("ResetMobsPerWave");
        this.increaseInMobsPerWave = nbt.m_128451_("IncreaseInMobsPerWave");
        this.health = nbt.m_128451_("Health");
        this.maximumHealth = nbt.m_128451_("MaximumHealth");
        this.completionCooldown = nbt.m_128451_("CompletionCooldown");
        this.playersNearby = nbt.m_128451_("PlayersNearby");
        this.spawnableMobs.clear();
        ListTag mobsListTag = nbt.m_128437_("SpawnableMobs", 8);
        for (int i = 0; i < mobsListTag.size(); ++i) {
            String mobTypeString = mobsListTag.m_128778_(i);
            EntityType.m_20632_((String)mobTypeString).ifPresent(entityType -> this.spawnableMobs.add((EntityType<?>)entityType));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("FireRewarded", this.fireRewarded);
        nbt.m_128405_("MaximumWaves", this.maximumWaves);
        nbt.m_128405_("CurrentWave", this.currentWave);
        nbt.m_128405_("MaximumWaveDelay", this.maximumWaveDelay);
        nbt.m_128405_("CurrentWaveDelay", this.currentWaveDelay);
        nbt.m_128405_("MobsPerWave", this.mobsPerWave);
        nbt.m_128405_("ResetMobsPerWave", this.resetMobsPerWave);
        nbt.m_128405_("IncreaseInMobsPerWave", this.increaseInMobsPerWave);
        nbt.m_128405_("SpawnRadius", this.spawnRadius);
        nbt.m_128405_("Health", this.health);
        nbt.m_128405_("MaximumHealth", this.maximumHealth);
        nbt.m_128405_("CompletionCooldown", this.completionCooldown);
        nbt.m_128405_("PlayersNearby", this.playersNearby);
        ListTag mobsListTag = new ListTag();
        for (EntityType<?> entityType : this.spawnableMobs) {
            mobsListTag.add((Object)StringTag.m_129297_((String)EntityType.m_20613_(entityType).toString()));
        }
        nbt.m_128365_("SpawnableMobs", (Tag)mobsListTag);
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TreacherousCandleBlockEntity blockEntity) {
        boolean isCompleted = (Boolean)state.m_61143_((Property)TreacherousCandleBlock.COMPLETED);
        boolean isLit = (Boolean)state.m_61143_((Property)TreacherousCandleBlock.LIT);
        if (isCompleted) {
            --blockEntity.completionCooldown;
            TreacherousCandleBlockEntity.clearBossBarPlayers(blockEntity);
            if (blockEntity.completionCooldown <= 0) {
                TreacherousCandleBlockEntity.resetValues(blockEntity);
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TreacherousCandleBlock.COMPLETED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TreacherousCandleBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            return;
        }
        if (isLit) {
            TreacherousCandleBlockEntity.updateHealth(blockEntity);
            List<ServerPlayer> playersInRadius = TreacherousCandleBlockEntity.getPlayersInRadius(level, pos);
            TreacherousCandleBlockEntity.updateBossBarPlayers(blockEntity, playersInRadius, level);
            --blockEntity.currentWaveDelay;
            if (blockEntity.currentWave <= blockEntity.maximumWaves) {
                TreacherousCandleBlockEntity.prepareWaves(level, pos, blockEntity);
            } else if (blockEntity.currentWaveDelay <= 0) {
                TreacherousCandleBlockEntity.dropFire(level, pos.m_7494_(), blockEntity);
                level.m_5594_(null, pos, (SoundEvent)JNESoundEvents.TREACHEROUS_CANDLE_VICTORY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)TreacherousCandleBlock.COMPLETED), 2);
            }
            return;
        }
        TreacherousCandleBlockEntity.clearBossBarPlayers(blockEntity);
    }

    private static void clearBossBarPlayers(TreacherousCandleBlockEntity blockEntity) {
        ArrayList playersToRemove = new ArrayList(blockEntity.bossEvent.m_8324_());
        for (ServerPlayer player : playersToRemove) {
            blockEntity.bossEvent.m_6539_(player);
        }
    }

    private static void updateHealth(TreacherousCandleBlockEntity blockEntity) {
        blockEntity.bossEvent.m_142711_((float)blockEntity.health / (float)blockEntity.maximumHealth);
    }

    private static List<ServerPlayer> getPlayersInRadius(Level level, BlockPos pos) {
        return level.m_45976_(ServerPlayer.class, new AABB(pos).m_82377_(16.0, 16.0, 16.0));
    }

    private static void updateBossBarPlayers(TreacherousCandleBlockEntity blockEntity, List<ServerPlayer> playersInRadius, Level level) {
        for (ServerPlayer player : playersInRadius) {
            if (!player.m_6084_() || player.m_9236_() != level) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)JNEMobEffects.BETRAYED.get(), 200, 0));
            if (blockEntity.bossEvent.m_8324_().contains(player)) continue;
            blockEntity.bossEvent.m_6543_(player);
        }
        ArrayList playersToRemove = new ArrayList(blockEntity.bossEvent.m_8324_());
        for (ServerPlayer player : playersToRemove) {
            if (playersInRadius.contains(player) && player.m_6084_() && player.m_9236_() == level) continue;
            blockEntity.bossEvent.m_6539_(player);
        }
    }

    private static void prepareWaves(Level level, BlockPos pos, TreacherousCandleBlockEntity blockEntity) {
        if (blockEntity.currentWaveDelay == 40) {
            level.m_5594_(null, pos, SoundEvents.f_11880_, SoundSource.BLOCKS, 0.5f, 0.6f);
        }
        if (blockEntity.currentWaveDelay == 1) {
            level.m_7106_((ParticleOptions)JNEParticleTypes.CANDLE_BURST.get(), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (blockEntity.currentWaveDelay <= 0) {
            ++blockEntity.currentWave;
            blockEntity.spawnWave(level, pos);
            blockEntity.mobsPerWave += blockEntity.increaseInMobsPerWave;
            blockEntity.currentWaveDelay = blockEntity.maximumWaveDelay;
        }
    }

    private static void dropFire(Level level, BlockPos pos, TreacherousCandleBlockEntity blockEntity) {
        ItemEntity item = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)JNEItems.TREACHEROUS_FLAME.get(), blockEntity.fireRewarded * blockEntity.playersNearby));
        item.m_20334_(0.0, 0.2, 0.0);
        item.m_146915_(true);
        level.m_7967_((Entity)item);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void resetValues(TreacherousCandleBlockEntity blockEntity) {
        blockEntity.completionCooldown = JNEConfigs.TREACHEROUS_CANDLE_COMPLETION_COOLDOWN.get() * 20;
        blockEntity.currentWave = 1;
        blockEntity.health = blockEntity.maximumHealth;
        blockEntity.mobsPerWave = blockEntity.resetMobsPerWave;
        blockEntity.currentWaveDelay = 80;
        blockEntity.playersNearby = 1;
    }

    public static void findAllNearbyPlayers(TreacherousCandleBlockEntity blockEntity, BlockPos pos, Level level) {
        if (level != null) {
            List nearbyPlayers = level.m_45976_(Player.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82377_(16.0, 16.0, 16.0));
            blockEntity.playersNearby = nearbyPlayers.size();
        }
    }

    private void spawnWave(Level level, BlockPos pos) {
        RandomSource random = level.f_46441_;
        if (!this.spawnableMobs.isEmpty()) {
            int bonusSpawns = this.playersNearby > 1 ? this.playersNearby : 0;
            for (int i = 0; i < this.mobsPerWave + bonusSpawns; ++i) {
                PathfinderMob pathfinder;
                BlockPos spawnPos = this.findValidSpawnPosition(level, pos, random);
                EntityType<?> entityType = this.spawnableMobs.get(random.m_188503_(this.spawnableMobs.size()));
                Mob mob = (Mob)entityType.m_20615_(level);
                if (mob == null) continue;
                level.m_6263_(null, (double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.3f, 1.0f);
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                mob.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                mob.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                if (mob instanceof Slime) {
                    Slime slime = (Slime)mob;
                    slime.m_7839_(2, true);
                }
                if (mob instanceof PathfinderMob && !(pathfinder = (PathfinderMob)mob).m_6095_().m_204039_(JNETags.EntityTypes.IGNORES_TREACHEROUS_CANDLE)) {
                    mob.f_21346_.m_25352_(2, (Goal)new AttackTreacherousCandleGoal(pathfinder, 32));
                }
                level.m_7967_((Entity)mob);
            }
        }
    }

    private BlockPos findValidSpawnPosition(Level level, BlockPos pos, RandomSource random) {
        double x = pos.m_123341_() + random.m_188503_(this.spawnRadius);
        double y = pos.m_123342_();
        double z = pos.m_123343_() + random.m_188503_(this.spawnRadius);
        BlockPos currentPos = new BlockPos((int)x, (int)y, (int)z);
        for (int retries = 0; retries < 10; ++retries) {
            if (level.m_8055_(currentPos).m_60795_()) {
                return currentPos;
            }
            currentPos = new BlockPos((int)x, (int)(y += 1.0), (int)z);
        }
        return currentPos;
    }

    public void m_7651_() {
        super.m_7651_();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_() && this.bossEvent != null) {
            ArrayList playersToRemove = new ArrayList(this.bossEvent.m_8324_());
            for (ServerPlayer player : playersToRemove) {
                this.bossEvent.m_6539_(player);
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

