/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SmokestalkBlock
extends GrowingPlantHeadBlock {
    public static final BooleanProperty SMOKEY = BooleanProperty.m_61465_((String)"smokey");
    public static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);

    public SmokestalkBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, false, 0.1);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SMOKEY, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        boolean s = (Boolean)state.m_61143_((Property)SMOKEY);
        if (s) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.012, 0.0);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        boolean s = (Boolean)blockState.m_61143_((Property)SMOKEY);
        boolean bl = false;
        if (!s) {
            if (itemStack.m_204117_(JNETags.Items.SMOKESTALK_FUEL)) {
                level.m_5594_(player, blockPos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                level.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)SMOKEY), 2);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                SmokestalkBlock.spawnParticles(level, blockPos);
                bl = true;
                if (!level.f_46443_) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                }
            }
            if (bl) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static void spawnParticles(Level level, BlockPos blockPos) {
        Direction[] var5;
        RandomSource randomSource = level.f_46441_;
        for (Direction direction : var5 = Direction.values()) {
            BlockPos blockPos2 = blockPos.m_121945_(direction);
            if (level.m_8055_(blockPos2).m_60804_((BlockGetter)level, blockPos2)) continue;
            Direction.Axis axis = direction.m_122434_();
            double e = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)randomSource.m_188501_();
            double f = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)randomSource.m_188501_();
            double g = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)randomSource.m_188501_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockPos.m_123341_() + e, (double)blockPos.m_123342_() + f, (double)blockPos.m_123343_() + g, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SMOKEY, f_53924_});
    }

    protected int m_213627_(RandomSource randomSource) {
        return NetherVines.m_221803_((RandomSource)randomSource);
    }

    @NotNull
    protected Block m_7777_() {
        return (Block)JNEBlocks.SMOKESTALK_PLANT.get();
    }

    protected boolean m_5971_(BlockState blockState) {
        return NetherVines.m_54963_((BlockState)blockState);
    }
}

