/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.mixin.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.platform.Platform;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.entity.client.GhastFireBallModel;
import net.jadenxgamer.netherexp.registry.entity.client.JNEModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.DragonFireballRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.DragonFireball;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DragonFireballRenderer.class})
public abstract class DragonFireballRendererMixin
extends EntityRenderer<DragonFireball> {
    @Unique
    private GhastFireBallModel<DragonFireball> largeFireballModel;

    protected DragonFireballRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void netherexp$init(EntityRendererProvider.Context context, CallbackInfo ci) {
        if (JNEConfigs.REDESIGNED_FIREBALLS.get().booleanValue() && !this.isEMFOrETFLoaded()) {
            this.largeFireballModel = new GhastFireBallModel(context.m_174023_(JNEModelLayers.GHAST_FIREBALL_LAYER));
        }
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/projectile/DragonFireball;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void netherexp$render(DragonFireball dragonFireball, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo cir) {
        if (JNEConfigs.REDESIGNED_FIREBALLS.get().booleanValue() && this.largeFireballModel != null) {
            cir.cancel();
            poseStack.m_85836_();
            poseStack.m_85841_(1.5f, 1.5f, 1.5f);
            poseStack.m_85837_(0.0, -0.8, 0.0);
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.m_5478_((Entity)dragonFireball)));
            this.largeFireballModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/projectile/DragonFireball;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void netherexp$getTextureLocation(DragonFireball dragonFireball, CallbackInfoReturnable<ResourceLocation> cir) {
        if (JNEConfigs.REDESIGNED_FIREBALLS.get().booleanValue()) {
            cir.setReturnValue((Object)new ResourceLocation("netherexp", "textures/entity/dragon_fireball.png"));
        }
    }

    @Unique
    private boolean isEMFOrETFLoaded() {
        return Platform.isModLoaded((String)"entity_model_features") || Platform.isModLoaded((String)"entity_texture_features");
    }
}

