/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.mixin.renderer;

import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.minecraft.client.renderer.entity.BlazeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Blaze;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlazeRenderer.class})
public abstract class BlazeRendererMixin {
    @Unique
    private static final ResourceLocation netherexp$LIT = new ResourceLocation("netherexp", "textures/entity/blaze/lit.png");
    @Unique
    private static final ResourceLocation netherexp$DIM = new ResourceLocation("netherexp", "textures/entity/blaze/dim.png");
    @Unique
    private static final ResourceLocation netherexp$DULL = new ResourceLocation("netherexp", "textures/entity/blaze/dull.png");
    @Unique
    private static final ResourceLocation netherexp$FADING = new ResourceLocation("netherexp", "textures/entity/blaze/fading.png");

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/monster/Blaze;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void netherexp$getDiminishingTexture(Blaze blaze, CallbackInfoReturnable<ResourceLocation> cir) {
        if (JNEConfigs.DIMINISHING_BLAZES.get().booleanValue()) {
            float health = blaze.m_21223_();
            if (health <= 2.0f) {
                cir.setReturnValue((Object)netherexp$FADING);
            } else if (health <= 6.0f) {
                cir.setReturnValue((Object)netherexp$DULL);
            } else if (health <= 15.0f) {
                cir.setReturnValue((Object)netherexp$DIM);
            } else if (health <= 20.0f) {
                cir.setReturnValue((Object)netherexp$LIT);
            }
        }
    }

    @Inject(method={"getBlockLightLevel(Lnet/minecraft/world/entity/monster/Blaze;Lnet/minecraft/core/BlockPos;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void netherexp$getDiminishingBlockLight(Blaze blaze, BlockPos blockPos, CallbackInfoReturnable<Integer> cir) {
        if (JNEConfigs.DIMINISHING_BLAZES.get().booleanValue()) {
            float health = blaze.m_21223_();
            if (health <= 2.0f) {
                cir.setReturnValue((Object)1);
            } else if (health <= 6.0f) {
                cir.setReturnValue((Object)5);
            } else if (health <= 15.0f) {
                cir.setReturnValue((Object)10);
            } else if (health <= 20.0f) {
                cir.setReturnValue((Object)15);
            }
        }
    }
}

