/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.forge.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(m -> m.count))).apply((Applicative)inst, AddItemModifier::new)));
    private final Item item;
    private final int count;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, int count) {
        super(conditionsIn);
        this.item = item;
        this.count = count;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
        if (stack.m_41613_() < stack.m_41741_()) {
            generatedLoot.add((Object)stack);
        } else {
            ItemStack subStack;
            for (int i = stack.m_41613_(); i > 0; i -= subStack.m_41613_()) {
                subStack = stack.m_41777_();
                subStack.m_41764_(Math.min(stack.m_41741_(), i));
                generatedLoot.add((Object)subStack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

