/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.forge;

import dev.architectury.platform.forge.EventBuses;
import net.jadenxgamer.netherexp.NetherExp;
import net.jadenxgamer.netherexp.NetherExpClient;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.config.JNEForgeConfigs;
import net.jadenxgamer.netherexp.forge.NetherExpForgeClient;
import net.jadenxgamer.netherexp.forge.event.JNEBuiltinPacks;
import net.jadenxgamer.netherexp.forge.event.RightClickBlockEvent;
import net.jadenxgamer.netherexp.forge.loot.JNELootModifiers;
import net.jadenxgamer.netherexp.forge.worldgen.SpawnCostsBiomeModifier;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Apparition;
import net.jadenxgamer.netherexp.registry.entity.custom.Banshee;
import net.jadenxgamer.netherexp.registry.entity.custom.Carcass;
import net.jadenxgamer.netherexp.registry.entity.custom.EctoSlab;
import net.jadenxgamer.netherexp.registry.entity.custom.Stampede;
import net.jadenxgamer.netherexp.registry.entity.custom.Vessel;
import net.jadenxgamer.netherexp.registry.entity.custom.Wisp;
import net.jadenxgamer.netherexp.registry.fluid.JNEFluids;
import net.jadenxgamer.netherexp.registry.item.brewing.JNEPotionRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="netherexp")
public class NetherExpForge {
    public NetherExpForge() {
        EventBuses.registerModEventBus((String)"netherexp", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)JNEForgeConfigs.COMMON);
        NetherExp.init();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> NetherExpClient::init);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> NetherExpForgeClient::init);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        JNELootModifiers.LOOT_MODIFIERS.register(eventBus);
        DeferredRegister BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"netherexp");
        BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        BIOME_MODIFIER_SERIALIZERS.register("spawn_costs", SpawnCostsBiomeModifier::createCodec);
        eventBus.addListener(NetherExpForge::commonSetup);
        eventBus.addListener(NetherExpForge::registerAttributes);
        eventBus.addListener(NetherExpForge::registerSpawnPlacements);
        MinecraftForge.EVENT_BUS.addListener(NetherExpForge::onRightClickBlock);
        eventBus.addListener(NetherExpForge::loadComplete);
        eventBus.addListener(NetherExpForge::addBuiltinPacks);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(JNEPotionRecipe::addInvokerPotionRecipes);
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)JNEEntityType.APPARITION.get(), Apparition.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.WISP.get(), Wisp.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.VESSEL.get(), Vessel.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.ECTO_SLAB.get(), EctoSlab.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.BANSHEE.get(), Banshee.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.STAMPEDE.get(), Stampede.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.CARCASS.get(), Carcass.createAttributes().m_22265_());
    }

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)JNEEntityType.VESSEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)JNEEntityType.APPARITION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)JNEEntityType.BANSHEE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(NetherExpForge::registerFluidInteractions);
    }

    private static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FlowingFluid)JNEFluids.ECTOPLASM.get()).getFluidType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)JNEBlocks.BLACK_ICE.get()).m_49966_()));
    }

    private static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        RightClickBlockEvent.WartBeardGrowerEvent(event);
    }

    private static void addBuiltinPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            JNEBuiltinPacks.rpJNERetextures(event);
            JNEBuiltinPacks.rpConflictingRetextures(event);
            JNEBuiltinPacks.rpUniqueNetherWood(event);
        }
        if (event.getPackType() == PackType.SERVER_DATA) {
            if (JNEConfigs.LARGER_NETHER_BIOMES.get().booleanValue()) {
                JNEBuiltinPacks.dpLargerNetherBiomes(event);
            }
            if (NetherExp.compatNethersDelight()) {
                JNEBuiltinPacks.dpNethersDelightCompat(event);
            }
        }
    }
}

