/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableMap;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.components.ConfigSelectionList;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.helper.ServerConfigUploader;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.network.client.C2SAskPermissionsMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.fml.config.ModConfig;

public class SelectConfigScreen
extends Screen {
    private final Screen lastScreen;
    private final Component displayName;
    private final Map<ModConfig, Map<Object, IEntryData>> configs;
    private List<FormattedCharSequence> activeTooltip;
    private EditBox searchBox;
    private ConfigSelectionList list;
    private Button openButton;
    private Button selectButton;
    private Button restoreButton;
    private Button copyButton;
    private Button fileButton;
    private boolean serverPermissions;

    public SelectConfigScreen(Screen lastScreen, Component displayName, Set<ModConfig> configs) {
        super((Component)Component.m_237110_((String)"configmenusforge.gui.select.title", (Object[])new Object[]{displayName}));
        this.lastScreen = lastScreen;
        this.displayName = displayName;
        this.configs = (Map)configs.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Function.identity(), IEntryData::makeValueToDataMap), ImmutableMap::copyOf));
    }

    public void m_274333_() {
        this.initServerPermissions();
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
    }

    protected void m_7856_() {
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 121, 22, 242, 20, this.searchBox, (Component)Component.m_237119_()){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.m_94213_() && button == 1) {
                    this.m_94144_("");
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.searchBox.m_94151_(filter -> this.list.updateFilter((String)filter));
        this.searchBox.m_94199_(50);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20).m_253136_());
        this.openButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.edit"), button1 -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.m_93511_();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                entry.openConfig();
            }
        }).m_252987_(this.f_96543_ / 2 - 50 - 104, this.f_96544_ - 52, 100, 20).m_253136_());
        this.selectButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.world.edit"), button1 -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.m_93511_();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                entry.openConfig();
            }
        }).m_252987_(this.f_96543_ / 2 - 50 - 104, this.f_96544_ - 52, 100, 20).m_253136_());
        this.restoreButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.restore"), button1 -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.m_93511_();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                MutableComponent component2 = Component.m_237115_((String)"configmenusforge.gui.message.restore.warning").m_130940_(ChatFormatting.RED);
                ConfirmScreen confirmScreen = new ConfirmScreen(result1 -> {
                    if (result1) {
                        ModConfig config = entry.getConfig();
                        this.getValueToDataMap(config).values().forEach(data -> {
                            data.resetCurrentValue();
                            data.saveConfigValue();
                        });
                        ServerConfigUploader.saveAndUpload(config);
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, (Component)Component.m_237115_((String)"configmenusforge.gui.message.restore.title"), (Component)component2);
                this.f_96541_.m_91152_((Screen)confirmScreen);
            }
        }).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 52, 100, 20).m_253136_());
        this.copyButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.copy"), button -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.m_93511_();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                ModConfig config = entry.getConfig();
                Path destination = CommonAbstractions.INSTANCE.getDefaultConfigPath().resolve(config.getFileName());
                MutableComponent component2 = Files.exists(destination, new LinkOption[0]) ? Component.m_237115_((String)"configmenusforge.gui.message.copy.warning").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"configmenusforge.gui.message.copy.description");
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        try {
                            if (!Files.exists(destination, new LinkOption[0])) {
                                try {
                                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                Files.createFile(destination, new FileAttribute[0]);
                            }
                            TomlFormat.instance().createWriter().write((UnmodifiableConfig)config.getConfigData(), destination, WritingMode.REPLACE);
                            ForgeConfigScreens.LOGGER.info("Successfully copied {} to default config folder", (Object)config.getFileName());
                        }
                        catch (Exception e) {
                            ForgeConfigScreens.LOGGER.error("Failed to copy {} to default config folder", (Object)config.getFileName(), (Object)e);
                        }
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, (Component)Component.m_237115_((String)"configmenusforge.gui.message.copy.title"), (Component)component2));
            }
        }).m_252987_(this.f_96543_ / 2 - 50 + 104, this.f_96544_ - 52, 100, 20).m_253136_());
        this.fileButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.open"), button -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.m_93511_();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, entry.getConfig().getFullPath().toAbsolutePath().toString()));
                this.m_5561_(style);
            }
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20).m_253136_());
        this.updateButtonStatus(false);
        this.list = new ConfigSelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 50, this.f_96544_ - 60, 36, this.searchBox.m_94155_(), this.list);
        this.m_7787_((GuiEventListener)this.list);
        this.m_264313_((GuiEventListener)this.searchBox);
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k) || this.searchBox.m_7933_(i, j, k);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public boolean m_5534_(char c, int i) {
        return this.searchBox.m_5534_(c, i);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 7, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            guiGraphics.m_280245_(this.f_96547_, this.activeTooltip, mouseX, mouseY);
        }
    }

    public void updateButtonStatus(boolean active) {
        if (this.list != null && active) {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.m_93511_();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                boolean needsWorldInstance = entry.needsWorldInstance();
                this.openButton.f_93624_ = !needsWorldInstance;
                this.selectButton.f_93624_ = needsWorldInstance;
                this.openButton.f_93623_ = true;
                this.restoreButton.f_93623_ = !needsWorldInstance && entry.mayResetValue();
                this.fileButton.f_93623_ = !needsWorldInstance && !entry.onMultiplayerServer();
                this.copyButton.f_93623_ = !needsWorldInstance;
            }
        } else {
            this.openButton.f_93624_ = true;
            this.openButton.f_93623_ = false;
            this.selectButton.f_93624_ = false;
            this.restoreButton.f_93623_ = false;
            this.fileButton.f_93623_ = false;
            this.copyButton.f_93623_ = false;
        }
    }

    public void setActiveTooltip(List<FormattedCharSequence> list) {
        this.activeTooltip = list;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Set<ModConfig> getConfigs() {
        return this.configs.keySet();
    }

    public Map<Object, IEntryData> getValueToDataMap(ModConfig config) {
        return this.configs.get(config);
    }

    private void initServerPermissions() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener connection = minecraft.m_91403_();
        if (connection != null) {
            if (minecraft.m_91090_()) {
                this.serverPermissions = true;
            } else {
                NetworkingHelper.sendToServer(connection.m_104910_(), new C2SAskPermissionsMessage());
            }
        }
    }

    public boolean getServerPermissions() {
        return this.serverPermissions;
    }

    public void setServerPermissions() {
        this.serverPermissions = true;
    }
}

