/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher;

import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.ui.FileUI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import mc.euphoria_patches.euphoria_patcher.ArchiveUtils;
import mc.euphoria_patches.euphoria_patcher.features.ModifyPatchedShaderpacks;
import mc.euphoria_patches.euphoria_patcher.features.RenameOutdatedPatches;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderConfig;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import mc.euphoria_patches.euphoria_patcher.util.Config;
import mc.euphoria_patches.euphoria_patcher.util.JsonUtilReader;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EuphoriaPatcher {
    public static final boolean IS_DEV = false;
    public static final String BRAND_NAME = "Complementary";
    public static final String PATCH_NAME = "EuphoriaPatches";
    public static final String VERSION = "_r5.3";
    public static final String PATCH_VERSION = "_1.4.1";
    private static final String BASE_TAR_HASH = "c85eb822ee37aa3b1764f9490484d47e";
    private static final int BASE_TAR_SIZE = 1300992;
    public static final String DOWNLOAD_URL = "https://www.complementary.dev/";
    public static final String COMMON_LOCATION = "shaders/lib/common.glsl";
    public static final String LANG_LOCATION = "shaders/lang";
    public static final String SHADERS_PROPERTIES_LOCATION = "shaders/shaders.properties";
    public static Path shaderpacks = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
    public static Path configDirectory = FMLPaths.CONFIGDIR.get();
    public static Path resourcesBuildDir = shaderpacks.getParent().getParent().resolve("build");
    public static boolean doPopUpLogging = true;
    public static boolean doUpdateChecking = true;
    public static boolean doRenameOldShaderFiles = true;
    public static Logger LOGGER = LogManager.getLogger((String)"euphoriaPatches");

    public EuphoriaPatcher() {
        this.configStuff();
        if (doUpdateChecking) {
            UpdateChecker.checkForUpdates();
        }
        EuphoriaPatcher.log(0, JsonUtilReader.getRandomMessage("startupMessages"));
        ShaderInfo shaderInfo = this.detectInstalledShaders();
        if (!shaderInfo.isAlreadyInstalled) {
            if (shaderInfo.baseFile == null) {
                EuphoriaPatcher.log(3, 8, "You need to have ComplementaryShaders_r5.3 installed!");
                EuphoriaPatcher.log(3, 8, "Please download it from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft!");
                return;
            }
        } else {
            this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined);
            return;
        }
        Path temp = this.createTempDirectory();
        if (temp == null) {
            return;
        }
        if (!this.processAndPatchShaders(shaderInfo, temp)) {
            return;
        }
        UpdateShaderConfig.updateShaderTxtConfigFile(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        UpdateShaderLoaderConfig.updateShaderLoaderConfig(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        if (doRenameOldShaderFiles) {
            RenameOutdatedPatches.rename();
        }
        this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined);
    }

    private void configStuff() {
        doPopUpLogging = Boolean.parseBoolean(Config.readWriteConfig("doPopUpLogging", "true", "Option for the sodium message popup logging.\nDefault = true"));
        doUpdateChecking = Boolean.parseBoolean(Config.readWriteConfig("doUpdateChecking", "true", "Option that enables or disables the update checker, which verifies if a new version of the mod is available.\nMore info here: https://github.com/EuphoriaPatches/PatcherUpdateChecker\nDefault = true"));
        doRenameOldShaderFiles = Boolean.parseBoolean(Config.readWriteConfig("doRenameOldShaderFiles", "true", "Option that automatically renames outdated Euphoria Patches folders and config files to a new name.\nThis makes it easier for users to identify which ones are outdated.\nDefault = true"));
    }

    public static void log(int messageLevel, int messageFadeTimer, String message) {
        String loggingMessage = "EuphoriaPatcher: " + message;
        if (messageLevel == -1) {
            loggingMessage = "\n\n" + loggingMessage + "\n";
        }
        switch (messageLevel) {
            case -1: 
            case 0: 
            case 1: {
                LOGGER.info(loggingMessage);
                break;
            }
            case 2: {
                LOGGER.warn(loggingMessage);
                break;
            }
            case 3: {
                LOGGER.error(loggingMessage);
                break;
            }
            default: {
                System.out.println(loggingMessage);
            }
        }
    }

    public static void log(int messageLevel, String message) {
        int messageFadeTimer = 0;
        switch (messageLevel) {
            case 1: {
                messageFadeTimer = 4;
                break;
            }
            case 2: {
                messageFadeTimer = 8;
                break;
            }
            case 3: {
                messageFadeTimer = 16;
            }
        }
        EuphoriaPatcher.log(messageLevel, messageFadeTimer, message);
    }

    private ShaderInfo detectInstalledShaders() {
        ShaderInfo info = new ShaderInfo();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, this::isComplementaryShader);){
            for (Path potentialFile : stream) {
                this.processShaderFile(potentialFile, info);
                if (!info.styleReimagined || !info.styleUnbound) continue;
                break;
            }
            if (!info.styleReimagined && !info.styleUnbound) {
                this.detectInstalledDirectories(info);
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error reading shaderpacks directory: " + e.getMessage());
        }
        return info;
    }

    private boolean isComplementaryShader(Path path) {
        String name = path.getFileName().toString();
        return name.matches("Complementary.*_r5.3.*") && name.endsWith(".zip") && !name.contains(PATCH_NAME);
    }

    private void processShaderFile(Path file, ShaderInfo info) {
        String name = file.getFileName().toString();
        if (name.contains("Reimagined")) {
            info.styleReimagined = true;
            if (info.baseFile == null) {
                info.baseFile = file;
            }
        } else if (name.contains("Unbound")) {
            info.styleUnbound = true;
            if (info.baseFile == null) {
                info.baseFile = file;
            }
        }
        this.checkIfAlreadyInstalled(file, info);
    }

    private void checkIfAlreadyInstalled(Path file, ShaderInfo info) {
        if (info.baseFile != null && Files.exists(file.resolveSibling(file.getFileName().toString().replace(".zip", "") + " + " + PATCH_NAME + PATCH_VERSION), new LinkOption[0]) && !info.isAlreadyInstalled) {
            info.isAlreadyInstalled = true;
            EuphoriaPatcher.log(0, "EuphoriaPatches_1.4.1 is already installed.");
        }
    }

    private void thankYouMessage(Path baseFile, boolean styleUnbound, boolean styleReimagined) {
        if (UpdateChecker.NEW_VERSION_AVAILABLE && doUpdateChecking && baseFile != null) {
            try {
                Path shader = baseFile.resolveSibling(baseFile.getFileName().toString().replace(".zip", "") + " + " + PATCH_NAME + PATCH_VERSION);
                ModifyPatchedShaderpacks.modifyShadersProperties(shader, styleUnbound, styleReimagined, "screen=<empty> <empty>", "screen=info19 info20");
                ModifyPatchedShaderpacks.modifyLangFiles(shader, styleUnbound, styleReimagined, "value\\.info19\\.0=.*", "value.info19.0=\u00a7c" + PATCH_VERSION.replace("_", "") + " \u00a7r->\u00a7a " + UpdateChecker.NEW_MOD_VERSION);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Could not modify the shader to show the user that a new version is available" + e.getMessage());
            }
        }
        if (shaderpacks.toString().contains("SpacEagle")) {
            EuphoriaPatcher.log(1, "Have fun developing Euphoria Patches!");
        } else {
            EuphoriaPatcher.log(-1, "Thank you for using Euphoria Patches - SpacEagle17");
        }
    }

    private void detectInstalledDirectories(ShaderInfo info) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, this::isComplementaryShaderDirectory);){
            for (Path potentialFile : stream) {
                this.processShaderDirectory(potentialFile, info);
                if (!info.styleReimagined || !info.styleUnbound) continue;
                break;
            }
        }
    }

    private boolean isComplementaryShaderDirectory(Path path) {
        return path.getFileName().toString().matches("Complementary.*_r5.3.*") && Files.isDirectory(path, new LinkOption[0]);
    }

    private void processShaderDirectory(Path directory, ShaderInfo info) {
        String name = directory.getFileName().toString();
        if (name.contains(PATCH_NAME)) {
            if (name.contains("EuphoriaPatches_1.4.1") && !info.isAlreadyInstalled) {
                info.isAlreadyInstalled = true;
                EuphoriaPatcher.log(0, "EuphoriaPatches_1.4.1 is already installed.");
            }
            return;
        }
        if (name.contains("Reimagined")) {
            info.styleReimagined = true;
            if (info.baseFile == null) {
                info.baseFile = directory;
            }
        } else if (name.contains("Unbound")) {
            info.styleUnbound = true;
            if (info.baseFile == null) {
                info.baseFile = directory;
            }
        }
    }

    private Path createTempDirectory() {
        try {
            return Files.createTempDirectory("euphoria-patcher-", new FileAttribute[0]);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error creating temporary directory: " + e.getMessage());
            return null;
        }
    }

    private boolean processAndPatchShaders(ShaderInfo info, Path temp) {
        String baseName = info.baseFile.getFileName().toString().replace(".zip", "");
        String patchedName = baseName + " + " + PATCH_NAME + PATCH_VERSION;
        Path baseExtracted = this.extractBase(info.baseFile, temp, baseName);
        if (baseExtracted == null) {
            return false;
        }
        if (!this.updateCommonFile(baseExtracted)) {
            return false;
        }
        Path baseArchived = this.archiveBase(baseExtracted, temp, baseName);
        if (!this.verifyBaseArchive(baseArchived)) {
            return false;
        }
        return this.applyPatch(baseArchived, temp, patchedName, info.styleUnbound, info.styleReimagined);
    }

    private Path extractBase(Path baseFile, Path temp, String baseName) {
        Path baseExtracted = temp.resolve(baseName);
        if (!Files.isDirectory(baseFile, new LinkOption[0])) {
            try {
                ArchiveUtils.extract(baseFile, baseExtracted);
            }
            catch (IOException | ArchiveException e) {
                EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
            }
        } else {
            baseExtracted = baseFile;
        }
        return baseExtracted;
    }

    private boolean updateCommonFile(Path baseExtracted) {
        try {
            Path commons = baseExtracted.resolve(COMMON_LOCATION);
            String config = FileUtils.readFileToString((File)commons.toFile(), (String)"UTF-8").replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
            FileUtils.writeStringToFile((File)commons.toFile(), (String)config, (String)"UTF-8");
            return true;
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error extracting style information: " + e.getMessage());
            return false;
        }
    }

    private Path archiveBase(Path baseExtracted, Path temp, String baseName) {
        Path baseArchived = temp.resolve(baseName + ".tar");
        try {
            ArchiveUtils.archive(baseExtracted, baseArchived);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
        }
        return baseArchived;
    }

    private boolean verifyBaseArchive(Path baseArchived) {
        try {
            String hash = DigestUtils.md5Hex((byte[])Arrays.copyOf(Files.readAllBytes(baseArchived), 1300992));
            if (!hash.equals(BASE_TAR_HASH)) {
                EuphoriaPatcher.log(3, 8, "The shader ComplementaryShaders that was found in your shaderpacks folder can't be used as a base for EuphoriaPatches");
                EuphoriaPatcher.log(3, 8, "Please download ComplementaryShaders_r5.3 from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft.");
                if (baseArchived.getFileName().toString().matches("Complementary.*_r5.3.*")) {
                    EuphoriaPatcher.log(3, 8, "Correct Shader Version Found. BUT it might have been modified. The expected hash does not match.");
                } else {
                    EuphoriaPatcher.log(3, 8, "Incorrect Shader Version found or unexpected error. The expected hash does not match.");
                }
                return false;
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Something went wrong during the hash verification" + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean applyPatch(Path baseArchived, Path temp, String patchedName, boolean styleUnbound, boolean styleReimagined) {
        Path patchedArchive = temp.resolve(patchedName + ".tar");
        Path patchedFile = shaderpacks.resolve(patchedName);
        Path patchFile = temp.resolve(patchedName + ".patch");
        return this.applyProductionPatch(baseArchived, patchedArchive, patchFile, patchedFile, styleUnbound, styleReimagined);
    }

    private boolean devPatchFilePrep(Path buildDir, Path baseArchived, Path patchedFile, Path patchedArchive) {
        this.checkBuildPath(buildDir);
        Path patchFile = buildDir.resolve("EuphoriaPatches_1.4.1.patch");
        return this.createDevPatch(baseArchived, patchedFile, patchedArchive, patchFile);
    }

    private void checkBuildPath(Path buildDir) {
        if (!Files.exists(buildDir, new LinkOption[0])) {
            try {
                Files.createDirectories(buildDir, new FileAttribute[0]);
                EuphoriaPatcher.log(2, "Build directory created successfully: " + buildDir);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, "Failed to create directory: " + e.getMessage());
            }
        }
    }

    private boolean createDevPatch(Path baseArchived, Path patchedFile, Path patchedArchive, Path patchFile) {
        try {
            ArchiveUtils.archive(patchedFile, patchedArchive);
            FileUI.diff(baseArchived.toFile(), patchedArchive.toFile(), patchFile.toFile());
            EuphoriaPatcher.log(0, ".patch file successfully created in " + patchFile + "!");
            return true;
        }
        catch (InvalidHeaderException | IOException | CompressorException e) {
            EuphoriaPatcher.log(3, "Error creating dev patch: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean applyProductionPatch(Path baseArchived, Path patchedArchive, Path patchFile, Path patchedFile, boolean styleUnbound, boolean styleReimagined) {
        try (InputStream patchStream = this.getClass().getClassLoader().getResourceAsStream("EuphoriaPatches_1.4.1.patch");){
            if (patchStream == null) return false;
            FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(patchStream), (File)patchFile.toFile());
            FileUI.patch(baseArchived.toFile(), patchedArchive.toFile(), patchFile.toFile());
            try {
                ArchiveUtils.extract(patchedArchive, patchedFile);
            }
            catch (IOException | ArchiveException e) {
                EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
            }
            this.applyStyleSettings(patchedFile, styleUnbound, styleReimagined);
            EuphoriaPatcher.log(1, "EuphoriaPatches was successfully installed. Enjoy! -SpacEagle17");
            boolean bl = true;
            return bl;
        }
        catch (InvalidHeaderException | IOException | CompressorException e) {
            EuphoriaPatcher.log(3, "Error applying patch file: " + e.getMessage());
        }
        return false;
    }

    private void applyStyleSettings(Path patchedFile, boolean styleUnbound, boolean styleReimagined) throws IOException {
        if (styleUnbound) {
            File commons = new File(patchedFile.toFile(), COMMON_LOCATION);
            String unboundConfig = FileUtils.readFileToString((File)commons, (String)"UTF-8").replaceFirst("SHADER_STYLE 1", "SHADER_STYLE 4");
            if (!styleReimagined) {
                FileUtils.writeStringToFile((File)commons, (String)unboundConfig, (String)"UTF-8");
            } else if (patchedFile.getFileName().toString().contains("Reimagined")) {
                File unbound = new File(patchedFile.getParent().toFile(), patchedFile.getFileName().toString().replace("Reimagined", "Unbound"));
                FileUtils.copyDirectory((File)patchedFile.toFile(), (File)unbound);
                FileUtils.writeStringToFile((File)new File(unbound, COMMON_LOCATION), (String)unboundConfig, (String)"UTF-8");
            } else {
                File reimagined = new File(patchedFile.getParent().toFile(), patchedFile.getFileName().toString().replace("Unbound", "Reimagined"));
                FileUtils.copyDirectory((File)patchedFile.toFile(), (File)reimagined);
                FileUtils.writeStringToFile((File)commons, (String)unboundConfig, (String)"UTF-8");
            }
        }
    }

    private static class ShaderInfo {
        Path baseFile = null;
        boolean styleReimagined = false;
        boolean styleUnbound = false;
        boolean isAlreadyInstalled = false;

        private ShaderInfo() {
        }
    }
}

