/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.network;

import com.chaosthedude.endermail.block.PackageBlock;
import com.chaosthedude.endermail.registry.EnderMailItems;
import com.chaosthedude.endermail.util.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class StampPackagePacket {
    private int packageX;
    private int packageY;
    private int packageZ;
    private int deliveryX;
    private int deliveryY;
    private int deliveryZ;
    private String lockerID;
    private boolean hasDeliveryPos;

    public StampPackagePacket() {
    }

    public StampPackagePacket(BlockPos packagePos, BlockPos deliveryPos, String lockerID, boolean hasDeliveryPos) {
        this.packageX = packagePos.m_123341_();
        this.packageY = packagePos.m_123342_();
        this.packageZ = packagePos.m_123343_();
        this.deliveryX = deliveryPos.m_123341_();
        this.deliveryY = deliveryPos.m_123342_();
        this.deliveryZ = deliveryPos.m_123343_();
        this.lockerID = lockerID;
        this.hasDeliveryPos = hasDeliveryPos;
    }

    public StampPackagePacket(FriendlyByteBuf buf) {
        this.packageX = buf.readInt();
        this.packageY = buf.readInt();
        this.packageZ = buf.readInt();
        this.deliveryX = buf.readInt();
        this.deliveryY = buf.readInt();
        this.deliveryZ = buf.readInt();
        this.lockerID = buf.m_130136_(12);
        this.hasDeliveryPos = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.packageX);
        buf.writeInt(this.packageY);
        buf.writeInt(this.packageZ);
        buf.writeInt(this.deliveryX);
        buf.writeInt(this.deliveryY);
        buf.writeInt(this.deliveryZ);
        buf.m_130070_(this.lockerID);
        buf.writeBoolean(this.hasDeliveryPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PackageBlock.stampPackage(((NetworkEvent.Context)ctx.get()).getSender().m_9236_(), new BlockPos(this.packageX, this.packageY, this.packageZ), new BlockPos(this.deliveryX, this.deliveryY, this.deliveryZ), this.lockerID, this.hasDeliveryPos);
            ItemStack stampStack = ItemUtils.getHeldItem((Player)((NetworkEvent.Context)ctx.get()).getSender(), (Item)EnderMailItems.STAMP.get());
            if (stampStack != null && !((NetworkEvent.Context)ctx.get()).getSender().m_7500_()) {
                stampStack.m_41764_(stampStack.m_41613_() - 1);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

