/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.network;

import com.chaosthedude.endermail.block.entity.LockerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ConfigureLockerPacket {
    private int lockerX;
    private int lockerY;
    private int lockerZ;
    private String lockerID;

    public ConfigureLockerPacket() {
    }

    public ConfigureLockerPacket(BlockPos lockerPos, String lockerID) {
        this.lockerX = lockerPos.m_123341_();
        this.lockerY = lockerPos.m_123342_();
        this.lockerZ = lockerPos.m_123343_();
        this.lockerID = lockerID;
    }

    public ConfigureLockerPacket(FriendlyByteBuf buf) {
        this.lockerX = buf.readInt();
        this.lockerY = buf.readInt();
        this.lockerZ = buf.readInt();
        this.lockerID = buf.m_130136_(12);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.lockerX);
        buf.writeInt(this.lockerY);
        buf.writeInt(this.lockerZ);
        buf.m_130070_(this.lockerID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_7702_(new BlockPos(this.lockerX, this.lockerY, this.lockerZ));
            if (blockEntity instanceof LockerBlockEntity) {
                LockerBlockEntity lockerBlockEntity = (LockerBlockEntity)blockEntity;
                lockerBlockEntity.setLockerID(this.lockerID);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

