/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.entity;

import com.chaosthedude.endermail.EnderMail;
import com.chaosthedude.endermail.block.PackageBlock;
import com.chaosthedude.endermail.block.entity.LockerBlockEntity;
import com.chaosthedude.endermail.block.entity.PackageBlockEntity;
import com.chaosthedude.endermail.config.ConfigHandler;
import com.chaosthedude.endermail.data.LockerData;
import com.chaosthedude.endermail.item.PackageControllerItem;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import com.chaosthedude.endermail.registry.EnderMailItems;
import com.chaosthedude.endermail.util.ControllerState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class EnderMailmanEntity
extends Monster {
    public static final String NAME = "ender_mailman";
    private static final EntityDataAccessor<Boolean> CARRYING_PACKAGE = SynchedEntityData.m_135353_(EnderMailmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int lastCreepySound;
    private int timePickedUp;
    private int timeDelivered;
    private boolean isDelivering;
    private BlockPos startingPos;
    private BlockPos deliveryPos;
    private ItemStack packageController;

    public EnderMailmanEntity(EntityType<? extends EnderMailmanEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public EnderMailmanEntity(EntityType<? extends EnderMailmanEntity> entityType, Level level, BlockPos startingPos, BlockPos deliveryPos, String lockerID, ItemStack packageController) {
        super(entityType, level);
        this.packageController = packageController;
        this.m_6034_((double)startingPos.m_123341_() + this.getRandomOffset(), startingPos.m_123342_(), (double)startingPos.m_123343_() + this.getRandomOffset());
        this.setStartingPos(startingPos);
        this.findDeliveryPos(lockerID, deliveryPos);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARRYING_PACKAGE, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(2, (Goal)new DeliverGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TakePackageGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new DieGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
            if (this.f_19797_ - this.timeDelivered > 100) {
                this.diePeacefully();
            }
        }
        this.f_20899_ = false;
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269014_()) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && !(source.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    protected void m_8024_() {
        float f;
        if (this.m_20071_()) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
        if (this.m_9236_().m_46461_() && (f = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource p_32527_) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.contents);
        tag.m_128405_("StartingX", this.startingPos.m_123341_());
        tag.m_128405_("StartingY", this.startingPos.m_123342_());
        tag.m_128405_("StartingZ", this.startingPos.m_123343_());
        tag.m_128405_("DeliveryX", this.deliveryPos.m_123341_());
        tag.m_128405_("DeliveryY", this.deliveryPos.m_123342_());
        tag.m_128405_("DeliveryZ", this.deliveryPos.m_123343_());
        tag.m_128379_("IsDelivering", this.isDelivering);
        tag.m_128379_("IsCarryingPackage", this.isCarryingPackage());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.contents);
        this.startingPos = new BlockPos(tag.m_128451_("StartingX"), tag.m_128451_("StartingY"), tag.m_128451_("StartingZ"));
        this.deliveryPos = new BlockPos(tag.m_128451_("DeliveryX"), tag.m_128451_("DeliveryY"), tag.m_128451_("DeliveryZ"));
        this.isDelivering = tag.m_128471_("IsDelivering");
        this.f_19804_.m_135381_(CARRYING_PACKAGE, (Object)tag.m_128471_("IsCarryingPackage"));
    }

    protected void m_5907_() {
        super.m_5907_();
        for (ItemStack stack : this.contents) {
            this.m_19983_(stack);
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState state = this.m_9236_().m_8055_((BlockPos)pos);
        boolean flag = state.m_280555_();
        boolean flag1 = state.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            boolean flag2 = this.m_20984_(x, y, z, true);
            if (flag2 && !this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected boolean teleportRandomly() {
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        return this.teleport(x, y, z);
    }

    private boolean canPlacePackage(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return !state.m_278721_() && state.m_247087_() && !belowState.m_247087_() && !belowState.m_60713_(Blocks.f_50752_) && belowState.m_60838_((BlockGetter)level, belowPos) && ((PackageBlock)((Object)EnderMailBlocks.PACKAGE.get())).m_49966_().m_60710_((LevelReader)level, pos);
    }

    private BlockPos findLocker(String lockerID) {
        if (this.m_9236_() instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            LockerData data = LockerData.get(serverLevel);
            return data.getLockers().get(lockerID);
        }
        return null;
    }

    private BlockPos findLockerNearPos(BlockPos pos) {
        if (this.m_9236_() instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            LockerData data = LockerData.get(serverLevel);
            for (String lockerID : data.getLockers().keySet()) {
                int deltaZ;
                int deltaX;
                int distanceSq;
                BlockPos lockerPos = data.getLockers().get(lockerID);
                if (!((Boolean)ConfigHandler.GENERAL.lockerDeliveryRadiusIgnoresY.get() != false ? (distanceSq = (deltaX = pos.m_123341_() - lockerPos.m_123341_()) * deltaX + (deltaZ = pos.m_123343_() - lockerPos.m_123343_()) * deltaZ) < (Integer)ConfigHandler.GENERAL.lockerDeliveryRadius.get() * (Integer)ConfigHandler.GENERAL.lockerDeliveryRadius.get() : pos.m_123314_((Vec3i)lockerPos, (double)((Integer)ConfigHandler.GENERAL.lockerDeliveryRadius.get()).intValue()))) continue;
                return lockerPos;
            }
        }
        return null;
    }

    private int findValidDeliveryHeight(BlockPos pos, int maxHeightDifference) {
        if (pos != null) {
            int downY;
            int startY;
            int upY = startY = pos.m_123342_() <= 0 ? this.m_9236_().m_5736_() : pos.m_123342_();
            for (downY = startY; !(this.canPlacePackage(this.m_9236_(), new BlockPos(pos.m_123341_(), upY, pos.m_123343_())) || this.canPlacePackage(this.m_9236_(), new BlockPos(pos.m_123341_(), downY, pos.m_123343_())) || upY >= 255 && downY <= 1 || upY - startY >= maxHeightDifference || startY - downY >= maxHeightDifference); ++upY, --downY) {
            }
            BlockPos upPos = new BlockPos(pos.m_123341_(), upY, pos.m_123343_());
            BlockPos downPos = new BlockPos(pos.m_123341_(), downY, pos.m_123343_());
            if (upY < 255 && this.canPlacePackage(this.m_9236_(), upPos)) {
                return upY;
            }
            if (downY > 1 && this.canPlacePackage(this.m_9236_(), downPos)) {
                return downY;
            }
        }
        return -1;
    }

    private void findDeliveryPos(String lockerID, BlockPos pos) {
        BlockPos lockerPos;
        if (lockerID != null && !lockerID.isEmpty() && (lockerPos = this.findLocker(lockerID)) != null) {
            this.setDeliveryPos(lockerPos);
            return;
        }
        if (pos != null) {
            BlockPos validLocker = this.findLockerNearPos(pos);
            if (validLocker != null) {
                this.setDeliveryPos(validLocker);
                return;
            }
            int deliveryY = this.findValidDeliveryHeight(pos, 255);
            this.setDeliveryPos(new BlockPos(pos.m_123341_(), deliveryY, pos.m_123343_()));
        }
    }

    public void diePeacefully() {
        this.m_6021_(this.m_20185_(), -10.0, this.m_20189_());
        this.m_6469_(this.m_269291_().m_287287_(), Float.MAX_VALUE);
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.contents = contents;
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public double getDistance(double x, double y, double z) {
        return Math.sqrt(this.m_20275_(x, y, z));
    }

    public double getDistanceToDelivery() {
        return this.getDistance(this.deliveryPos.m_123341_(), this.deliveryPos.m_123342_(), this.deliveryPos.m_123343_());
    }

    public double getDistanceToStart() {
        return this.getDistance(this.startingPos.m_123341_(), this.startingPos.m_123342_(), this.startingPos.m_123343_());
    }

    public BlockPos getDeliveryPos() {
        return this.deliveryPos;
    }

    public void setDeliveryPos(BlockPos pos) {
        this.deliveryPos = pos;
        this.setDelivering(true);
    }

    public BlockPos getStartingPos() {
        return this.startingPos;
    }

    public void setPackageController(ItemStack packageController) {
        this.packageController = packageController;
    }

    public ItemStack getPackageController() {
        return this.packageController;
    }

    public PackageControllerItem getPackageControllerItem() {
        return (PackageControllerItem)this.packageController.m_41720_();
    }

    public boolean hasPackageController() {
        return this.packageController != null && !this.packageController.m_41619_();
    }

    public boolean isCarryingPackage() {
        return (Boolean)this.f_19804_.m_135370_(CARRYING_PACKAGE);
    }

    public boolean isDelivering() {
        return this.isDelivering;
    }

    public void setCarryingPackage(boolean carrying) {
        this.f_19804_.m_135381_(CARRYING_PACKAGE, (Object)carrying);
    }

    public void setDelivering(boolean delivering) {
        this.isDelivering = delivering;
    }

    public boolean shouldDeliverOnGround() {
        return this.canPlacePackage(this.m_9236_(), this.getDeliveryPos());
    }

    public boolean shouldDeliverToLocker() {
        return this.m_9236_().m_8055_(this.deliveryPos).m_60734_() == EnderMailBlocks.LOCKER.get();
    }

    public void updateTimePickedUp() {
        this.timePickedUp = this.f_19797_;
    }

    public int getTimePickedUp() {
        return this.timePickedUp;
    }

    public void updateTimeDelivered() {
        this.timeDelivered = this.f_19797_;
    }

    public int getTimeDelivered() {
        return this.timeDelivered;
    }

    public void playEndermanSound() {
        if (this.f_19797_ >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public double getRandomOffset() {
        return this.f_19796_.m_188500_() * 2.0 * (double)(this.f_19796_.m_188499_() ? 1 : -1);
    }

    public void teleportToDeliveryPos() {
        double x = (double)this.getDeliveryPos().m_123341_() + this.getRandomOffset();
        double y = this.getDeliveryPos().m_123342_();
        double z = (double)this.getDeliveryPos().m_123343_() + this.getRandomOffset();
        this.m_6021_(x, y, z);
    }

    public void teleportToStartingPos() {
        double x = (double)this.getStartingPos().m_123341_() + this.getRandomOffset();
        double y = this.getStartingPos().m_123342_();
        double z = (double)this.getStartingPos().m_123343_() + this.getRandomOffset();
        this.m_6021_(x, y, z);
    }

    public boolean isAtStartingPos() {
        return this.m_20183_() == this.startingPos;
    }

    public void setStartingPos(BlockPos pos) {
        this.startingPos = pos;
    }

    public ItemStack getPackageStack() {
        ItemStack stackPackage = new ItemStack((ItemLike)EnderMailItems.PACKAGE.get());
        CompoundTag stackTag = new CompoundTag();
        CompoundTag itemTag = new CompoundTag();
        if (!this.contents.isEmpty()) {
            itemTag = ContainerHelper.m_18973_((CompoundTag)itemTag, this.contents);
        }
        if (!itemTag.m_128456_()) {
            stackTag.m_128365_("BlockEntityTag", (Tag)itemTag);
        }
        if (!stackTag.m_128456_()) {
            stackPackage.m_41751_(stackTag);
        }
        return stackPackage;
    }

    static class DeliverGoal
    extends Goal {
        private final EnderMailmanEntity enderMailman;

        public DeliverGoal(EnderMailmanEntity enderMailman) {
            this.enderMailman = enderMailman;
        }

        public boolean m_8036_() {
            return this.enderMailman.isDelivering() && this.enderMailman.isCarryingPackage();
        }

        public void m_8037_() {
            if (this.enderMailman.f_19797_ - this.enderMailman.getTimePickedUp() >= 100) {
                BlockEntity blockEntity;
                BlockState newBlockState;
                boolean delivered = false;
                if (this.enderMailman.shouldDeliverOnGround()) {
                    this.enderMailman.teleportToDeliveryPos();
                    newBlockState = ((PackageBlock)((Object)EnderMailBlocks.PACKAGE.get())).getRandomlyRotatedStampedState();
                    this.enderMailman.m_9236_().m_7731_(this.enderMailman.getDeliveryPos(), newBlockState, 3);
                    this.enderMailman.m_9236_().m_151523_((BlockEntity)new PackageBlockEntity(this.enderMailman.getContents(), this.enderMailman.getDeliveryPos(), newBlockState));
                    if (this.enderMailman.hasPackageController()) {
                        this.enderMailman.getPackageControllerItem().setState(this.enderMailman.packageController, ControllerState.DELIVERED);
                        this.enderMailman.getPackageControllerItem().setDeliveryPos(this.enderMailman.packageController, this.enderMailman.getDeliveryPos());
                    }
                    if (((Boolean)ConfigHandler.GENERAL.logDeliveries.get()).booleanValue()) {
                        EnderMail.LOGGER.info("Delivered package to " + this.enderMailman.getDeliveryPos().m_123341_() + ", " + this.enderMailman.getDeliveryPos().m_123342_() + ", " + this.enderMailman.getDeliveryPos().m_123343_());
                    }
                    delivered = true;
                } else if (this.enderMailman.shouldDeliverToLocker() && (blockEntity = this.enderMailman.m_9236_().m_7702_(this.enderMailman.getDeliveryPos())) != null && blockEntity instanceof LockerBlockEntity) {
                    this.enderMailman.teleportToDeliveryPos();
                    LockerBlockEntity lockerBlockEntity = (LockerBlockEntity)blockEntity;
                    ItemStack stackPackage = this.enderMailman.getPackageStack();
                    boolean putInLocker = lockerBlockEntity.addPackage(stackPackage);
                    if (putInLocker) {
                        if (this.enderMailman.hasPackageController()) {
                            this.enderMailman.getPackageControllerItem().setState(this.enderMailman.packageController, ControllerState.DELIVERED_TO_LOCKER);
                            this.enderMailman.getPackageControllerItem().setLockerID(this.enderMailman.packageController, lockerBlockEntity.getLockerID());
                            this.enderMailman.getPackageControllerItem().setDeliveryPos(this.enderMailman.packageController, this.enderMailman.getDeliveryPos());
                            this.enderMailman.getPackageControllerItem().setShowLockerLocation(this.enderMailman.packageController, (Boolean)ConfigHandler.GENERAL.hideLockerLocation.get() == false);
                        }
                        if (((Boolean)ConfigHandler.GENERAL.logDeliveries.get()).booleanValue()) {
                            EnderMail.LOGGER.info("Delivered package to locker " + lockerBlockEntity.getLockerID() + " at " + this.enderMailman.getDeliveryPos().m_123341_() + ", " + this.enderMailman.getDeliveryPos().m_123342_() + ", " + this.enderMailman.getDeliveryPos().m_123343_());
                        }
                        delivered = true;
                    } else {
                        int y = -1;
                        ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH));
                        while (y < 0 && !directions.isEmpty()) {
                            Direction randomDirection = (Direction)directions.get(new Random().nextInt(directions.size()));
                            directions.remove(randomDirection);
                            BlockPos newDeliveryPos = this.enderMailman.getDeliveryPos().m_121945_(randomDirection);
                            y = this.enderMailman.findValidDeliveryHeight(newDeliveryPos, 8);
                            if (y <= 0) continue;
                            newDeliveryPos = new BlockPos(newDeliveryPos.m_123341_(), y, newDeliveryPos.m_123343_());
                            BlockState newBlockState2 = ((PackageBlock)((Object)EnderMailBlocks.PACKAGE.get())).getRandomlyRotatedStampedState();
                            this.enderMailman.m_9236_().m_7731_(newDeliveryPos, newBlockState2, 3);
                            this.enderMailman.m_9236_().m_151523_((BlockEntity)new PackageBlockEntity(this.enderMailman.getContents(), newDeliveryPos, newBlockState2));
                            if (this.enderMailman.hasPackageController()) {
                                this.enderMailman.getPackageControllerItem().setState(this.enderMailman.packageController, ControllerState.DELIVERED);
                                this.enderMailman.getPackageControllerItem().setDeliveryPos(this.enderMailman.packageController, newDeliveryPos);
                            }
                            if (((Boolean)ConfigHandler.GENERAL.logDeliveries.get()).booleanValue()) {
                                EnderMail.LOGGER.info("Delivered package to " + newDeliveryPos.m_123341_() + ", " + newDeliveryPos.m_123342_() + ", " + newDeliveryPos.m_123343_() + " near locker " + lockerBlockEntity.getLockerID());
                            }
                            delivered = true;
                        }
                    }
                }
                if (!delivered) {
                    this.enderMailman.teleportToStartingPos();
                    newBlockState = ((PackageBlock)((Object)EnderMailBlocks.PACKAGE.get())).getRandomlyRotatedStampedState();
                    this.enderMailman.m_9236_().m_7731_(this.enderMailman.getStartingPos(), newBlockState, 3);
                    this.enderMailman.m_9236_().m_151523_((BlockEntity)new PackageBlockEntity(this.enderMailman.getContents(), this.enderMailman.getStartingPos(), newBlockState));
                    if (this.enderMailman.hasPackageController()) {
                        this.enderMailman.getPackageControllerItem().setState(this.enderMailman.packageController, ControllerState.UNDELIVERABLE);
                    }
                }
                this.enderMailman.updateTimeDelivered();
                this.enderMailman.setContents((NonNullList<ItemStack>)NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_));
                this.enderMailman.setCarryingPackage(false);
                this.enderMailman.setDelivering(false);
            } else if ((this.enderMailman.f_19797_ - this.enderMailman.getTimePickedUp()) % 20 == 0) {
                this.enderMailman.teleportRandomly();
            }
        }
    }

    static class TakePackageGoal
    extends Goal {
        private final EnderMailmanEntity enderMailman;

        public TakePackageGoal(EnderMailmanEntity enderMailman) {
            this.enderMailman = enderMailman;
        }

        public boolean m_8036_() {
            return this.enderMailman.isDelivering() && !this.enderMailman.isCarryingPackage();
        }

        public void m_8037_() {
            BlockEntity blockEntity = this.enderMailman.m_9236_().m_7702_(this.enderMailman.startingPos);
            if (blockEntity != null && blockEntity instanceof PackageBlockEntity) {
                PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
                this.enderMailman.setContents(packageBlockEntity.getContents());
                this.enderMailman.setCarryingPackage(true);
                this.enderMailman.m_9236_().m_7731_(this.enderMailman.startingPos, Blocks.f_50016_.m_49966_(), 3);
                if (this.enderMailman.hasPackageController()) {
                    this.enderMailman.getPackageControllerItem().setState(this.enderMailman.packageController, ControllerState.DELIVERING);
                }
                this.enderMailman.updateTimePickedUp();
            } else {
                this.enderMailman.setDelivering(false);
            }
        }
    }

    static class DieGoal
    extends Goal {
        private final EnderMailmanEntity enderMailman;

        public DieGoal(EnderMailmanEntity enderMailman) {
            this.enderMailman = enderMailman;
        }

        public boolean m_8036_() {
            return !this.enderMailman.isDelivering();
        }

        public void m_8037_() {
            if (this.enderMailman.f_19797_ - this.enderMailman.getTimeDelivered() >= 100) {
                this.enderMailman.diePeacefully();
            }
        }
    }
}

