/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LockerData
extends SavedData {
    public static final String ID = "lockers";
    private final Map<String, BlockPos> lockers = new HashMap<String, BlockPos>();

    public LockerData() {
    }

    public LockerData(CompoundTag tag) {
        ListTag lockerList = tag.m_128437_("Lockers", 10);
        for (Tag t : lockerList) {
            CompoundTag lockerTag = (CompoundTag)t;
            String lockerID = lockerTag.m_128461_("ID");
            BlockPos pos = new BlockPos(lockerTag.m_128451_("X"), lockerTag.m_128451_("Y"), lockerTag.m_128451_("Z"));
            this.lockers.put(lockerID, pos);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag lockerList = new ListTag();
        for (String lockerID : this.lockers.keySet()) {
            CompoundTag lockerTag = new CompoundTag();
            lockerTag.m_128359_("ID", lockerID);
            lockerTag.m_128405_("X", this.lockers.get(lockerID).m_123341_());
            lockerTag.m_128405_("Y", this.lockers.get(lockerID).m_123342_());
            lockerTag.m_128405_("Z", this.lockers.get(lockerID).m_123343_());
            lockerList.add((Object)lockerTag);
        }
        tag.m_128365_("Lockers", (Tag)lockerList);
        return tag;
    }

    public String createLocker(String lockerID, BlockPos pos) {
        int suffixIndex = 2;
        Object fixedLockerID = lockerID;
        while (this.lockerExists((String)fixedLockerID) && ((String)fixedLockerID).length() <= 12) {
            fixedLockerID = lockerID + suffixIndex;
            ++suffixIndex;
        }
        if (((String)fixedLockerID).length() > 12) {
            return "";
        }
        this.lockers.put((String)fixedLockerID, pos);
        this.m_77762_();
        return fixedLockerID;
    }

    public boolean lockerExists(String lockerID) {
        return this.lockers.containsKey(lockerID);
    }

    public void removeLocker(String lockerID) {
        this.lockers.remove(lockerID);
        this.m_77762_();
    }

    public Map<String, BlockPos> getLockers() {
        return this.lockers;
    }

    public static LockerData get(ServerLevel level) {
        DimensionDataStorage data = level.m_8895_();
        return (LockerData)data.m_164861_(LockerData::new, LockerData::new, ID);
    }
}

