/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.block.entity;

import com.chaosthedude.endermail.gui.container.PackageMenu;
import com.chaosthedude.endermail.registry.EnderMailBlockEntities;
import com.chaosthedude.endermail.registry.EnderMailItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PackageBlockEntity
extends BaseContainerBlockEntity {
    public static final String NAME = "package";
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int deliveryX = -1;
    private int deliveryY = -1;
    private int deliveryZ = -1;
    private String lockerID = "";
    private boolean hasDeliveryLocation = false;
    private boolean hasLockerID;

    public PackageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderMailBlockEntities.PACKAGE.get(), pos, state);
    }

    public PackageBlockEntity(NonNullList<ItemStack> contents, BlockPos pos, BlockState state) {
        this(pos, state);
        this.contents = contents;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.contents) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.contents);
        this.deliveryX = tag.m_128451_("DeliveryX");
        this.deliveryY = tag.m_128451_("DeliveryY");
        this.deliveryZ = tag.m_128451_("DeliveryZ");
        this.lockerID = tag.m_128461_("LockerID");
        this.hasDeliveryLocation = tag.m_128471_("HasDeliveryLocation");
        this.hasLockerID = tag.m_128471_("HasLockerID");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.contents);
        tag.m_128405_("DeliveryX", this.deliveryX);
        tag.m_128405_("DeliveryY", this.deliveryY);
        tag.m_128405_("DeliveryZ", this.deliveryZ);
        tag.m_128359_("LockerID", this.lockerID);
        tag.m_128379_("HasDeliveryLocation", this.hasDeliveryLocation);
        tag.m_128379_("HasLockerID", this.hasLockerID);
    }

    public CompoundTag writeItems(CompoundTag tag) {
        if (!this.contents.isEmpty()) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.contents);
        }
        return tag;
    }

    public int m_6893_() {
        return 64;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.contents, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.contents, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.contents.get(index);
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack);
        this.contents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_41720_() != EnderMailItems.PACKAGE.get();
    }

    public void m_6211_() {
        this.contents.clear();
    }

    public AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new PackageMenu(windowId, playerInventory, (Container)this);
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public void setDeliveryPos(BlockPos pos, boolean hasDeliveryLocation) {
        this.hasDeliveryLocation = hasDeliveryLocation;
        this.deliveryX = pos.m_123341_();
        this.deliveryY = pos.m_123342_();
        this.deliveryZ = pos.m_123343_();
    }

    public void setLockerID(String lockerID) {
        this.hasLockerID = true;
        this.lockerID = lockerID;
    }

    public String getLockerID() {
        if (this.hasLockerID) {
            return this.lockerID;
        }
        return null;
    }

    public BlockPos getDeliveryPos() {
        return new BlockPos(this.deliveryX, this.deliveryY, this.deliveryZ);
    }

    public boolean hasDeliveryLocation() {
        return this.hasDeliveryLocation;
    }

    public int m_6643_() {
        return 5;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.endermail.package");
    }
}

