/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.block;

import com.chaosthedude.endermail.block.entity.PackageBlockEntity;
import com.chaosthedude.endermail.config.ConfigHandler;
import com.chaosthedude.endermail.data.LockerData;
import com.chaosthedude.endermail.entity.EnderMailmanEntity;
import com.chaosthedude.endermail.gui.ScreenWrapper;
import com.chaosthedude.endermail.item.PackageControllerItem;
import com.chaosthedude.endermail.registry.EnderMailEntities;
import com.chaosthedude.endermail.registry.EnderMailItems;
import com.chaosthedude.endermail.util.ControllerState;
import com.chaosthedude.endermail.util.ItemUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class PackageBlock
extends BaseEntityBlock {
    public static final String NAME = "package";
    public static final int INVENTORY_SIZE = 5;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty STAMPED = BooleanProperty.m_61465_((String)"stamped");

    public PackageBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(1.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)STAMPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STAMPED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_5833_()) {
            return InteractionResult.SUCCESS;
        }
        boolean holdingStamp = ItemUtils.isHolding(player, (Item)EnderMailItems.STAMP.get());
        boolean holdingPackageController = ItemUtils.isHolding(player, (Item)EnderMailItems.PACKAGE_CONTROLLER.get());
        if (level.m_5776_() && !this.isStamped(state) && player.m_21120_(hand).m_41720_() == EnderMailItems.STAMP.get()) {
            ScreenWrapper.openStampScreen(level, player, pos);
            return InteractionResult.SUCCESS;
        }
        if (level.m_5776_() && (!this.isStamped(state) && !player.m_6047_() || this.isStamped(state) && (player.m_6047_() || player.m_21120_(hand) == ItemStack.f_41583_ && !holdingStamp && !holdingPackageController))) {
            return InteractionResult.SUCCESS;
        }
        if (!level.m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isStamped(state) && player.m_21120_(hand).m_41720_() == EnderMailItems.PACKAGE_CONTROLLER.get()) {
                ItemStack stack = ItemUtils.getHeldItem(player, (Item)EnderMailItems.PACKAGE_CONTROLLER.get());
                PackageControllerItem packageController = (PackageControllerItem)stack.m_41720_();
                BlockPos deliveryPos = PackageBlock.getDeliveryPos(level, pos);
                String lockerID = PackageBlock.getLockerID(level, pos);
                if (deliveryPos != null) {
                    packageController.setDeliveryPos(stack, deliveryPos);
                    int distanceToDelivery = (int)Math.sqrt(pos.m_123331_((Vec3i)deliveryPos));
                    if (lockerID != null && !LockerData.get(serverLevel).lockerExists(lockerID) && !PackageBlock.hasDeliveryLocation(level, pos)) {
                        packageController.setState(stack, ControllerState.INVALID_LOCKER);
                        packageController.setLockerID(stack, lockerID);
                    } else if ((Integer)ConfigHandler.GENERAL.maxDeliveryDistance.get() > -1 && distanceToDelivery > (Integer)ConfigHandler.GENERAL.maxDeliveryDistance.get()) {
                        packageController.setState(stack, ControllerState.TOOFAR);
                        packageController.setDeliveryDistance(stack, distanceToDelivery);
                        packageController.setMaxDistance(stack, (Integer)ConfigHandler.GENERAL.maxDeliveryDistance.get());
                    } else {
                        packageController.setState(stack, ControllerState.DELIVERING);
                        EnderMailmanEntity enderMailman = new EnderMailmanEntity((EntityType<? extends EnderMailmanEntity>)((EntityType)EnderMailEntities.ENDER_MAILMAN.get()), level, pos, deliveryPos, lockerID, stack);
                        level.m_7967_((Entity)enderMailman);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isStamped(state) && (player.m_6047_() || player.m_21120_(hand) == ItemStack.f_41583_ && !holdingStamp && !holdingPackageController)) {
                PackageBlock.setState(false, level, pos);
                return InteractionResult.SUCCESS;
            }
            if (!(this.isStamped(state) || player.m_6047_() || holdingStamp)) {
                BlockEntity te = level.m_7702_(pos);
                if (te != null && te instanceof PackageBlockEntity) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((PackageBlockEntity)te), (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof PackageBlockEntity) {
            ((PackageBlockEntity)blockEntity).m_58638_(stack.m_41611_());
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            if (!(level.m_5776_() || player.m_7500_() && packageBlockEntity.m_7983_() || !level.m_46469_().m_46207_(GameRules.f_46136_))) {
                ItemStack stackPackage = new ItemStack((ItemLike)EnderMailItems.PACKAGE.get());
                CompoundTag stackTag = new CompoundTag();
                CompoundTag itemTag = packageBlockEntity.writeItems(new CompoundTag());
                if (!itemTag.m_128456_()) {
                    stackTag.m_128365_("BlockEntityTag", (Tag)itemTag);
                }
                if (!stackTag.m_128456_()) {
                    stackPackage.m_41751_(stackTag);
                }
                if (packageBlockEntity.m_8077_()) {
                    stackPackage.m_41714_(packageBlockEntity.m_5446_());
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stackPackage);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            CompoundTag stackTag = new CompoundTag();
            CompoundTag itemTag = packageBlockEntity.writeItems(new CompoundTag());
            if (!itemTag.m_128456_()) {
                stackTag.m_128365_("BlockEntityTag", (Tag)itemTag);
            }
            if (!stackTag.m_128456_()) {
                stack.m_41751_(stackTag);
            }
            if (packageBlockEntity.m_8077_()) {
                stack.m_41714_(packageBlockEntity.m_5446_());
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (Screen.m_96638_()) {
            CompoundTag tag;
            CompoundTag temp = stack.m_41783_();
            if (temp != null && temp.m_128425_("BlockEntityTag", 10) && (tag = temp.m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
                NonNullList content = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)content);
                for (ItemStack contentStack : content) {
                    if (contentStack.m_41619_()) continue;
                    MutableComponent textComponent = contentStack.m_41611_().m_6881_();
                    textComponent.m_130946_(" x").m_130946_(String.valueOf(contentStack.m_41613_())).m_130940_(ChatFormatting.GRAY);
                    tooltip.add((Component)textComponent);
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"string.endermail.holdShift").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState p_56255_) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PackageBlockEntity(pos, state);
    }

    public BlockState getStampedState() {
        return (BlockState)this.m_49966_().m_61124_((Property)STAMPED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState getRandomlyRotatedStampedState() {
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAMPED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)directions[new Random().nextInt(4)]);
    }

    public boolean isStamped(BlockState state) {
        return (Boolean)state.m_61143_((Property)STAMPED);
    }

    public static void stampPackage(Level level, BlockPos packagePos, BlockPos deliveryPos, String lockerID, boolean hasDeliveryPos) {
        PackageBlock.setState(true, level, packagePos);
        BlockEntity te = level.m_7702_(packagePos);
        if (te != null && te instanceof PackageBlockEntity) {
            PackageBlockEntity tePackage = (PackageBlockEntity)te;
            tePackage.setDeliveryPos(deliveryPos, hasDeliveryPos);
            tePackage.setLockerID(lockerID);
        }
    }

    public static BlockPos getDeliveryPos(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            return packageBlockEntity.getDeliveryPos();
        }
        return null;
    }

    public static String getLockerID(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            return packageBlockEntity.getLockerID();
        }
        return null;
    }

    public static boolean hasDeliveryLocation(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            return packageBlockEntity.hasDeliveryLocation();
        }
        return false;
    }

    public static void setState(boolean stamped, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAMPED, (Comparable)Boolean.valueOf(stamped)), 3);
    }
}

