/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.block;

import com.chaosthedude.endermail.block.entity.LockerBlockEntity;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class LockerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    public static final String NAME = "locker";
    public static final int INVENTORY_SIZE = 3;
    public static final int MAX_ID_LENGTH = 12;

    public LockerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60913_(4.0f, 6.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILLED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null && blockEntity instanceof LockerBlockEntity) {
                LockerBlockEntity lockerBlockEntity = (LockerBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)lockerBlockEntity, buf -> buf.m_130064_(pos).m_130070_(lockerBlockEntity.getLockerID()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof LockerBlockEntity) {
            ((LockerBlockEntity)blockEntity).setLockerID(stack.m_41611_().getString());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof LockerBlockEntity) {
                LockerBlockEntity lockerBlockEntity = (LockerBlockEntity)blockEntity;
                lockerBlockEntity.removeData();
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)lockerBlockEntity);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockerBlockEntity(pos, state);
    }

    public static void setFilled(boolean filled, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == EnderMailBlocks.LOCKER.get() && (Boolean)state.m_61143_((Property)FILLED) != filled) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(filled)), 3);
        }
    }
}

