/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail;

import com.chaosthedude.endermail.client.ClientEventHandler;
import com.chaosthedude.endermail.config.ConfigHandler;
import com.chaosthedude.endermail.gui.LockerScreen;
import com.chaosthedude.endermail.gui.PackageScreen;
import com.chaosthedude.endermail.item.PackageControllerItem;
import com.chaosthedude.endermail.network.ConfigureLockerPacket;
import com.chaosthedude.endermail.network.StampPackagePacket;
import com.chaosthedude.endermail.registry.EnderMailBlockEntities;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import com.chaosthedude.endermail.registry.EnderMailContainers;
import com.chaosthedude.endermail.registry.EnderMailEntities;
import com.chaosthedude.endermail.registry.EnderMailItems;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="endermail")
public class EnderMail {
    public static final String MODID = "endermail";
    public static final Logger LOGGER = LogManager.getLogger((String)"endermail");
    public static SimpleChannel network;

    public EnderMail() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EnderMailBlocks.BLOCK_DEFERRED.register(bus);
        EnderMailBlockEntities.BLOCK_ENTITY_DEFERRED.register(bus);
        EnderMailContainers.CONTAINER_DEFERRED.register(bus);
        EnderMailEntities.ENTITY_DEFERRED.register(bus);
        EnderMailItems.ITEM_DEFERRED.register(bus);
        bus.addListener(this::preInit);
        bus.addListener(this::buildCreativeTabContents);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.GENERAL_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void preInit(FMLCommonSetupEvent event) {
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        network.registerMessage(0, StampPackagePacket.class, StampPackagePacket::toBytes, StampPackagePacket::new, StampPackagePacket::handle);
        network.registerMessage(1, ConfigureLockerPacket.class, ConfigureLockerPacket::toBytes, ConfigureLockerPacket::new, ConfigureLockerPacket::handle);
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246342_(new ItemStack((ItemLike)EnderMailItems.PACKAGE_CONTROLLER.get()));
            event.m_246342_(new ItemStack((ItemLike)EnderMailItems.STAMP.get()));
        } else if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.m_246342_(new ItemStack((ItemLike)EnderMailItems.PACKING_TAPE.get()));
        } else if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.m_246342_(new ItemStack((ItemLike)EnderMailItems.PACKAGE.get()));
            event.m_246342_(new ItemStack((ItemLike)EnderMailItems.LOCKER.get()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientInit(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MenuScreens.m_96206_((MenuType)((MenuType)EnderMailContainers.PACKAGE_CONTAINER.get()), PackageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)EnderMailContainers.LOCKER_CONTAINER.get()), LockerScreen::new);
        ItemProperties.register((Item)((Item)EnderMailItems.PACKAGE_CONTROLLER.get()), (ResourceLocation)new ResourceLocation(MODID, "state"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

            public float m_142187_(ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
                if (stack.m_41720_() == EnderMailItems.PACKAGE_CONTROLLER.get()) {
                    PackageControllerItem packageController = (PackageControllerItem)stack.m_41720_();
                    return 0.1f * (float)packageController.getState(stack).getID();
                }
                return 0.0f;
            }
        });
    }
}

