/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.geo.Ray2d;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3f;

public class IntersectionHelper {
    public static List<Vec2d> cutMinMax(double minOne, double minTwo, double maxOne, double maxTwo, Vec2d[] corners) {
        boolean clockwise;
        if (corners.length < 3) {
            return Collections.EMPTY_LIST;
        }
        boolean insideOneMin = false;
        boolean insideTwoMin = false;
        boolean insideOneMax = false;
        boolean insideTwoMax = false;
        boolean allInside = true;
        int insideIndex = -1;
        InsideStatus[] status = new InsideStatus[corners.length];
        for (int i = 0; i < corners.length; ++i) {
            double valueOne = corners[i].x;
            double valueTwo = corners[i].y;
            status[i] = InsideStatus.get(valueOne, valueTwo, minOne, minTwo, maxOne, maxTwo);
            if (status[i].isInside()) {
                if (insideIndex == -1) {
                    insideIndex = i;
                }
                insideTwoMax = true;
                insideTwoMin = true;
                insideOneMax = true;
                insideOneMin = true;
                continue;
            }
            allInside = false;
            if (status[i].isOutsideOne()) {
                if (status[i].outsideDirectionOne().booleanValue()) {
                    insideOneMax = true;
                } else {
                    insideOneMin = true;
                }
            } else {
                insideOneMax = true;
                insideOneMin = true;
            }
            if (status[i].isOutsideTwo()) {
                if (status[i].outsideDirectionTwo().booleanValue()) {
                    insideTwoMax = true;
                    continue;
                }
                insideTwoMin = true;
                continue;
            }
            insideTwoMax = true;
            insideTwoMin = true;
        }
        double originOne = corners[1].x;
        double originTwo = corners[1].y;
        boolean bl = clockwise = (corners[0].x - originOne) * (corners[2].y - originTwo) - (corners[0].y - originTwo) * (corners[2].x - originOne) > 0.0;
        if (allInside) {
            if (clockwise) {
                return Arrays.asList(new Vec2d(minOne, minTwo), new Vec2d(minOne, maxTwo), new Vec2d(maxOne, maxTwo), new Vec2d(maxOne, minTwo));
            }
            return Arrays.asList(new Vec2d(maxOne, minTwo), new Vec2d(maxOne, maxTwo), new Vec2d(minOne, maxTwo), new Vec2d(minOne, minTwo));
        }
        if (insideOneMin && insideOneMax && insideTwoMin && insideTwoMax) {
            Ray2d ray = new Ray2d(Axis.X, Axis.Y, 0.0, 0.0, 0.0, 0.0);
            ArrayList<Vec2d> result = new ArrayList<Vec2d>();
            boolean hasFoundInside = insideIndex != -1;
            if (!hasFoundInside) {
                insideIndex = 0;
            }
            IntersectionHelper.iterateLines(insideIndex, status.length, hasFoundInside, null, ray, minOne, minTwo, maxOne, maxTwo, clockwise, status, corners, result);
            if (result.isEmpty()) {
                boolean aboveOneAboveTwo = false;
                boolean aboveOneBelowTwo = false;
                boolean belowOneAboveTwo = false;
                boolean belowOneBelowTwo = false;
                for (int j = 0; j < corners.length; ++j) {
                    if (corners[j].x > minOne) {
                        if (corners[j].y > minTwo) {
                            aboveOneAboveTwo = true;
                            continue;
                        }
                        aboveOneBelowTwo = true;
                        continue;
                    }
                    if (corners[j].y > minTwo) {
                        belowOneAboveTwo = true;
                        continue;
                    }
                    belowOneBelowTwo = true;
                }
                if (aboveOneAboveTwo && aboveOneBelowTwo && belowOneAboveTwo && belowOneBelowTwo) {
                    if (clockwise) {
                        return Arrays.asList(new Vec2d(minOne, minTwo), new Vec2d(minOne, maxTwo), new Vec2d(maxOne, maxTwo), new Vec2d(maxOne, minTwo));
                    }
                    return Arrays.asList(new Vec2d(maxOne, minTwo), new Vec2d(maxOne, maxTwo), new Vec2d(minOne, maxTwo), new Vec2d(minOne, minTwo));
                }
            }
            if (result.size() > 2) {
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Vec2f> cutMinMax(Axis one, Axis two, float minOne, float minTwo, float maxOne, float maxTwo, Vec3f[] corners) {
        boolean clockwise;
        if (corners.length < 3) {
            return Collections.EMPTY_LIST;
        }
        boolean insideOneMin = false;
        boolean insideTwoMin = false;
        boolean insideOneMax = false;
        boolean insideTwoMax = false;
        boolean allInside = true;
        int insideIndex = -1;
        InsideStatus[] status = new InsideStatus[corners.length];
        for (int i = 0; i < corners.length; ++i) {
            float valueOne = corners[i].get(one);
            float valueTwo = corners[i].get(two);
            status[i] = InsideStatus.get(valueOne, valueTwo, minOne, minTwo, maxOne, maxTwo);
            if (status[i].isInside()) {
                if (insideIndex == -1) {
                    insideIndex = i;
                }
                insideTwoMax = true;
                insideTwoMin = true;
                insideOneMax = true;
                insideOneMin = true;
                continue;
            }
            allInside = false;
            if (status[i].isOutsideOne()) {
                if (status[i].outsideDirectionOne().booleanValue()) {
                    insideOneMax = true;
                } else {
                    insideOneMin = true;
                }
            } else {
                insideOneMax = true;
                insideOneMin = true;
            }
            if (status[i].isOutsideTwo()) {
                if (status[i].outsideDirectionTwo().booleanValue()) {
                    insideTwoMax = true;
                    continue;
                }
                insideTwoMin = true;
                continue;
            }
            insideTwoMax = true;
            insideTwoMin = true;
        }
        float originOne = corners[1].get(one);
        float originTwo = corners[1].get(two);
        boolean bl = clockwise = (corners[0].get(one) - originOne) * (corners[2].get(two) - originTwo) - (corners[0].get(two) - originTwo) * (corners[2].get(one) - originOne) > 0.0f;
        if (allInside) {
            if (clockwise) {
                return Arrays.asList(new Vec2f(minOne, minTwo), new Vec2f(minOne, maxTwo), new Vec2f(maxOne, maxTwo), new Vec2f(maxOne, minTwo));
            }
            return Arrays.asList(new Vec2f(maxOne, minTwo), new Vec2f(maxOne, maxTwo), new Vec2f(minOne, maxTwo), new Vec2f(minOne, minTwo));
        }
        if (insideOneMin && insideOneMax && insideTwoMin && insideTwoMax) {
            Ray2d ray = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
            ArrayList<Vec2f> result = new ArrayList<Vec2f>();
            boolean hasFoundInside = insideIndex != -1;
            if (!hasFoundInside) {
                insideIndex = 0;
            }
            IntersectionHelper.iterateLines(insideIndex, status.length, hasFoundInside, null, ray, one, two, minOne, minTwo, maxOne, maxTwo, clockwise, status, corners, result);
            if (result.isEmpty()) {
                boolean aboveOneAboveTwo = false;
                boolean aboveOneBelowTwo = false;
                boolean belowOneAboveTwo = false;
                boolean belowOneBelowTwo = false;
                for (int j = 0; j < corners.length; ++j) {
                    if (corners[j].get(one) > minOne) {
                        if (corners[j].get(two) > minTwo) {
                            aboveOneAboveTwo = true;
                            continue;
                        }
                        aboveOneBelowTwo = true;
                        continue;
                    }
                    if (corners[j].get(two) > minTwo) {
                        belowOneAboveTwo = true;
                        continue;
                    }
                    belowOneBelowTwo = true;
                }
                if (aboveOneAboveTwo && aboveOneBelowTwo && belowOneAboveTwo && belowOneBelowTwo) {
                    if (clockwise) {
                        return Arrays.asList(new Vec2f(minOne, minTwo), new Vec2f(minOne, maxTwo), new Vec2f(maxOne, maxTwo), new Vec2f(maxOne, minTwo));
                    }
                    return Arrays.asList(new Vec2f(maxOne, minTwo), new Vec2f(maxOne, maxTwo), new Vec2f(minOne, maxTwo), new Vec2f(minOne, minTwo));
                }
            }
            if (result.size() > 2) {
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static Edge iterateLines(int offset, int count, boolean hasFoundInside, Edge edge, Ray2d ray, double minOne, double minTwo, double maxOne, double maxTwo, boolean clockwise, InsideStatus[] status, Vec2d[] corners, List<Vec2d> result) {
        double beforeOne = corners[offset].x;
        double beforeTwo = corners[offset].y;
        InsideStatus before = status[offset];
        boolean inside = before.isInside();
        if (inside) {
            IntersectionHelper.add(new Vec2d(beforeOne, beforeTwo), result);
        }
        for (int i = 1; i <= count; ++i) {
            int currentIndex = (offset + i) % corners.length;
            Vec2d vec = corners[currentIndex];
            double nowOne = vec.x;
            double nowTwo = vec.y;
            InsideStatus current = status[currentIndex];
            if (inside) {
                if (current.isInside()) {
                    IntersectionHelper.add(new Vec2d(nowOne, nowTwo), result);
                } else {
                    edge = IntersectionHelper.findIntersection(ray, clockwise, minOne, minTwo, maxOne, maxTwo, current, beforeOne, beforeTwo, nowOne, nowTwo, null, result);
                    inside = false;
                }
            } else if (current.isInside()) {
                IntersectionHelper.findIntersection(ray, clockwise, minOne, minTwo, maxOne, maxTwo, before, beforeOne, beforeTwo, nowOne, nowTwo, edge, result);
                IntersectionHelper.add(new Vec2d(nowOne, nowTwo), result);
                edge = null;
                inside = true;
            } else {
                float tempT;
                ray.originOne = beforeOne;
                ray.originTwo = beforeTwo;
                ray.directionOne = nowOne - beforeOne;
                ray.directionTwo = nowTwo - beforeTwo;
                Edge inEdge = null;
                float inT = 1.0f;
                Edge outEdge = null;
                float outT = 0.0f;
                if (before.outsideDirectionOne() != current.outsideDirectionOne()) {
                    float valueTwo;
                    if (BooleanUtils.isFalse((Boolean)before.outsideDirectionOne()) || BooleanUtils.isFalse((Boolean)current.outsideDirectionOne())) {
                        tempT = (float)ray.getT(Axis.X, minOne);
                        valueTwo = (float)(ray.originTwo + ray.directionTwo * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && (double)valueTwo >= minTwo && (double)valueTwo <= maxTwo) {
                            if (tempT < inT) {
                                inEdge = Edge.MIN_ONE;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MIN_ONE;
                                outT = tempT;
                            }
                        }
                    }
                    if (BooleanUtils.isTrue((Boolean)before.outsideDirectionOne()) || BooleanUtils.isTrue((Boolean)current.outsideDirectionOne())) {
                        tempT = (float)ray.getT(Axis.X, maxOne);
                        valueTwo = (float)(ray.originTwo + ray.directionTwo * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && (double)valueTwo >= minTwo && (double)valueTwo <= maxTwo) {
                            if (tempT < inT) {
                                inEdge = Edge.MAX_ONE;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MAX_ONE;
                                outT = tempT;
                            }
                        }
                    }
                }
                if (before.outsideDirectionTwo() != current.outsideDirectionTwo()) {
                    float valueOne;
                    if (BooleanUtils.isFalse((Boolean)before.outsideDirectionTwo()) || BooleanUtils.isFalse((Boolean)current.outsideDirectionTwo())) {
                        tempT = (float)ray.getT(Axis.Y, minTwo);
                        valueOne = (float)(ray.originOne + ray.directionOne * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && (double)valueOne >= minOne && (double)valueOne <= maxOne) {
                            if (tempT < inT) {
                                inEdge = Edge.MIN_TWO;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MIN_TWO;
                                outT = tempT;
                            }
                        }
                    }
                    if (BooleanUtils.isTrue((Boolean)before.outsideDirectionTwo()) || BooleanUtils.isTrue((Boolean)current.outsideDirectionTwo())) {
                        tempT = (float)ray.getT(Axis.Y, maxTwo);
                        valueOne = (float)(ray.originOne + ray.directionOne * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && (double)valueOne >= minOne && (double)valueOne <= maxOne) {
                            if (tempT < inT) {
                                inEdge = Edge.MAX_TWO;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MAX_TWO;
                                outT = tempT;
                            }
                        }
                    }
                }
                if (inEdge != null && inEdge != outEdge) {
                    if (hasFoundInside) {
                        IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, edge, inEdge, clockwise, result);
                        IntersectionHelper.add(ray.get(inT), result);
                        IntersectionHelper.add(ray.get(outT), result);
                        edge = outEdge;
                    } else {
                        Vec2d outVec = ray.get(outT);
                        Vec2d inVec = ray.get(inT);
                        IntersectionHelper.add(outVec, result);
                        edge = IntersectionHelper.iterateLines(currentIndex, status.length - 1, true, outEdge, ray, minOne, minTwo, maxOne, maxTwo, clockwise, status, corners, result);
                        if (edge == null) {
                            result.clear();
                            return null;
                        }
                        IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, edge, inEdge, clockwise, result);
                        IntersectionHelper.add(inVec, result);
                        return null;
                    }
                }
            }
            before = current;
            beforeOne = nowOne;
            beforeTwo = nowTwo;
        }
        return edge;
    }

    private static Edge findIntersection(Ray2d ray, boolean clockwise, double minOne, double minTwo, double maxOne, double maxTwo, InsideStatus status, double beforeOne, double beforeTwo, double nowOne, double nowTwo, Edge before, List<Vec2d> result) {
        double edgeValue;
        double intersection;
        ray.originOne = beforeOne;
        ray.originTwo = beforeTwo;
        ray.directionOne = nowOne - beforeOne;
        ray.directionTwo = nowTwo - beforeTwo;
        if (status.isOutsideOne() && (intersection = (double)((float)ray.get(ray.one, edgeValue = status.outsideDirectionOne() != false ? maxOne : minOne))) >= minTwo && intersection <= maxTwo) {
            if (before != null) {
                IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, before, status.oneEdge(), clockwise, result);
            }
            IntersectionHelper.add(new Vec2d(edgeValue, intersection), result);
            return status.oneEdge();
        }
        if (status.isOutsideTwo() && (intersection = (double)((float)ray.get(ray.two, edgeValue = status.outsideDirectionTwo() != false ? maxTwo : minTwo))) >= minOne && intersection <= maxOne) {
            if (before != null) {
                IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, before, status.twoEdge(), clockwise, result);
            }
            IntersectionHelper.add(new Vec2d(intersection, edgeValue), result);
            return status.twoEdge();
        }
        throw new RuntimeException("Impossible");
    }

    private static void add(Vec2d vec, List<Vec2d> result) {
        if (result.isEmpty() || !result.get(result.size() - 1).epsilonEquals(vec, (double)1.0E-4f)) {
            result.add(vec);
        }
    }

    private static void addCornersBetween(double minOne, double minTwo, double maxOne, double maxTwo, Edge start, Edge end, boolean clockwise, List<Vec2d> result) {
        Edge current = start;
        while (current != end) {
            Edge next;
            Edge edge = next = clockwise ? current.clockwise() : current.counterClockwise();
            if (current.one()) {
                IntersectionHelper.add(new Vec2d(current.positive() ? maxOne : minOne, next.positive() ? maxTwo : minTwo), result);
            } else {
                IntersectionHelper.add(new Vec2d(next.positive() ? maxOne : minOne, current.positive() ? maxTwo : minTwo), result);
            }
            current = next;
        }
    }

    private static Edge iterateLines(int offset, int count, boolean hasFoundInside, Edge edge, Ray2d ray, Axis one, Axis two, float minOne, float minTwo, float maxOne, float maxTwo, boolean clockwise, InsideStatus[] status, Vec3f[] corners, List<Vec2f> result) {
        float beforeOne = corners[offset].get(one);
        float beforeTwo = corners[offset].get(two);
        InsideStatus before = status[offset];
        boolean inside = before.isInside();
        if (inside) {
            IntersectionHelper.add(new Vec2f(beforeOne, beforeTwo), result);
        }
        for (int i = 1; i <= count; ++i) {
            int currentIndex = (offset + i) % corners.length;
            Vec3f vec = corners[currentIndex];
            float nowOne = vec.get(one);
            float nowTwo = vec.get(two);
            InsideStatus current = status[currentIndex];
            if (inside) {
                if (current.isInside()) {
                    IntersectionHelper.add(new Vec2f(nowOne, nowTwo), result);
                } else {
                    edge = IntersectionHelper.findIntersection(ray, clockwise, minOne, minTwo, maxOne, maxTwo, current, beforeOne, beforeTwo, nowOne, nowTwo, null, result);
                    inside = false;
                }
            } else if (current.isInside()) {
                IntersectionHelper.findIntersection(ray, clockwise, minOne, minTwo, maxOne, maxTwo, before, beforeOne, beforeTwo, nowOne, nowTwo, edge, result);
                IntersectionHelper.add(new Vec2f(nowOne, nowTwo), result);
                edge = null;
                inside = true;
            } else {
                float tempT;
                ray.originOne = beforeOne;
                ray.originTwo = beforeTwo;
                ray.directionOne = nowOne - beforeOne;
                ray.directionTwo = nowTwo - beforeTwo;
                Edge inEdge = null;
                float inT = 1.0f;
                Edge outEdge = null;
                float outT = 0.0f;
                if (before.outsideDirectionOne() != current.outsideDirectionOne()) {
                    float valueTwo;
                    if (BooleanUtils.isFalse((Boolean)before.outsideDirectionOne()) || BooleanUtils.isFalse((Boolean)current.outsideDirectionOne())) {
                        tempT = (float)ray.getT(one, minOne);
                        valueTwo = (float)(ray.originTwo + ray.directionTwo * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueTwo >= minTwo && valueTwo <= maxTwo) {
                            if (tempT < inT) {
                                inEdge = Edge.MIN_ONE;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MIN_ONE;
                                outT = tempT;
                            }
                        }
                    }
                    if (BooleanUtils.isTrue((Boolean)before.outsideDirectionOne()) || BooleanUtils.isTrue((Boolean)current.outsideDirectionOne())) {
                        tempT = (float)ray.getT(one, maxOne);
                        valueTwo = (float)(ray.originTwo + ray.directionTwo * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueTwo >= minTwo && valueTwo <= maxTwo) {
                            if (tempT < inT) {
                                inEdge = Edge.MAX_ONE;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MAX_ONE;
                                outT = tempT;
                            }
                        }
                    }
                }
                if (before.outsideDirectionTwo() != current.outsideDirectionTwo()) {
                    float valueOne;
                    if (BooleanUtils.isFalse((Boolean)before.outsideDirectionTwo()) || BooleanUtils.isFalse((Boolean)current.outsideDirectionTwo())) {
                        tempT = (float)ray.getT(two, minTwo);
                        valueOne = (float)(ray.originOne + ray.directionOne * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueOne >= minOne && valueOne <= maxOne) {
                            if (tempT < inT) {
                                inEdge = Edge.MIN_TWO;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MIN_TWO;
                                outT = tempT;
                            }
                        }
                    }
                    if (BooleanUtils.isTrue((Boolean)before.outsideDirectionTwo()) || BooleanUtils.isTrue((Boolean)current.outsideDirectionTwo())) {
                        tempT = (float)ray.getT(two, maxTwo);
                        valueOne = (float)(ray.originOne + ray.directionOne * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueOne >= minOne && valueOne <= maxOne) {
                            if (tempT < inT) {
                                inEdge = Edge.MAX_TWO;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MAX_TWO;
                                outT = tempT;
                            }
                        }
                    }
                }
                if (inEdge != null && inEdge != outEdge) {
                    if (hasFoundInside) {
                        if (edge == null) {
                            result.clear();
                            return null;
                        }
                        IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, edge, inEdge, clockwise, result);
                        IntersectionHelper.add(ray.getFloat(inT), result);
                        IntersectionHelper.add(ray.getFloat(outT), result);
                        edge = outEdge;
                    } else {
                        Vec2f outVec = ray.getFloat(outT);
                        Vec2f inVec = ray.getFloat(inT);
                        IntersectionHelper.add(outVec, result);
                        edge = IntersectionHelper.iterateLines(currentIndex, status.length - 1, true, outEdge, ray, one, two, minOne, minTwo, maxOne, maxTwo, clockwise, status, corners, result);
                        if (edge == null) {
                            result.clear();
                            return null;
                        }
                        IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, edge, inEdge, clockwise, result);
                        IntersectionHelper.add(inVec, result);
                        return null;
                    }
                }
            }
            before = current;
            beforeOne = nowOne;
            beforeTwo = nowTwo;
        }
        return edge;
    }

    private static Edge findIntersection(Ray2d ray, boolean clockwise, float minOne, float minTwo, float maxOne, float maxTwo, InsideStatus status, float beforeOne, float beforeTwo, float nowOne, float nowTwo, Edge before, List<Vec2f> result) {
        float edgeValue;
        float intersection;
        ray.originOne = beforeOne;
        ray.originTwo = beforeTwo;
        ray.directionOne = nowOne - beforeOne;
        ray.directionTwo = nowTwo - beforeTwo;
        if (status.isOutsideOne() && (intersection = (float)ray.get(ray.one, edgeValue = status.outsideDirectionOne() != false ? maxOne : minOne)) >= minTwo && intersection <= maxTwo) {
            if (before != null) {
                IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, before, status.oneEdge(), clockwise, result);
            }
            IntersectionHelper.add(new Vec2f(edgeValue, intersection), result);
            return status.oneEdge();
        }
        if (status.isOutsideTwo() && (intersection = (float)ray.get(ray.two, edgeValue = status.outsideDirectionTwo() != false ? maxTwo : minTwo)) >= minOne && intersection <= maxOne) {
            if (before != null) {
                IntersectionHelper.addCornersBetween(minOne, minTwo, maxOne, maxTwo, before, status.twoEdge(), clockwise, result);
            }
            IntersectionHelper.add(new Vec2f(intersection, edgeValue), result);
            return status.twoEdge();
        }
        throw new RuntimeException("Impossible");
    }

    private static void add(Vec2f vec, List<Vec2f> result) {
        if (result.isEmpty() || !result.get(result.size() - 1).epsilonEquals(vec, 1.0E-4f) && (result.size() == 1 || !result.get(0).epsilonEquals(vec, 1.0E-4f))) {
            result.add(vec);
        }
    }

    private static void addCornersBetween(float minOne, float minTwo, float maxOne, float maxTwo, Edge start, Edge end, boolean clockwise, List<Vec2f> result) {
        Edge current = start;
        while (current != end) {
            Edge next;
            Edge edge = next = clockwise ? current.clockwise() : current.counterClockwise();
            if (current.one()) {
                IntersectionHelper.add(new Vec2f(current.positive() ? maxOne : minOne, next.positive() ? maxTwo : minTwo), result);
            } else {
                IntersectionHelper.add(new Vec2f(next.positive() ? maxOne : minOne, current.positive() ? maxTwo : minTwo), result);
            }
            current = next;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum InsideStatus {
        INSIDE{

            @Override
            public boolean isInside() {
                return true;
            }

            @Override
            public boolean isOutsideOne() {
                return false;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return null;
            }

            @Override
            public boolean isOutsideTwo() {
                return false;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return null;
            }
        }
        ,
        OUTSIDE_MIN_ONE{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return false;
            }

            @Override
            public boolean isOutsideTwo() {
                return false;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return null;
            }
        }
        ,
        OUTSIDE_MAX_ONE{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return true;
            }

            @Override
            public boolean isOutsideTwo() {
                return false;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return null;
            }
        }
        ,
        OUTSIDE_MIN_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return false;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return null;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return false;
            }
        }
        ,
        OUTSIDE_MAX_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return false;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return null;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return true;
            }
        }
        ,
        OUTSIDE_MIN_ONE_MIN_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return false;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return false;
            }
        }
        ,
        OUTSIDE_MIN_ONE_MAX_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return false;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return true;
            }
        }
        ,
        OUTSIDE_MAX_ONE_MIN_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return true;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return false;
            }
        }
        ,
        OUTSIDE_MAX_ONE_MAX_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return true;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return true;
            }
        };


        public abstract boolean isInside();

        public abstract boolean isOutsideOne();

        public abstract Boolean outsideDirectionOne();

        public Edge oneEdge() {
            return this.outsideDirectionOne() != false ? Edge.MAX_ONE : Edge.MIN_ONE;
        }

        public abstract boolean isOutsideTwo();

        public abstract Boolean outsideDirectionTwo();

        public Edge twoEdge() {
            return this.outsideDirectionTwo() != false ? Edge.MAX_TWO : Edge.MIN_TWO;
        }

        public static InsideStatus get(float one, float two, float minOne, float minTwo, float maxOne, float maxTwo) {
            if (one > minOne) {
                if (one < maxOne) {
                    if (two > minTwo) {
                        if (two < maxTwo) {
                            return INSIDE;
                        }
                        return OUTSIDE_MAX_TWO;
                    }
                    return OUTSIDE_MIN_TWO;
                }
                if (two > minTwo) {
                    if (two < maxTwo) {
                        return OUTSIDE_MAX_ONE;
                    }
                    return OUTSIDE_MAX_ONE_MAX_TWO;
                }
                return OUTSIDE_MAX_ONE_MIN_TWO;
            }
            if (two > minTwo) {
                if (two < maxTwo) {
                    return OUTSIDE_MIN_ONE;
                }
                return OUTSIDE_MIN_ONE_MAX_TWO;
            }
            return OUTSIDE_MIN_ONE_MIN_TWO;
        }

        public static InsideStatus get(double one, double two, double minOne, double minTwo, double maxOne, double maxTwo) {
            if (one > minOne) {
                if (one < maxOne) {
                    if (two > minTwo) {
                        if (two < maxTwo) {
                            return INSIDE;
                        }
                        return OUTSIDE_MAX_TWO;
                    }
                    return OUTSIDE_MIN_TWO;
                }
                if (two >= minTwo) {
                    if (two <= maxTwo) {
                        return OUTSIDE_MAX_ONE;
                    }
                    return OUTSIDE_MAX_ONE_MAX_TWO;
                }
                return OUTSIDE_MAX_ONE_MIN_TWO;
            }
            if (two > minTwo) {
                if (two < maxTwo) {
                    return OUTSIDE_MIN_ONE;
                }
                return OUTSIDE_MIN_ONE_MAX_TWO;
            }
            return OUTSIDE_MIN_ONE_MIN_TWO;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Edge {
        MIN_ONE{

            @Override
            public Edge clockwise() {
                return MAX_TWO;
            }

            @Override
            public Edge counterClockwise() {
                return MIN_TWO;
            }

            @Override
            public boolean one() {
                return true;
            }

            @Override
            public boolean positive() {
                return false;
            }
        }
        ,
        MIN_TWO{

            @Override
            public Edge clockwise() {
                return MIN_ONE;
            }

            @Override
            public Edge counterClockwise() {
                return MAX_ONE;
            }

            @Override
            public boolean one() {
                return false;
            }

            @Override
            public boolean positive() {
                return false;
            }
        }
        ,
        MAX_ONE{

            @Override
            public Edge clockwise() {
                return MIN_TWO;
            }

            @Override
            public Edge counterClockwise() {
                return MAX_TWO;
            }

            @Override
            public boolean one() {
                return true;
            }

            @Override
            public boolean positive() {
                return true;
            }
        }
        ,
        MAX_TWO{

            @Override
            public Edge clockwise() {
                return MAX_ONE;
            }

            @Override
            public Edge counterClockwise() {
                return MIN_ONE;
            }

            @Override
            public boolean one() {
                return false;
            }

            @Override
            public boolean positive() {
                return true;
            }
        };


        public abstract boolean one();

        public abstract boolean positive();

        public abstract Edge clockwise();

        public abstract Edge counterClockwise();
    }
}

