/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.tools.counting;

import java.math.BigInteger;
import java.util.Comparator;
import reloc.org.sat4j.core.Vec;
import reloc.org.sat4j.specs.ISolver;
import reloc.org.sat4j.specs.IVec;
import reloc.org.sat4j.tools.counting.AllVariablesSamplingSet;
import reloc.org.sat4j.tools.counting.IModelCounter;
import reloc.org.sat4j.tools.counting.ModelCounterAdapter;
import reloc.org.sat4j.tools.counting.ParityConstraintGenerator;
import reloc.org.sat4j.tools.counting.SamplingSet;

public abstract class AbstractApproxMC
implements IModelCounter {
    public static final double DEFAULT_EPSILON = 0.1;
    public static final double DEFAULT_DELTA = 0.1;
    protected final double epsilon;
    protected final double delta;
    protected final SamplingSet samplingSet;
    protected final ParityConstraintGenerator generator;
    private final ModelCounterAdapter counter;

    protected AbstractApproxMC(ISolver solver) {
        this(solver, AllVariablesSamplingSet.of(solver));
    }

    protected AbstractApproxMC(ISolver solver, SamplingSet samplingSet) {
        this(solver, samplingSet, 0.1, 0.1);
    }

    protected AbstractApproxMC(ISolver solver, double epsilon, double delta) {
        this(solver, AllVariablesSamplingSet.of(solver), epsilon, delta);
    }

    protected AbstractApproxMC(ISolver solver, SamplingSet samplingSet, double epsilon, double delta) {
        this.counter = ModelCounterAdapter.newInstance(solver);
        this.epsilon = epsilon;
        this.delta = delta;
        this.samplingSet = samplingSet;
        this.generator = new ParityConstraintGenerator(solver, samplingSet);
    }

    @Override
    public final BigInteger countModels() {
        int threshold = this.computeThreshold();
        long initialCount = this.boundedSAT(threshold);
        if (initialCount < (long)threshold) {
            return BigInteger.valueOf(initialCount);
        }
        int iterCount = this.computeIterCount();
        Vec<BigInteger> counts = new Vec<BigInteger>(iterCount);
        for (int i = 0; i < iterCount; ++i) {
            BigInteger count = this.internalCountModels(threshold);
            if (count == null) continue;
            counts.push(count);
        }
        return AbstractApproxMC.findMedian(counts);
    }

    protected abstract int computeThreshold();

    protected abstract int computeIterCount();

    protected abstract BigInteger internalCountModels(int var1);

    protected final long boundedSAT(int bound) {
        this.counter.setBound(bound);
        BigInteger foundModels = this.counter.countModels();
        this.counter.reset();
        return foundModels.longValue();
    }

    @Override
    public void reset() {
    }

    private static BigInteger findMedian(IVec<BigInteger> values) {
        if (values.isEmpty()) {
            return BigInteger.ZERO;
        }
        values.sort(new Comparator<BigInteger>(){

            @Override
            public int compare(BigInteger o1, BigInteger o2) {
                return o1.compareTo(o2);
            }
        });
        return values.get(values.size() >> 1);
    }
}

