/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.core.utils;

public class MathUtils {
    public static float Clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double Clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float Clamp01(float value) {
        return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
    }

    public static double Clamp01(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    public static float Lerp(float a, float b, float time) {
        return a + (b - a) * MathUtils.Clamp01(time);
    }

    public static double Lerp(double a, double b, double time) {
        return a + (b - a) * MathUtils.Clamp01(time);
    }

    public static float Damp(float source, float destination, float smoothing, float dt) {
        return MathUtils.Lerp(source, destination, 1.0f - (float)Math.pow(smoothing, dt));
    }

    public static double Damp(double source, double destination, double smoothing, double dt) {
        return MathUtils.Lerp(source, destination, 1.0 - Math.pow(smoothing, dt));
    }
}

