/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.core.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.core.configuration.BaseConfigData;
import net.fabricmc.loader.api.FabricLoader;

public final class Configuration {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Path configPath = FabricLoader.getInstance().getConfigDir();

    public static <T extends BaseConfigData> T LoadConfig(Class<T> tClass, String configName, int configVersion) {
        BaseConfigData configData = null;
        Path configFile = configPath.resolve(configName + ".json");
        boolean saveConfig = false;
        try {
            Files.createDirectories(configPath, new FileAttribute[0]);
            if (Files.exists(configFile, new LinkOption[0])) {
                BufferedReader fileReader = Files.newBufferedReader(configFile);
                configData = (BaseConfigData)gson.fromJson((Reader)fileReader, tClass);
                fileReader.close();
                if (configData.configVersion < configVersion) {
                    saveConfig = true;
                }
            } else {
                configData = (BaseConfigData)tClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                saveConfig = true;
            }
        }
        catch (Exception e) {
            CameraOverhaul.Logger.error("Error when initializing config", (Throwable)e);
        }
        if (saveConfig) {
            Configuration.SaveConfig(configData, configName, configVersion);
        }
        return (T)configData;
    }

    public static <T extends BaseConfigData> void SaveConfig(T configData, String configName, int configVersion) {
        Path configFile = configPath.resolve(configName + ".json");
        configData.configVersion = configVersion;
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            writer.write(gson.toJson(configData));
        }
        catch (IOException e) {
            CameraOverhaul.Logger.error("Couldn't save config file", (Throwable)e);
        }
    }
}

