/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class SerializerString
implements ISerializer<String> {
    public static final ISerializer<String> SERIALIZER = new SerializerString();

    private SerializerString() {
    }

    @Override
    public String fromJSON(JsonElement json) {
        return json.getAsString();
    }

    @Override
    public JsonElement toJSON(String toWrite) {
        return new JsonPrimitive(toWrite);
    }

    @Override
    public String fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.m_130277_();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, String toWrite) {
        buffer.m_130070_(toWrite);
    }

    @Override
    public Tag toNBT(String toWrite) {
        return StringTag.m_129297_((String)toWrite);
    }

    @Override
    public String fromNBT(Tag nbt) {
        if (nbt instanceof StringTag) {
            StringTag stringTag = (StringTag)nbt;
            return stringTag.m_7916_();
        }
        throw new NBTParseException("Expected NBT to be a string tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

