/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmaster435.biomeparticleweather.util.custom_particle.spawn;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.condition.BiomeCondition;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.condition.BlockAboveCondition;

public record SpawnConditions(boolean is_solid, BlockAboveCondition above_condition, BiomeCondition biome_condition, boolean is_raining, boolean is_thundering) {
    public boolean test(class_1937 world, class_2338 pos) {
        boolean biome = this.biome_condition.test((class_5321<class_1959>)((class_5321)world.method_23753(pos).method_40230().orElseThrow()));
        boolean solid = !this.is_solid || !world.method_8320(pos).method_26212((class_1922)world, pos);
        boolean above = this.above_condition.test(world, pos);
        boolean rain = !this.is_raining || world.method_8419();
        boolean thunder = !this.is_thundering || world.method_8546();
        return biome && solid && above && rain && thunder;
    }

    public static SpawnConditions parse(JsonObject json) {
        boolean solid = true;
        boolean rain = false;
        boolean thunder = false;
        if (json.has("is_solid")) {
            solid = json.get("is_solid").getAsBoolean();
        }
        if (json.has("is_raining")) {
            rain = json.get("is_raining").getAsBoolean();
        }
        if (json.has("is_thundering")) {
            thunder = json.get("is_thundering").getAsBoolean();
        }
        BlockAboveCondition above = new BlockAboveCondition(new ArrayList<class_2248>(), new ArrayList<class_2248>(), false);
        if (json.has("below")) {
            above = BlockAboveCondition.parse(json.get("below").getAsJsonObject());
        }
        BiomeCondition biome = new BiomeCondition(new ArrayList<String>(), new ArrayList<String>(), false);
        if (json.has("biome")) {
            biome = BiomeCondition.parse(json.get("biome").getAsJsonObject());
        }
        return new SpawnConditions(solid, above, biome, rain, thunder);
    }
}

