/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmaster435.biomeparticleweather.util.custom_particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.shadowmaster435.biomeparticleweather.particle.ParticleBase;
import org.shadowmaster435.biomeparticleweather.util.Vector3;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.CustomParticleBehavior;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.CustomParticleRegistry;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.misc.ParticleSpriteHandler;

public class CustomParticle
extends ParticleBase {
    public int frame = 0;
    private int last_frame = 0;
    public String particle_name = "missing";
    public CustomParticleBehavior behavior;
    public Vector3 random_cardinal_velocity = Vector3.ZERO;
    public float random_angular_velocity = 0.0f;
    public ParticleSpriteHandler sprite_handler;

    public CustomParticle(class_638 world, Vector3 pos, FabricSpriteProvider spriteProvider) {
        super(world, pos, spriteProvider);
        this.field_3847 = 10000;
    }

    public void init() {
        this.behavior = CustomParticleRegistry.behaviors.getOrDefault(this.particle_name, null);
        this.random_cardinal_velocity = this.behavior.accelerations().random_accelerations().sample_cardinal();
        this.angular_velocity += this.behavior.accelerations().constant().angular();
        this.random_angular_velocity += this.behavior.accelerations().random_accelerations().sample_angular();
        this.field_3862 = this.behavior.particle_parameters().collides_with_world();
        this.field_3847 = this.behavior.particle_parameters().max_age();
        this.method_3080(this.behavior.particle_parameters().horizontal_size(), this.behavior.particle_parameters().vertical_size());
        this.sprite_handler = CustomParticleRegistry.sprites.get(this.particle_name).duplicate();
        this.field_17867 = 0.125f;
        this.method_18141(this.sprite_handler.get_frame(0));
        this.field_3841 = 1.0f;
    }

    @Override
    public void method_3070() {
        super.method_3070();
        try {
            Vector3 constant_cardinal = this.behavior.accelerations().constant().cardinal();
            Vector3 trig_cardinal = new Vector3(this.get_sine().method_1019(this.get_cosine()));
            Vector3 additive_cardinal = this.behavior.accelerations().additive().cardinal().mul(this.field_3866);
            Vector3 damping_cardinal = this.behavior.accelerations().damping().cardinal_vel();
            float constant_angular = this.behavior.accelerations().constant().angular();
            float additive_angular = this.behavior.accelerations().additive().angular() * (float)this.field_3866;
            float damping_angular = this.behavior.accelerations().damping().angular_vel();
            Vector3 damped_cardinal = damping_cardinal.div(this.field_3866 + 1);
            float damped_angular = damping_angular / (float)(this.field_3866 + 1);
            if (damping_angular == 0.0f) {
                damped_angular = 1.0f;
            }
            if (damping_cardinal.field_1352 == 0.0) {
                damped_cardinal = damped_cardinal.with_x(1.0);
            }
            if (damping_cardinal.field_1351 == 0.0) {
                damped_cardinal = damped_cardinal.with_y(1.0);
            }
            if (damping_cardinal.field_1350 == 0.0) {
                damped_cardinal = damped_cardinal.with_z(1.0);
            }
            this.set_velocity(new Vector3(new Vector3(constant_cardinal.method_1019(this.random_cardinal_velocity).method_1019((class_243)trig_cardinal).method_1019((class_243)additive_cardinal)).method_18806(damped_cardinal)));
            this.angular_velocity = (constant_angular + this.random_angular_velocity + additive_angular) * damped_angular;
            this.sprite_handler.update(this);
            if (this.last_frame != this.frame) {
                this.method_18141(this.sprite_handler.get_frame(this.frame));
                this.last_frame = this.frame;
            }
            if (this.behavior.particle_parameters().remove_on_ground() && this.field_3845 || this.field_3866 >= this.field_3847) {
                this.method_3085();
            }
        }
        catch (Exception ignored) {
            this.method_3085();
            System.out.println("null particle");
        }
    }

    public Vector3 get_sine() {
        Vector3 amp = this.behavior.accelerations().trig().sine_amplitude();
        Vector3 spd = this.behavior.accelerations().trig().sine_speed();
        double x = Math.sin((double)this.field_3866 * spd.field_1352) * (amp.field_1352 * spd.field_1352);
        double y = Math.sin((double)this.field_3866 * spd.field_1351) * (amp.field_1351 * spd.field_1351);
        double z = Math.sin((double)this.field_3866 * spd.field_1350) * (amp.field_1350 * spd.field_1350);
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        if (Double.isNaN(z)) {
            z = 0.0;
        }
        return new Vector3(x, y, z);
    }

    public Vector3 get_cosine() {
        Vector3 amp = this.behavior.accelerations().trig().cosine_amplitude();
        Vector3 spd = this.behavior.accelerations().trig().cosine_speed();
        double x = Math.cos((double)this.field_3866 * spd.field_1352) * (amp.field_1352 * spd.field_1352);
        double y = Math.cos((double)this.field_3866 * spd.field_1351) * (amp.field_1351 * spd.field_1351);
        double z = Math.cos((double)this.field_3866 * spd.field_1350) * (amp.field_1350 * spd.field_1350);
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        if (Double.isNaN(z)) {
            z = 0.0;
        }
        return new Vector3(x, y, z);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final FabricSpriteProvider spriteProvider;

        public Factory(FabricSpriteProvider spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            CustomParticle particle = new CustomParticle(world, new Vector3(x, y, z), this.spriteProvider);
            particle.method_18140((class_4002)this.spriteProvider);
            return particle;
        }
    }
}

