/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmaster435.biomeparticleweather.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.joml.Vector2i;
import org.shadowmaster435.biomeparticleweather.util.Vector3;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.CustomParticleRegistry;
import org.shadowmaster435.biomeparticleweather.util.particle_model.ParticleModelPart;
import org.shadowmaster435.biomeparticleweather.util.particle_model.ParticleVoxel;
import org.shadowmaster435.biomeparticleweather.util.particle_model.ParticleVoxelParams;
import org.shadowmaster435.biomeparticleweather.util.particle_model.VoxelTransform;
import org.shadowmaster435.biomeparticleweather.util.particle_model.VoxelUVMap;

public class ModResourceLoader {
    public static HashMap<String, ParticleModelPart> models = new HashMap();
    public static int counter = 0;

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("biomeparticleweather", "particle_model");
            }

            public void method_14491(class_3300 manager) {
                models.clear();
                for (class_2960 id : manager.method_14488("textures/particle_model", path -> path.method_12832().endsWith(".png")).keySet().stream().toList()) {
                    try {
                        InputStream stream = ((class_3298)manager.method_14486(id).orElseThrow()).method_14482();
                        try {
                            ModResourceLoader.build_model(id, stream);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("biomeparticleweather", "particle_pack");
            }

            public void method_14491(class_3300 manager) {
                CustomParticleRegistry.behaviors.clear();
                CustomParticleRegistry.sprites.clear();
                for (class_2960 id : manager.method_14488("particles/custom", path -> path.method_12832().endsWith(".json")).keySet().stream().toList()) {
                    try {
                        InputStream stream = ((class_3298)manager.method_14486(id).orElseThrow()).method_14482();
                        try {
                            JsonObject gson = JsonParser.parseString((String)new String(stream.readAllBytes())).getAsJsonObject();
                            CustomParticleRegistry.register(id.method_12832(), gson);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        });
    }

    public static void build_model(class_2960 id, InputStream stream) {
        ArrayList<ParticleVoxel> result = new ArrayList<ParticleVoxel>();
        BufferedImage image = null;
        try {
            image = ImageIO.read(stream);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        int height = image.getHeight();
        int width = image.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int RGBA = image.getRGB(x, y);
                int alpha = RGBA >> 24 & 0xFF;
                if (alpha == 0) continue;
                VoxelUVMap uv = VoxelUVMap.single_pixel(new Vector2i(x, y));
                ParticleVoxel voxel = ParticleVoxel.create(new Vector3(x, y, 0.0f), new Vector3(1.0f), uv);
                result.add(voxel);
            }
        }
        ParticleVoxel[] voxels = result.toArray(new ParticleVoxel[0]);
        models.put(id.toString().replace("biomeparticleweather:textures/particle_model/", "").replace(".png", ""), new ParticleModelPart(voxels, new ParticleVoxelParams(Vector3.ONE, Vector3.ZERO, VoxelTransform.def())));
    }
}

