/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmaster435.biomeparticleweather.particle;

import java.util.HashMap;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_4970;
import net.minecraft.class_5702;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.shadowmaster435.biomeparticleweather.util.ParticleUtil;
import org.shadowmaster435.biomeparticleweather.util.Timer;
import org.shadowmaster435.biomeparticleweather.util.Vector3;

public class ParticleBase
extends class_4003 {
    private HashMap<String, Timer> animations = new HashMap();
    private float previous_alpha = 1.0f;
    private Vector3 previous_rgb = Vector3.ONE;
    private float previous_scale = 1.0f;
    private float target_alpha_fade = 1.0f;
    private Vector3 target_rgb_fade = Vector3.ONE;
    private float target_scale_fade = 1.0f;
    private boolean fading_alpha = false;
    private boolean fading_rgb = false;
    private boolean fading_scale = false;
    public long random_seed = class_5819.method_43053().method_43054();
    public float angular_velocity = 0.0f;
    public float orbit_velocity = 0.0f;
    public FabricSpriteProvider provider;

    public ParticleBase(class_638 world, Vector3 pos, FabricSpriteProvider spriteProvider) {
        super(world, pos.field_1352, pos.field_1351, pos.field_1350);
        this.provider = spriteProvider;
        this.create_animation_timers();
        this.field_3862 = false;
    }

    private void create_animation_timers() {
        Timer fade_alpha = new Timer();
        Timer fade_scale = new Timer();
        Timer fade_rgb = new Timer();
        this.animations.put("fade_alpha", fade_alpha);
        this.animations.put("fade_scale", fade_scale);
        this.animations.put("fade_rgb", fade_rgb);
    }

    public void fade_alpha(float to, int ticks) {
        this.previous_alpha = this.field_3841;
        this.target_alpha_fade = to;
        this.animations.get("fade_alpha").start(ticks);
        this.fading_alpha = true;
    }

    public void fade_rgb(Vector3 to, int ticks) {
        this.previous_rgb = this.get_color();
        this.target_rgb_fade = to;
        this.animations.get("fade_rgb").start(ticks);
        this.fading_rgb = true;
    }

    public void fade_scale(float to, int ticks) {
        this.previous_scale = this.field_17867;
        this.animations.get("fade_scale").start(ticks);
        this.target_scale_fade = to;
        this.fading_scale = true;
    }

    public void process_animations() {
        Timer timer;
        if (this.fading_alpha) {
            timer = this.animations.get("fade_alpha");
            this.field_3841 = class_3532.method_16439((float)timer.delta(), (float)this.previous_alpha, (float)this.target_alpha_fade);
            if (timer.is_finished()) {
                this.fading_alpha = false;
            }
            timer.update();
        }
        if (this.fading_rgb) {
            timer = this.animations.get("fade_rgb");
            this.set_color(new Vector3(this.previous_rgb.lerp(this.target_rgb_fade, timer.delta())));
            if (timer.is_finished()) {
                this.fading_rgb = false;
            }
            timer.update();
        }
        if (this.fading_scale) {
            timer = this.animations.get("fade_scale");
            this.field_17867 = class_3532.method_16439((float)timer.delta(), (float)this.previous_scale, (float)this.target_scale_fade);
            if (timer.is_finished()) {
                this.fading_scale = false;
            }
            timer.update();
        }
    }

    public void method_3070() {
        super.method_3070();
        this.process_animations();
        this.field_3857 = this.field_3839;
        this.field_3839 += (float)Math.toRadians(this.angular_velocity);
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public Vector3 get_color() {
        return new Vector3(this.field_3861, this.field_3842, this.field_3859);
    }

    public void set_color(Vector3 vec) {
        this.method_3084((float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350);
    }

    public void bounce() {
        if (this.is_colliding()) {
            this.set_velocity(this.get_velocity().bounce(this.get_collision_direction()));
        }
    }

    public boolean in_block() {
        return this.field_3851.method_8320(this.get_pos().to_blockpos()).method_26212((class_1922)this.field_3851, this.get_pos().to_blockpos());
    }

    public Vector3 get_orbit_tangent(Vector3 point, float gravity_scale) {
        return this.get_pos().angle_to(point, Math.max((double)this.orbit_velocity, 0.01) / Math.max(this.get_pos().method_1022(point), 0.01));
    }

    public Vector3 get_pull_tangent(Vector3 point, float gravity_scale) {
        Vector3 v = this.get_orbit_tangent(point);
        return v.lerp(point, gravity_scale);
    }

    public Vector3 get_orbit_tangent(Vector3 point) {
        return this.get_pos().angle_to(point, Math.max((double)this.orbit_velocity, 0.01) / Math.max(this.get_pos().method_1022(point), 0.01));
    }

    public void div_vel(Vector3 scalar) {
        this.set_velocity(this.get_velocity().div(scalar));
    }

    public void mul_vel(Vector3 scalar) {
        this.set_velocity(this.get_velocity().mul(scalar));
    }

    public void set_position(Vector3 pos) {
        this.field_3874 = pos.field_1352;
        this.field_3854 = pos.field_1351;
        this.field_3871 = pos.field_1350;
    }

    public void add_position(Vector3 pos) {
        this.field_3874 += pos.field_1352;
        this.field_3854 += pos.field_1351;
        this.field_3871 += pos.field_1350;
    }

    public void orbit(Vector3 pos) {
        Vector3 tangent = this.get_orbit_tangent(pos);
        this.add_position(new Vector3(0.0, tangent.field_1351, tangent.field_1350).mul(this.orbit_velocity));
    }

    public void orbit(Vector3 pos, float distance) {
    }

    public void bounce(class_2350 direction) {
        this.set_velocity(this.get_velocity().bounce(direction));
    }

    public void bounce(Vector3 offset) {
        if (this.is_colliding(offset)) {
            this.set_velocity(this.get_velocity().bounce(this.get_collision_direction()));
        }
    }

    public void set_velocity(Vector3 vec) {
        this.field_3852 = vec.field_1352;
        this.field_3869 = vec.field_1351;
        this.field_3850 = vec.field_1350;
    }

    public void add_velocity(Vector3 vec) {
        this.field_3852 += vec.field_1352;
        this.field_3869 += vec.field_1351;
        this.field_3850 += vec.field_1350;
    }

    public class_2350 get_collision_direction() {
        return this.get_hit_result().method_17780();
    }

    public class_2350 get_collision_direction(Vector3 offset) {
        return this.get_hit_result(offset).method_17780();
    }

    public boolean is_colliding() {
        return this.get_hit_result().method_17783() != class_239.class_240.field_1333;
    }

    public boolean is_colliding(Vector3 offset) {
        return this.get_hit_result(offset).method_17781();
    }

    public boolean is_raycast_colliding(Vector3 pos) {
        return this.raycast_to(pos).method_17783() != class_239.class_240.field_1333;
    }

    public class_3965 get_fluid_hit_result() {
        class_5702 ctx = new class_5702((class_243)this.get_pos(), (class_243)this.get_pos(), class_4970.class_4971::method_51176);
        return ParticleUtil.get_world().method_32880(ctx);
    }

    public class_3965 get_fluid_hit_result(Vector3 offset) {
        class_5702 ctx = new class_5702((class_243)this.get_pos(), this.get_pos().method_1019(offset), class_4970.class_4971::method_51176);
        return ParticleUtil.get_world().method_32880(ctx);
    }

    public class_3965 raycast_to(Vector3 pos) {
        class_5702 ctx = new class_5702((class_243)this.get_pos(), (class_243)pos, Predicate.not(class_4970.class_4971::method_26215));
        return ParticleUtil.get_world().method_32880(ctx);
    }

    public class_3965 get_hit_result(Vector3 offset) {
        class_5702 ctx = new class_5702((class_243)this.get_previous_pos(), this.get_pos().method_1019(offset), class_4970.class_4971::method_51366);
        return ParticleUtil.get_world().method_32880(ctx);
    }

    public class_3965 get_hit_result() {
        class_5702 ctx = new class_5702((class_243)this.get_pos(), this.get_pos().method_1019(this.get_velocity_length_vector()), class_4970.class_4971::method_51367);
        return ParticleUtil.get_world().method_32880(ctx);
    }

    public Vector3 get_velocity_length_vector() {
        double hlength = this.get_velocity().method_1033();
        double vlength = new Vector3(this.get_velocity().field_1352, 0.0, this.get_velocity().field_1350).method_1033();
        return new Vector3(this.get_velocity());
    }

    public Vector3 get_velocity() {
        return new Vector3(this.field_3852, this.field_3869, this.field_3850);
    }

    public Vector3 get_pos() {
        return new Vector3(this.field_3874, this.field_3854, this.field_3871);
    }

    public Vector3 get_previous_pos() {
        return new Vector3(this.field_3858, this.field_3838, this.field_3856);
    }

    public Vector3 get_hit_pos(Vector3 offset) {
        return new Vector3(this.get_hit_result(offset).method_17784());
    }

    public Vector3 get_hit_pos() {
        return new Vector3(this.get_hit_result().method_17784());
    }

    public Vector3 get_hit_fluid_surface() {
        class_3965 hit = this.get_fluid_hit_result();
        return new Vector3(hit.method_17784());
    }

    public boolean will_collide_with_fluid() {
        class_3965 hit = this.get_fluid_hit_result();
        return hit.method_17781();
    }

    public int method_3068(float tint) {
        return super.method_3068(tint);
    }
}

