/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmaster435.biomeparticleweather.gui;

import java.util.HashMap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.shadowmaster435.biomeparticleweather.gui.PagedScreen;
import org.shadowmaster435.biomeparticleweather.gui.TypedTextFieldWidget;
import org.shadowmaster435.biomeparticleweather.util.ConfigFile;
import org.shadowmaster435.biomeparticleweather.util.ConfigParameters;
import org.shadowmaster435.biomeparticleweather.util.ParticleSettings;

@Environment(value=EnvType.CLIENT)
public class AmountSettingScreen
extends PagedScreen {
    private final class_437 parent;
    public HashMap<ConfigParameters, class_342> options = new HashMap();
    public final String[] valid_chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "."};

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        ConfigFile.save_config();
    }

    public AmountSettingScreen(class_437 parent) {
        super(parent);
        this.parent = parent;
    }

    protected void method_25426() {
        try {
            this.add_setting(new ConfigParameters("spawn_radius", "int"));
            this.add_setting(new ConfigParameters("global_multiplier", "float"));
            this.add_setting(new ConfigParameters("rain_amount", "float"));
            this.add_setting(new ConfigParameters("heavy_rain_amount", "float"));
            this.add_setting(new ConfigParameters("fog_amount", "float"));
            this.add_setting(new ConfigParameters("wind_amount", "float"));
            this.add_setting(new ConfigParameters("sand_mote_amount", "float"));
            this.add_setting(new ConfigParameters("red_sand_mote_amount", "float"));
            this.add_setting(new ConfigParameters("snow_amount", "float"));
            this.add_setting(new ConfigParameters("blizzard_snow_amount", "float"));
            this.add_setting(new ConfigParameters("blizzard_wind_amount", "float"));
            this.add_setting(new ConfigParameters("tumblebush_amount", "float"));
            this.add_setting(new ConfigParameters("updraft_amount", "float"));
            this.add_setting(new ConfigParameters("spore_amount", "float"));
            this.add_setting(new ConfigParameters("weeping_tear_amount", "float"));
            this.add_setting(new ConfigParameters("soul_amount", "float"));
            this.add_setting(new ConfigParameters("lightning_particle_density", "int"));
            for (ConfigParameters parameters : this.options.keySet()) {
                if (Objects.equals(parameters.type(), "float")) {
                    this.set_text_of(parameters, String.valueOf(ParticleSettings.get_float(parameters.name())));
                }
                if (!Objects.equals(parameters.type(), "int")) continue;
                this.set_text_of(parameters, String.valueOf(ParticleSettings.get_int(parameters.name())));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void add_setting(ConfigParameters parameters) {
        class_7842 text_display = new class_7842(4, 4 + 20 * (this.options.size() % 10), 512, 16, (class_2561)class_2561.method_43471((String)("biomeparticleweather." + parameters.name())), class_310.method_1551().field_1772);
        TypedTextFieldWidget text_input = new TypedTextFieldWidget(class_310.method_1551().field_1772, this.field_22789 - 68, 4 + 20 * (this.options.size() % 10), 64, 16, class_2561.method_30163((String)""), parameters);
        text_display.method_48596();
        this.options.put(parameters, text_input);
        text_display.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("biomeparticleweather." + parameters.name() + ".tooltip"))));
        text_input.setTrackedChangedListener(a -> this.changed(new TypedTextFieldWidget.TrackedListener(a.text(), a.id(), a.type())));
        this.method_37063((class_364)text_display);
        this.method_37063((class_364)text_input);
        this.add_entry(new Object[]{text_display, text_input});
    }

    public void set_float_setting(String key, float value) {
        ParticleSettings.set_float(key, value);
    }

    public void set_int_setting(String key, int value) {
        ParticleSettings.set_int(key, value);
    }

    public void changed(TypedTextFieldWidget.TrackedListener listener) {
        this.set_setting(new ConfigParameters(listener.id(), listener.type()), listener.text());
    }

    public void set_text_of(ConfigParameters parameters, String text) {
        for (ConfigParameters param : this.options.keySet()) {
            if (!param.match(parameters)) continue;
            this.options.get(param).method_1852(text);
            return;
        }
    }

    public void set_setting(ConfigParameters parameters, String text) {
        if (Objects.equals(parameters.type(), "float")) {
            try {
                this.set_float_setting(parameters.name(), Float.parseFloat(text));
            }
            catch (Exception ignored) {
                this.set_text_of(new ConfigParameters(parameters.name(), parameters.type()), String.valueOf(ParticleSettings.get_float(parameters.name())));
                System.out.println("float parse failed");
            }
        }
        if (Objects.equals(parameters.type(), "int")) {
            try {
                this.set_int_setting(parameters.name(), Integer.parseInt(text));
            }
            catch (Exception ignored) {
                this.set_text_of(new ConfigParameters(parameters.name(), parameters.type()), String.valueOf(ParticleSettings.get_int(parameters.name())));
                System.out.println("int parse failed");
            }
        }
    }
}

