/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;

public final class NBTConverter {
    private NBTConverter() {
    }

    public static net.minecraft.nbt.Tag toNative(Tag tag) {
        if (tag instanceof com.sk89q.jnbt.IntArrayTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.IntArrayTag)tag);
        }
        if (tag instanceof ListTag) {
            return NBTConverter.toNative((ListTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.LongTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.LongTag)tag);
        }
        if (tag instanceof LongArrayTag) {
            return NBTConverter.toNative((LongArrayTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.StringTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.StringTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.IntTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.IntTag)tag);
        }
        if (tag instanceof ByteTag) {
            return NBTConverter.toNative((ByteTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.ByteArrayTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.ByteArrayTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.CompoundTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.CompoundTag)tag);
        }
        if (tag instanceof FloatTag) {
            return NBTConverter.toNative((FloatTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.ShortTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.ShortTag)tag);
        }
        if (tag instanceof com.sk89q.jnbt.DoubleTag) {
            return NBTConverter.toNative((com.sk89q.jnbt.DoubleTag)tag);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public static IntArrayTag toNative(com.sk89q.jnbt.IntArrayTag tag) {
        int[] value = tag.getValue();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public static net.minecraft.nbt.ListTag toNative(ListTag tag) {
        net.minecraft.nbt.ListTag list = new net.minecraft.nbt.ListTag();
        Iterator iterator = tag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag child = (Tag)iterator.next();
            if (child instanceof com.sk89q.jnbt.EndTag) continue;
            list.add((Object)NBTConverter.toNative(child));
        }
        return list;
    }

    public static LongTag toNative(com.sk89q.jnbt.LongTag tag) {
        return LongTag.m_128882_((long)tag.getValue());
    }

    public static net.minecraft.nbt.LongArrayTag toNative(LongArrayTag tag) {
        return new net.minecraft.nbt.LongArrayTag((long[])tag.getValue().clone());
    }

    public static StringTag toNative(com.sk89q.jnbt.StringTag tag) {
        return StringTag.m_129297_((String)tag.getValue());
    }

    public static IntTag toNative(com.sk89q.jnbt.IntTag tag) {
        return IntTag.m_128679_((int)tag.getValue());
    }

    public static net.minecraft.nbt.ByteTag toNative(ByteTag tag) {
        return net.minecraft.nbt.ByteTag.m_128266_((byte)tag.getValue());
    }

    public static ByteArrayTag toNative(com.sk89q.jnbt.ByteArrayTag tag) {
        return new ByteArrayTag((byte[])tag.getValue().clone());
    }

    public static CompoundTag toNative(com.sk89q.jnbt.CompoundTag tag) {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry child : tag.getValue().entrySet()) {
            compound.m_128365_((String)child.getKey(), NBTConverter.toNative((Tag)child.getValue()));
        }
        return compound;
    }

    public static net.minecraft.nbt.FloatTag toNative(FloatTag tag) {
        return net.minecraft.nbt.FloatTag.m_128566_((float)tag.getValue().floatValue());
    }

    public static ShortTag toNative(com.sk89q.jnbt.ShortTag tag) {
        return ShortTag.m_129258_((short)tag.getValue());
    }

    public static DoubleTag toNative(com.sk89q.jnbt.DoubleTag tag) {
        return DoubleTag.m_128500_((double)tag.getValue());
    }

    public static Tag fromNative(net.minecraft.nbt.Tag other) {
        if (other instanceof IntArrayTag) {
            return NBTConverter.fromNative((IntArrayTag)other);
        }
        if (other instanceof net.minecraft.nbt.ListTag) {
            return NBTConverter.fromNative((net.minecraft.nbt.ListTag)other);
        }
        if (other instanceof EndTag) {
            return NBTConverter.fromNative((EndTag)other);
        }
        if (other instanceof LongTag) {
            return NBTConverter.fromNative((LongTag)other);
        }
        if (other instanceof net.minecraft.nbt.LongArrayTag) {
            return NBTConverter.fromNative((net.minecraft.nbt.LongArrayTag)other);
        }
        if (other instanceof StringTag) {
            return NBTConverter.fromNative((StringTag)other);
        }
        if (other instanceof IntTag) {
            return NBTConverter.fromNative((IntTag)other);
        }
        if (other instanceof net.minecraft.nbt.ByteTag) {
            return NBTConverter.fromNative((net.minecraft.nbt.ByteTag)other);
        }
        if (other instanceof ByteArrayTag) {
            return NBTConverter.fromNative((ByteArrayTag)other);
        }
        if (other instanceof CompoundTag) {
            return NBTConverter.fromNative((CompoundTag)other);
        }
        if (other instanceof net.minecraft.nbt.FloatTag) {
            return NBTConverter.fromNative((net.minecraft.nbt.FloatTag)other);
        }
        if (other instanceof ShortTag) {
            return NBTConverter.fromNative((ShortTag)other);
        }
        if (other instanceof DoubleTag) {
            return NBTConverter.fromNative((DoubleTag)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public static com.sk89q.jnbt.IntArrayTag fromNative(IntArrayTag other) {
        int[] value = other.m_128648_();
        return new com.sk89q.jnbt.IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public static ListTag fromNative(net.minecraft.nbt.ListTag other) {
        other = other.m_6426_();
        ArrayList<Tag> list = new ArrayList<Tag>();
        Class listClass = com.sk89q.jnbt.StringTag.class;
        int tags = other.size();
        for (int i = 0; i < tags; ++i) {
            Tag child = NBTConverter.fromNative(other.remove(0));
            list.add(child);
            listClass = child.getClass();
        }
        return new ListTag(listClass, list);
    }

    public static com.sk89q.jnbt.EndTag fromNative(EndTag other) {
        return new com.sk89q.jnbt.EndTag();
    }

    public static com.sk89q.jnbt.LongTag fromNative(LongTag other) {
        return new com.sk89q.jnbt.LongTag(other.m_7046_());
    }

    public static LongArrayTag fromNative(net.minecraft.nbt.LongArrayTag other) {
        return new LongArrayTag((long[])other.m_128851_().clone());
    }

    public static com.sk89q.jnbt.StringTag fromNative(StringTag other) {
        return new com.sk89q.jnbt.StringTag(other.m_7916_());
    }

    public static com.sk89q.jnbt.IntTag fromNative(IntTag other) {
        return new com.sk89q.jnbt.IntTag(other.m_7047_());
    }

    public static ByteTag fromNative(net.minecraft.nbt.ByteTag other) {
        return new ByteTag(other.m_7063_());
    }

    public static com.sk89q.jnbt.ByteArrayTag fromNative(ByteArrayTag other) {
        return new com.sk89q.jnbt.ByteArrayTag((byte[])other.m_128227_().clone());
    }

    public static com.sk89q.jnbt.CompoundTag fromNative(CompoundTag other) {
        Set tags = other.m_128431_();
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String tagName : tags) {
            map.put(tagName, NBTConverter.fromNative(other.m_128423_(tagName)));
        }
        return new com.sk89q.jnbt.CompoundTag(map);
    }

    public static FloatTag fromNative(net.minecraft.nbt.FloatTag other) {
        return new FloatTag(other.m_7057_());
    }

    public static com.sk89q.jnbt.ShortTag fromNative(ShortTag other) {
        return new com.sk89q.jnbt.ShortTag(other.m_7053_());
    }

    public static com.sk89q.jnbt.DoubleTag fromNative(DoubleTag other) {
        return new com.sk89q.jnbt.DoubleTag(other.m_7061_());
    }
}

