/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.internal.IPropertyAdapter;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ForgeTransmogrifier {
    private static final LoadingCache<Property<?>, com.sk89q.worldedit.registry.state.Property<?>> PROPERTY_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Property<?>, com.sk89q.worldedit.registry.state.Property<?>>(){

        public com.sk89q.worldedit.registry.state.Property<?> load(Property<?> property) throws Exception {
            if (property instanceof net.minecraft.world.level.block.state.properties.BooleanProperty) {
                return new BooleanProperty(property.m_61708_(), (List<Boolean>)ImmutableList.copyOf((Collection)((net.minecraft.world.level.block.state.properties.BooleanProperty)property).m_6908_()));
            }
            if (property instanceof IntegerProperty) {
                return new com.sk89q.worldedit.registry.state.IntegerProperty(property.m_61708_(), (List<Integer>)ImmutableList.copyOf((Collection)((IntegerProperty)property).m_6908_()));
            }
            if (property instanceof DirectionProperty) {
                return new DirectionalProperty(property.m_61708_(), ((DirectionProperty)property).m_6908_().stream().map(ForgeAdapter::adaptEnumFacing).collect(Collectors.toList()));
            }
            if (property instanceof net.minecraft.world.level.block.state.properties.EnumProperty) {
                return new EnumProperty(property.m_61708_(), ((net.minecraft.world.level.block.state.properties.EnumProperty)property).m_6908_().stream().map(x -> ((StringRepresentable)x).m_7912_()).collect(Collectors.toList()));
            }
            return new IPropertyAdapter(property);
        }
    });

    public static com.sk89q.worldedit.registry.state.Property<?> transmogToWorldEditProperty(Property<?> property) {
        return (com.sk89q.worldedit.registry.state.Property)PROPERTY_CACHE.getUnchecked(property);
    }

    public static Map<com.sk89q.worldedit.registry.state.Property<?>, Object> transmogToWorldEditProperties(BlockType block, Map<Property<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(com.sk89q.worldedit.registry.state.Property::getName));
        for (Map.Entry<Property<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof DirectionProperty) {
                value = ForgeAdapter.adaptEnumFacing((Direction)value);
            } else if (prop.getKey() instanceof net.minecraft.world.level.block.state.properties.EnumProperty) {
                value = ((StringRepresentable)value).m_7912_();
            }
            props.put(block.getProperty(prop.getKey().m_61708_()), value);
        }
        return props;
    }

    private static net.minecraft.world.level.block.state.BlockState transmogToMinecraftProperties(StateDefinition<Block, net.minecraft.world.level.block.state.BlockState> stateContainer, net.minecraft.world.level.block.state.BlockState newState, Map<com.sk89q.worldedit.registry.state.Property<?>, Object> states) {
        for (Map.Entry<com.sk89q.worldedit.registry.state.Property<?>, Object> state : states.entrySet()) {
            Property property = stateContainer.m_61081_(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof DirectionProperty) {
                com.sk89q.worldedit.util.Direction dir = (com.sk89q.worldedit.util.Direction)((Object)value);
                value = ForgeAdapter.adapt(dir);
            } else if (property instanceof net.minecraft.world.level.block.state.properties.EnumProperty) {
                String enumName = (String)((Object)value);
                value = (Comparable)((net.minecraft.world.level.block.state.properties.EnumProperty)property).m_6215_((String)((Object)value)).orElseThrow(() -> new IllegalStateException("Enum property " + property.m_61708_() + " does not contain " + enumName));
            }
            newState = (net.minecraft.world.level.block.state.BlockState)newState.m_61124_(property, value);
        }
        return newState;
    }

    public static net.minecraft.world.level.block.state.BlockState transmogToMinecraft(BlockState blockState) {
        Block mcBlock = ForgeAdapter.adapt(blockState.getBlockType());
        net.minecraft.world.level.block.state.BlockState newState = mcBlock.m_49966_();
        Map<com.sk89q.worldedit.registry.state.Property<?>, Object> states = blockState.getStates();
        return ForgeTransmogrifier.transmogToMinecraftProperties((StateDefinition<Block, net.minecraft.world.level.block.state.BlockState>)mcBlock.m_49965_(), newState, states);
    }

    public static BlockState transmogToWorldEdit(net.minecraft.world.level.block.state.BlockState blockState) {
        BlockType blockType = ForgeAdapter.adapt(blockState.m_60734_());
        return blockType.getState(ForgeTransmogrifier.transmogToWorldEditProperties(blockType, blockState.m_61148_()));
    }

    private ForgeTransmogrifier() {
    }
}

