/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PrismarineCoralFeature
extends Feature<NoneFeatureConfiguration> {
    public PrismarineCoralFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    protected static BlockState coralBlock(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_BLOCK.get()).m_49966_() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_BLOCK.get()).m_49966_();
    }

    protected static BlockState coral(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL.get()).m_49966_() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL.get()).m_49966_();
    }

    protected static BlockState coralFan(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_FAN.get()).m_49966_() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_FAN.get()).m_49966_();
    }

    protected static BlockState coralWallFan(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_WALL_FAN.get()).m_49966_() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_WALL_FAN.get()).m_49966_();
    }

    protected static BlockState coralShower(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_SHOWER.get()).m_49966_() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_SHOWER.get()).m_49966_();
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        if (PrismarineCoralFeature.shouldPlace((LevelAccessor)world, pos)) {
            int a = rand.m_188503_(4) + 2;
            int c = rand.m_188503_(5) + 3;
            int b = 4;
            if (pos.m_123342_() > 11) {
                PrismarineCoralFeature.addShelf((LevelAccessor)world, pos, rand, a, b, c, rand.m_188500_() <= 0.35);
                if (rand.m_188499_()) {
                    BlockPos pairPos = pos.m_121945_(Direction.m_235672_((RandomSource)rand)).m_6630_(rand.m_188503_(2) + 2);
                    if (PrismarineCoralFeature.isInWaterNextToStone((LevelAccessor)world, pairPos)) {
                        PrismarineCoralFeature.addShelf((LevelAccessor)world, pairPos, rand, 3, 3, c + 1, rand.m_188500_() <= 0.35);
                    }
                    if (rand.m_188499_() && PrismarineCoralFeature.isInWaterNextToStone((LevelAccessor)world, pairPos = pos.m_121945_(Direction.m_235672_((RandomSource)rand)).m_6625_(rand.m_188503_(2) + 2))) {
                        PrismarineCoralFeature.addShelf((LevelAccessor)world, pairPos, rand, 3, 4, c + 1, rand.m_188500_() <= 0.35);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isInWaterNextToStone(LevelAccessor level, BlockPos pos) {
        if (!level.m_46801_(pos)) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            if (!level.m_8055_((BlockPos)mutableBlockPos).m_204336_(BlockTags.f_13061_)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldPlace(LevelAccessor level, BlockPos pos) {
        if (!PrismarineCoralFeature.isInWaterNextToStone(level, pos)) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos checkPos = pos.m_6625_(i);
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60734_() != Blocks.f_50450_ && state.m_60734_() != Blocks.f_50080_) continue;
            return true;
        }
        return false;
    }

    private static void addShelf(LevelAccessor world, BlockPos pos, RandomSource rand, int a, int b, int c, boolean isElder) {
        MathUtil.Equation r = theta -> (Math.cos((double)b * theta) / (double)c + 1.0) * (double)a;
        for (int i = -(a / c + a); i < a / c + a; ++i) {
            for (int j = -(a / c + a); j < a / c + a; ++j) {
                BlockPos below;
                double radius = r.compute(Math.atan2(j, i));
                BlockPos placingPos = pos.m_7918_(i, 0, j);
                if (!(world.m_8055_(placingPos).m_247087_() && (double)(i * i + j * j) < radius * radius || world.m_8055_(placingPos).m_60734_() == UABlocks.PRISMARINE_CORAL_WALL_FAN.get() && (double)(i * i + j * j) < radius * radius) && (world.m_8055_(placingPos).m_60734_() != UABlocks.ELDER_PRISMARINE_CORAL_WALL_FAN.get() || !((double)(i * i + j * j) < radius * radius))) continue;
                world.m_7731_(placingPos, PrismarineCoralFeature.coralBlock(isElder), 2);
                if (!rand.m_188499_()) continue;
                BlockPos above = placingPos.m_7494_();
                if (world.m_46801_(above)) {
                    world.m_7731_(above, rand.m_188499_() ? PrismarineCoralFeature.coral(isElder) : PrismarineCoralFeature.coralFan(isElder), 2);
                }
                if (world.m_46801_(below = placingPos.m_7495_())) {
                    world.m_7731_(below, PrismarineCoralFeature.coralShower(isElder), 2);
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos1;
                    if (!(rand.m_188501_() < 0.85f) || world.m_8055_(blockpos1 = placingPos.m_121945_(direction)).m_60734_() != Blocks.f_49990_) continue;
                    BlockState blockstate1 = (BlockState)PrismarineCoralFeature.coralWallFan(isElder).m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)direction);
                    world.m_7731_(blockpos1, blockstate1, 2);
                }
            }
        }
    }
}

