/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAParticleTypes;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JellyTorchBlock
extends TorchBlock
implements SimpleWaterloggedBlock {
    private final JellyTorchType torchType;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public JellyTorchBlock(BlockBehaviour.Properties props, JellyTorchType torchType) {
        super(props, null);
        this.torchType = torchType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        double xOffset = rand.m_188499_() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double yOffset = rand.m_188499_() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double zOffset = rand.m_188499_() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double d0 = (double)pos.m_123341_() + 0.5 + xOffset;
        double d1 = (double)pos.m_123342_() + 0.5 + yOffset;
        double d2 = (double)pos.m_123343_() + 0.5 + zOffset;
        world.m_7106_((ParticleOptions)JellyTorchType.getTorchParticleType(this.torchType), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, stateIn, worldIn, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static enum JellyTorchType {
        PINK(ChatFormatting.LIGHT_PURPLE, () -> (Block)UABlocks.PINK_JELLY_TORCH.get()),
        PURPLE(ChatFormatting.DARK_PURPLE, () -> (Block)UABlocks.PURPLE_JELLY_TORCH.get()),
        BLUE(ChatFormatting.BLUE, () -> (Block)UABlocks.BLUE_JELLY_TORCH.get()),
        GREEN(ChatFormatting.GREEN, () -> (Block)UABlocks.GREEN_JELLY_TORCH.get()),
        YELLOW(ChatFormatting.YELLOW, () -> (Block)UABlocks.YELLOW_JELLY_TORCH.get()),
        ORANGE(ChatFormatting.GOLD, () -> (Block)UABlocks.ORANGE_JELLY_TORCH.get()),
        RED(ChatFormatting.RED, () -> (Block)UABlocks.RED_JELLY_TORCH.get()),
        WHITE(ChatFormatting.WHITE, () -> (Block)UABlocks.WHITE_JELLY_TORCH.get());

        public final ChatFormatting color;
        public final Supplier<Block> torch;
        private static final JellyTorchType[] VALUES;

        private JellyTorchType(ChatFormatting color, Supplier<Block> torch) {
            this.color = color;
            this.torch = torch;
        }

        public static JellyTorchType getByOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        public static SimpleParticleType getTorchParticleType(JellyTorchType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case PINK -> (SimpleParticleType)UAParticleTypes.PINK_JELLY_FLAME.get();
                case PURPLE -> (SimpleParticleType)UAParticleTypes.PURPLE_JELLY_FLAME.get();
                case BLUE -> (SimpleParticleType)UAParticleTypes.BLUE_JELLY_FLAME.get();
                case GREEN -> (SimpleParticleType)UAParticleTypes.GREEN_JELLY_FLAME.get();
                case YELLOW -> (SimpleParticleType)UAParticleTypes.YELLOW_JELLY_FLAME.get();
                case ORANGE -> (SimpleParticleType)UAParticleTypes.ORANGE_JELLY_FLAME.get();
                case RED -> (SimpleParticleType)UAParticleTypes.RED_JELLY_FLAME.get();
                case WHITE -> (SimpleParticleType)UAParticleTypes.WHITE_JELLY_FLAME.get();
            };
        }

        public static SimpleParticleType getBlobParticleType(JellyTorchType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case PINK -> (SimpleParticleType)UAParticleTypes.PINK_JELLY_BLOB.get();
                case PURPLE -> (SimpleParticleType)UAParticleTypes.PURPLE_JELLY_BLOB.get();
                case BLUE -> (SimpleParticleType)UAParticleTypes.BLUE_JELLY_BLOB.get();
                case GREEN -> (SimpleParticleType)UAParticleTypes.GREEN_JELLY_BLOB.get();
                case YELLOW -> (SimpleParticleType)UAParticleTypes.YELLOW_JELLY_BLOB.get();
                case ORANGE -> (SimpleParticleType)UAParticleTypes.ORANGE_JELLY_BLOB.get();
                case RED -> (SimpleParticleType)UAParticleTypes.RED_JELLY_BLOB.get();
                case WHITE -> (SimpleParticleType)UAParticleTypes.WHITE_JELLY_BLOB.get();
            };
        }

        static {
            VALUES = JellyTorchType.values();
        }
    }
}

