/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials;

import com.structureessentials.IStructureModifier;
import com.structureessentials.Timings;
import com.structureessentials.command.Command;
import com.structureessentials.config.CommonConfiguration;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structureessentials")
public class StructureEssentials {
    public static final String MODID = "structureessentials";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Random rand = new Random();

    public StructureEssentials() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::commandRegister);
    }

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register(new Command().build(event.getBuildContext()));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("structureessentials mod initialized");
    }

    public static void onServerStart(MinecraftServer server) {
        Timings.featureTimings = new ConcurrentHashMap<ResourceLocation, Long>();
        Timings.structureTimings = new ConcurrentHashMap<ResourceLocation, Long>();
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        List holders = registryAccess.m_175515_(Registries.f_256944_).m_203611_().toList();
        Registry biomeRegistry = (Registry)registryAccess.m_6632_(Registries.f_256952_).get();
        Registry structureSetRegistry = registryAccess.m_175515_(Registries.f_256998_);
        if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).logDuplicatedSalt) {
            Int2ObjectOpenHashMap structureSetIds = new Int2ObjectOpenHashMap();
            for (Map.Entry entry : structureSetRegistry.m_6579_()) {
                int salt = ((StructureSet)entry.getValue()).f_210004_().m_227075_();
                structureSetIds.putIfAbsent(salt, new HashSet());
                ((Set)structureSetIds.get(salt)).add(((ResourceKey)entry.getKey()).m_135782_().toString());
            }
            for (Map.Entry entry : structureSetIds.int2ObjectEntrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                LOGGER.warn("Non-unique structure_set salt:" + entry.getIntKey() + " potentially creating overlapping structures detected. Structure sets: " + entry.getValue());
            }
        }
        if (!((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompat) {
            return;
        }
        HashMap<ResourceLocation, TagKey> directReplacementTags = new HashMap<ResourceLocation, TagKey>();
        directReplacementTags.put(new ResourceLocation("deep_ocean"), BiomeTags.f_207602_);
        directReplacementTags.put(new ResourceLocation("ocean"), BiomeTags.f_207603_);
        directReplacementTags.put(new ResourceLocation("river"), BiomeTags.f_207605_);
        directReplacementTags.put(new ResourceLocation("badlands"), BiomeTags.f_207607_);
        directReplacementTags.put(new ResourceLocation("eroded_badlands"), BiomeTags.f_207607_);
        directReplacementTags.put(new ResourceLocation("wooded_badlands"), BiomeTags.f_207607_);
        directReplacementTags.put(new ResourceLocation("windswept_hills"), BiomeTags.f_207608_);
        directReplacementTags.put(new ResourceLocation("windswept_gravelly_hills"), BiomeTags.f_207608_);
        directReplacementTags.put(new ResourceLocation("taiga"), BiomeTags.f_207609_);
        directReplacementTags.put(new ResourceLocation("jungle"), BiomeTags.f_207610_);
        directReplacementTags.put(new ResourceLocation("forest"), BiomeTags.f_207611_);
        directReplacementTags.put(new ResourceLocation("savanna"), BiomeTags.f_215816_);
        directReplacementTags.put(new ResourceLocation("deep_dark"), BiomeTags.f_215799_);
        directReplacementTags.put(new ResourceLocation("plains"), Tags.Biomes.IS_PLAINS);
        directReplacementTags.put(new ResourceLocation("desert"), Tags.Biomes.IS_DESERT);
        directReplacementTags.put(new ResourceLocation("swamp"), Tags.Biomes.IS_SWAMP);
        directReplacementTags.put(new ResourceLocation("mushroom_fields"), Tags.Biomes.IS_MUSHROOM);
        directReplacementTags.put(new ResourceLocation("lush_caves"), Tags.Biomes.IS_LUSH);
        Set<TagKey> DEFINING_TAGS = Set.of(BiomeTags.f_207605_, BiomeTags.f_207602_, BiomeTags.f_207603_, BiomeTags.f_207604_, BiomeTags.f_207607_, BiomeTags.f_215816_, BiomeTags.f_207609_, BiomeTags.f_207610_, BiomeTags.f_207611_, BiomeTags.f_207606_, StructureEssentials.createBiomeTag("forge", "is_cave"), StructureEssentials.createBiomeTag("forge", "is_plains"), StructureEssentials.createBiomeTag("forge", "is_desert"), StructureEssentials.createBiomeTag("forge", "is_snowy"), StructureEssentials.createBiomeTag("forge", "is_lush"), StructureEssentials.createBiomeTag("forge", "is_dead"), StructureEssentials.createBiomeTag("forge", "is_underground"), StructureEssentials.createBiomeTag("forge", "is_void"), StructureEssentials.createBiomeTag("forge", "is_sandy"), StructureEssentials.createBiomeTag("forge", "is_swamp"), StructureEssentials.createBiomeTag("c", "no_default_monsters"), StructureEssentials.createBiomeTag("c", "is_void"), StructureEssentials.createBiomeTag("c", "is_dense_vegetation"), StructureEssentials.createBiomeTag("c", "is_sparse_vegetation"), StructureEssentials.createBiomeTag("c", "is_plains"), StructureEssentials.createBiomeTag("c", "is_windswept"), StructureEssentials.createBiomeTag("c", "is_shallow_ocean"), StructureEssentials.createBiomeTag("c", "is_underground"), StructureEssentials.createBiomeTag("c", "is_cave"), StructureEssentials.createBiomeTag("c", "is_lush"), StructureEssentials.createBiomeTag("c", "is_dead"), StructureEssentials.createBiomeTag("c", "is_sandy"), StructureEssentials.createBiomeTag("c", "is_snowy"), StructureEssentials.createBiomeTag("c", "is_icy"), StructureEssentials.createBiomeTag("c", "is_swamp"), StructureEssentials.createBiomeTag("c", "is_aquatic"));
        for (Holder.Reference holder : holders) {
            Object2DoubleMap.Entry scoredBiome;
            Object entry;
            Object biome22;
            LinkedHashSet<Object> biomeHolderSet = new LinkedHashSet<Object>(((Structure)holder.m_203334_()).m_226559_().m_203632_());
            float minTemp = 1000.0f;
            float maxTemp = -1000.0f;
            float maxDownfall = -1000.0f;
            float minDownfall = 1000.0f;
            Object2IntOpenHashMap allowedDefiningTags = new Object2IntOpenHashMap();
            for (Object biome22 : ((Structure)holder.m_203334_()).m_226559_()) {
                float downFall;
                if (!holder.m_203633_()) continue;
                biomeHolderSet.add(biome22);
                float temp = Command.getAdjustedTemp((Holder<Biome>)biome22);
                if (temp < minTemp) {
                    minTemp = temp;
                }
                if (temp > maxTemp) {
                    maxTemp = temp;
                }
                if ((downFall = ((Biome)biome22.m_203334_()).getModifiedClimateSettings().f_47683_()) < minDownfall) {
                    minDownfall = downFall;
                }
                if (downFall > maxDownfall) {
                    maxDownfall = downFall;
                }
                for (TagKey biomeTagKey : DEFINING_TAGS) {
                    if (!biome22.m_203656_(biomeTagKey)) continue;
                    allowedDefiningTags.put((Object)biomeTagKey, allowedDefiningTags.getOrDefault((Object)biomeTagKey, 0) + 1);
                }
            }
            HashSet<TagKey> deniedDefiningSet = new HashSet<TagKey>();
            biome22 = DEFINING_TAGS.iterator();
            while (biome22.hasNext()) {
                TagKey biomeTagKey = (TagKey)biome22.next();
                if (allowedDefiningTags.containsKey((Object)biomeTagKey)) continue;
                deniedDefiningSet.add(biomeTagKey);
            }
            HashSet<TagKey> requiredDefiningSet = new HashSet<TagKey>();
            for (Object2IntMap.Entry entry2 : allowedDefiningTags.object2IntEntrySet()) {
                if (entry2.getIntValue() != ((Structure)holder.m_203334_()).m_226559_().m_203632_()) continue;
                requiredDefiningSet.add((TagKey)entry2.getKey());
            }
            if (biomeHolderSet.isEmpty()) continue;
            minTemp -= 0.35f;
            maxTemp += 0.35f;
            minDownfall -= 0.35f;
            maxDownfall += 0.35f;
            HashMap<ServerLevel, Set> allowedDimensions = new HashMap<ServerLevel, Set>();
            for (ServerLevel level : server.m_129785_()) {
                Set dimensionbiomes = level.m_7726_().m_8481_().m_62218_().m_207840_();
                allowedDimensions.put(level, dimensionbiomes);
            }
            Iterator iterator = allowedDimensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry dimensionBiomes = iterator.next();
                boolean contained = false;
                for (Holder holder2 : biomeHolderSet) {
                    if (!((Set)dimensionBiomes.getValue()).contains(holder2)) continue;
                    contained = true;
                    break;
                }
                if (contained && ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).dimensionWhitelist.contains(((ServerLevel)dimensionBiomes.getKey()).m_46472_().m_135782_().toString())) continue;
                iterator.remove();
            }
            HashSet<TagKey> addedTags = new HashSet<TagKey>(requiredDefiningSet);
            HashSet<Holder> addedTagBiomes = new HashSet<Holder>();
            HashSet<Holder> toAdd = new HashSet<Holder>();
            for (TagKey tagKey : requiredDefiningSet) {
                for (Holder holder3 : biomeRegistry.m_203561_(tagKey)) {
                    if (biomeHolderSet.contains(holder3)) continue;
                    toAdd.add(holder3);
                }
            }
            for (Holder holder4 : biomeHolderSet) {
                TagKey tag2 = (TagKey)directReplacementTags.get(biomeRegistry.m_7981_((Object)((Biome)holder4.m_203334_())));
                if (tag2 == null || addedTags.contains(tag2) || !holder4.m_203656_(tag2)) continue;
                for (Holder tagBiome2 : biomeRegistry.m_203561_(tag2)) {
                    if (biomeHolderSet.contains(tagBiome2)) continue;
                    toAdd.add(tagBiome2);
                    addedTagBiomes.add(tagBiome2);
                }
                addedTags.add(tag2);
            }
            Object2DoubleOpenHashMap highScoreBiomes = new Object2DoubleOpenHashMap();
            Object2DoubleOpenHashMap object2DoubleOpenHashMap = new Object2DoubleOpenHashMap();
            for (Holder holder5 : biomeHolderSet) {
                List<Object2DoubleMap.Entry<Holder<Biome>>> similar = Command.getSimilarBiomesFor((Holder<Biome>)holder5, (RegistryAccess)registryAccess);
                for (int i = 0; i < similar.size() && i < 200; ++i) {
                    entry = similar.get(i);
                    if (biomeHolderSet.contains(entry.getKey())) continue;
                    double percent = entry.getDoubleValue();
                    double previousValue = object2DoubleOpenHashMap.getOrDefault(entry.getKey(), 0.0);
                    double d = toAdd.contains(entry.getKey()) ? 0.7224999999999999 : 0.85;
                    if (percent >= d * ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatStrictness) {
                        highScoreBiomes.put((Object)((Holder)entry.getKey()), percent);
                    }
                    object2DoubleOpenHashMap.put((Object)((Holder)entry.getKey()), previousValue + percent);
                }
            }
            for (Object2DoubleMap.Entry entry2 : object2DoubleOpenHashMap.object2DoubleEntrySet()) {
                entry2.setValue(entry2.getDoubleValue() / (double)biomeHolderSet.size());
            }
            if (highScoreBiomes.isEmpty()) continue;
            ArrayList<Object> sortedPotentialBiomes = new ArrayList<Object>((Collection<Object>)object2DoubleOpenHashMap.object2DoubleEntrySet());
            sortedPotentialBiomes.sort(Comparator.comparingDouble(e -> ((Object2DoubleMap.Entry)e).getDoubleValue()).reversed());
            Object2DoubleMap.Entry entry3 = (Object2DoubleMap.Entry)sortedPotentialBiomes.get(0);
            if (entry3 == null) continue;
            toAdd.clear();
            double minSimilarity = entry3.getDoubleValue() * 0.8 * ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatStrictness;
            entry = sortedPotentialBiomes.iterator();
            while (entry.hasNext() && !((scoredBiome = (Object2DoubleMap.Entry)entry.next()).getDoubleValue() < minSimilarity)) {
                if (!highScoreBiomes.containsKey(scoredBiome.getKey())) continue;
                toAdd.add((Holder)scoredBiome.getKey());
            }
            Iterator iterator2 = toAdd.iterator();
            block18: while (iterator2.hasNext()) {
                Holder biomeHolder = (Holder)iterator2.next();
                if (!biomeHolder.m_203633_() || biomeHolder.m_203543_().isEmpty()) {
                    iterator2.remove();
                    continue;
                }
                ResourceKey biomeKey = (ResourceKey)biomeHolder.m_203543_().get();
                if (biomeKey == Biomes.f_48210_ || biomeKey == Biomes.f_48173_ || biomeKey == Biomes.f_48162_) {
                    iterator2.remove();
                    continue;
                }
                boolean containedDimension = false;
                for (Set dimensionBiomes : allowedDimensions.values()) {
                    if (!dimensionBiomes.contains(biomeHolder)) continue;
                    containedDimension = true;
                    break;
                }
                if (!containedDimension) {
                    iterator2.remove();
                    continue;
                }
                if (((Biome)biomeHolder.m_203334_()).m_47536_().m_47818_().isEmpty()) {
                    iterator2.remove();
                    continue;
                }
                float temp = Command.getAdjustedTemp((Holder<Biome>)biomeHolder);
                float downFall = ((Biome)biomeHolder.m_203334_()).getModifiedClimateSettings().f_47683_();
                if (!(temp > minTemp && temp < maxTemp && downFall < maxDownfall && downFall > minDownfall)) {
                    iterator2.remove();
                    continue;
                }
                if (!biomeHolder.m_203616_().anyMatch(tag -> tag.f_203868_().m_135815_().contains("structure"))) {
                    iterator2.remove();
                    continue;
                }
                boolean shouldRemove = false;
                for (TagKey biomeTagKey : requiredDefiningSet) {
                    if (biomeHolder.m_203656_(biomeTagKey) || addedTagBiomes.contains(biomeHolder)) continue;
                    shouldRemove = true;
                }
                if (shouldRemove) {
                    iterator2.remove();
                    continue;
                }
                for (TagKey biomeTagKey : deniedDefiningSet) {
                    if (!biomeHolder.m_203656_(biomeTagKey)) continue;
                    iterator2.remove();
                    continue block18;
                }
            }
            if (toAdd.isEmpty()) continue;
            String tagName = biomeRegistry.m_7981_((Object)((Biome)((Holder)((Structure)holder.m_203334_()).m_226559_().iterator().next()).m_203334_())).toString();
            if (((Structure)holder.m_203334_()).m_226559_().m_203440_().left().isPresent()) {
                tagName = ((TagKey)((Structure)holder.m_203334_()).m_226559_().m_203440_().left().get()).f_203868_().toString();
            }
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatLogging) {
                LOGGER.warn("Adding Biomes to structure: " + holder.m_205785_().m_135782_() + " tag:" + tagName + " mins:" + (double)((int)(minSimilarity * 1000.0)) / 1000.0 + " biomes: " + toAdd.stream().map(e -> ((ResourceKey)e.m_203543_().get()).m_135782_() + ":" + (double)((int)(potentialBiomes.getOrDefault(e, 0.0) * 1000.0)) / 1000.0).toList());
            }
            biomeHolderSet.addAll(toAdd);
            ModifiableStructureInfo modifiableStructureInfo = ((Structure)holder.m_203334_()).modifiableStructureInfo();
            if (!(modifiableStructureInfo instanceof IStructureModifier)) continue;
            IStructureModifier structureModifier = (IStructureModifier)modifiableStructureInfo;
            structureModifier.setStructureBiomes((HolderSet<Biome>)HolderSet.m_205800_(new ArrayList(biomeHolderSet)));
        }
        Command.biomeScoreCache.clear();
    }

    public static ResourceLocation createResourcelocation(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static TagKey<Biome> createBiomeTag(String namespace, String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)StructureEssentials.createResourcelocation(namespace, path));
    }
}

