/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.simplybuttons.client.modbuttons;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.heracles.client.HeraclesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.moddercoder.simplybuttons.SimplyButtons;
import net.moddercoder.simplybuttons.client.modbuttons.IModButtons;
import net.moddercoder.simplybuttons.client.modbuttons.ModButtonTextures;
import net.moddercoder.simplybuttons.client.util.GuiShower;
import net.moddercoder.simplybuttons.client.util.HeraclesClientQuestChecker;
import net.moddercoder.simplybuttons.mixin.client.ScreenInvokerAndAccessor;
import net.moddercoder.simplybuttons.network.packet.RequestToSyncQuestStatusC2SPacket;

public class ModButtonsWithoutFtb
implements IModButtons {
    private Boolean heraclesLoaded;
    private Boolean passiveSkillTreeLoaded;
    protected int buttonsOffsetX = 6;
    protected int buttonsOffsetY = 6;
    protected ImageButton btnHeracles;
    protected ImageButton btnPassiveSkillTree;

    @Override
    public void onPreInitScreen(ScreenEvent.Init.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen && this.isHeraclesLoaded()) {
            SimplyButtons.CHANNEL.sendToServer((Packet)new RequestToSyncQuestStatusC2SPacket());
        }
    }

    @Override
    public void onPostInitScreen(ScreenEvent.Init event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            this.placeOrReplaceButtons(screen, (ScreenEvent)event);
        }
    }

    @Override
    public void onMouseReleasedScreen(ScreenEvent.MouseButtonReleased event) {
    }

    @Override
    public void onKeyReleasedScreen(ScreenEvent.KeyReleased event) {
    }

    @Override
    public void onKeyPressedScreen(ScreenEvent.KeyPressed event) {
    }

    protected void placeOrReplaceButtons(Screen inventoryScreen, ScreenEvent event) {
        int heraclesButtonTextureHeight;
        Minecraft minecraft = Minecraft.m_91087_();
        ScreenInvokerAndAccessor screenInvoker = (ScreenInvokerAndAccessor)inventoryScreen;
        screenInvoker.invokeRemoveWidget((GuiEventListener)this.btnHeracles);
        screenInvoker.invokeRemoveWidget((GuiEventListener)this.btnPassiveSkillTree);
        boolean completedAtOnceOne = this.isHeraclesLoaded() && HeraclesClientQuestChecker.isCompletedAtOnceOneQuest();
        int heraclesButtonTextureX = !completedAtOnceOne ? 0 : 19;
        boolean heraclesButtonTextureY = false;
        int heraclesButtonTextureWidth = !completedAtOnceOne ? 16 : 18;
        int n = heraclesButtonTextureHeight = !completedAtOnceOne ? 15 : 17;
        if (this.isHeraclesLoaded()) {
            this.btnHeracles = new ImageButton(this.buttonsOffsetX, this.buttonsOffsetY, heraclesButtonTextureWidth, heraclesButtonTextureHeight, heraclesButtonTextureX, 0, ModButtonTextures.ICON_TEXTURES, self -> HeraclesClient.openQuestScreen());
            this.btnHeracles.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.simplybuttons.button.heracles.text")));
            this.addButton(inventoryScreen, (Button)this.btnHeracles);
        }
        if (this.isPassiveSkillTreeLoaded()) {
            int xButtonOffset = this.isHeraclesLoaded() ? 20 : 0;
            this.btnPassiveSkillTree = new ImageButton(this.buttonsOffsetX + xButtonOffset, this.buttonsOffsetY, 14, 15, 40, 0, ModButtonTextures.ICON_TEXTURES, self -> GuiShower.openPassiveSkillTree(minecraft));
            this.btnPassiveSkillTree.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.simplybuttons.button.skilltree.text")));
            this.addButton(inventoryScreen, (Button)this.btnPassiveSkillTree);
        }
    }

    protected void addButton(Screen screen, Button button) {
        ScreenInvokerAndAccessor screenInvoker = (ScreenInvokerAndAccessor)screen;
        screen.f_169369_.add(button);
        screenInvoker.getChildren().add((GuiEventListener)button);
        screenInvoker.getNarratables().add((NarratableEntry)button);
    }

    protected boolean isHeraclesLoaded() {
        if (this.heraclesLoaded == null) {
            this.heraclesLoaded = FMLLoader.getLoadingModList().getModFileById("heracles") != null;
        }
        return this.heraclesLoaded;
    }

    protected boolean isPassiveSkillTreeLoaded() {
        if (this.passiveSkillTreeLoaded == null) {
            this.passiveSkillTreeLoaded = FMLLoader.getLoadingModList().getModFileById("skilltree") != null;
        }
        return this.passiveSkillTreeLoaded;
    }
}

