/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.simpletridents.event;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.moddercoder.simpletridents.item.ModItems;
import net.moddercoder.simpletridents.recipe.ModAnvilRecipes;
import net.moddercoder.simpletridents.reference.ModDataKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lnet/moddercoder/simpletridents/event/ModEvents;", "", "()V", "onAnvilUpdate", "", "event", "Lnet/minecraftforge/event/AnvilUpdateEvent;", "onLootTableLoad", "Lnet/minecraftforge/event/LootTableLoadEvent;", "simpletridents-1.20.1"})
public final class ModEvents {
    @SubscribeEvent
    public final void onAnvilUpdate(@NotNull AnvilUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (ModAnvilRecipes.AnvilRecipe anvilRecipe : ModAnvilRecipes.INSTANCE.getRecipeList()) {
            Function0<Item> leftRecipeItem = anvilRecipe.getFirstItem();
            Function0<Item> rightRecipeItem = anvilRecipe.getSecondItem();
            Function0<Item> resultRecipeItem = anvilRecipe.getResultItem();
            ItemStack leftStack = event.getLeft();
            ItemStack rightStack = event.getRight();
            if (!leftStack.m_150930_((Item)leftRecipeItem.invoke()) || !rightStack.m_150930_((Item)rightRecipeItem.invoke())) continue;
            ItemStack resultStack = new ItemStack(() -> ModEvents.onAnvilUpdate$lambda$0(resultRecipeItem), leftStack.m_41613_());
            resultStack.m_41754_(leftStack.m_41612_());
            ItemStack itemStack = leftStack;
            resultStack.m_41751_(itemStack != null && (itemStack = itemStack.m_41783_()) != null ? itemStack.m_6426_() : null);
            Map allowedEnchantments = new LinkedHashMap();
            for (Map.Entry enchantmentEntries : EnchantmentHelper.m_44831_((ItemStack)resultStack).entrySet()) {
                Object v;
                Enchantment enchantment = (Enchantment)enchantmentEntries.getKey();
                if (enchantment == null || !((Item)resultRecipeItem.invoke()).canApplyAtEnchantingTable(resultStack, enchantment)) continue;
                Map map = allowedEnchantments;
                Enchantment enchantment2 = enchantment;
                Intrinsics.checkNotNullExpressionValue(enchantmentEntries.getValue(), (String)"enchantmentEntries.value");
                map.put(enchantment2, v);
            }
            EnchantmentHelper.m_44865_((Map)allowedEnchantments, (ItemStack)resultStack);
            event.setOutput(resultStack);
            event.setCost(anvilRecipe.getExperienceCost());
            event.setResult(Event.Result.ALLOW);
            break;
        }
    }

    @SubscribeEvent
    public final void onLootTableLoad(@NotNull LootTableLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!ModDataKt.getEnigmaticLegacyLoaded()) {
            if (event.getName().equals((Object)new ResourceLocation("chests/bastion_treasure"))) {
                event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.INSTANCE.getHELL_CORE().get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Items.f_41852_)).m_79707_(1)).m_79082_());
            }
            if (event.getName().equals((Object)new ResourceLocation("chests/end_city_treasure"))) {
                event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.INSTANCE.getEND_CORE().get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Items.f_41852_)).m_79707_(4)).m_79082_());
            }
        }
    }

    private static final Item onAnvilUpdate$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Item)$tmp0.invoke();
    }
}

