/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.renderers.entities;

import com.alexander.rootoffear.entities.WiltedBarrier;
import com.alexander.rootoffear.models.entities.WiltedBarrierModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WiltedBarrierRenderer
extends EntityRenderer<WiltedBarrier> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rootoffear", "textures/entity/decoy_wilted.png");
    private final WiltedBarrierModel<WiltedBarrier> model;

    public WiltedBarrierRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WiltedBarrierModel(context.m_174023_(WiltedBarrierModel.LAYER_LOCATION));
    }

    public void render(WiltedBarrier entity, float p_115374_, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_252880_(0.0f, -1.501f, 0.0f);
        float f = (float)entity.f_19797_ + partialTick;
        this.model.setupAnim(entity, partialTick, 0.0f, f, 0.0f, 0.0f);
        this.model.m_142109_().f_104204_ = (float)Math.toRadians(entity.m_146908_() + 180.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(stack, vertexconsumer, packedLight, entity.hurtCooldown > 0 ? 3 : OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        super.m_7392_((Entity)entity, p_115374_, partialTick, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(WiltedBarrier entity) {
        return TEXTURE;
    }
}

