/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.renderers.entities;

import com.alexander.rootoffear.entities.LightExtinguisher;
import com.alexander.rootoffear.events.LightExtinguisherTrackingEvent;
import com.alexander.rootoffear.models.entities.LightExtinguisherDarknessModel;
import com.alexander.rootoffear.models.entities.LightExtinguisherModel;
import com.alexander.rootoffear.renderers.rendertypes.RoFRenderTypes;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LightExtinguisherRenderer
extends EntityRenderer<LightExtinguisher> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rootoffear", "textures/entity/light_extinguisher.png");
    private static final ResourceLocation DARKNESS_TEXTURE = new ResourceLocation("rootoffear", "textures/entity/light_extinguisher_darkness.png");
    private static final ResourceLocation PULL_LOCATION = new ResourceLocation("rootoffear", "textures/entity/light_extinguisher_pull.png");
    private static final RenderType PULL_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)PULL_LOCATION);
    private final LightExtinguisherModel<LightExtinguisher> model;
    private final LightExtinguisherDarknessModel<LightExtinguisher> darknessModel;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public LightExtinguisherRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new LightExtinguisherModel(context.m_174023_(LightExtinguisherModel.LAYER_LOCATION));
        this.darknessModel = new LightExtinguisherDarknessModel(context.m_174023_(LightExtinguisherDarknessModel.LAYER_LOCATION));
        this.blockRenderDispatcher = context.m_234597_();
    }

    public boolean shouldRender(LightExtinguisher entity, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return MiscUtils.inSurvivalMode(entity.getPulledEntity()) || super.m_5523_((Entity)entity, p_114492_, p_114493_, p_114494_, p_114495_);
    }

    private Vec3 getPosition(Entity entity, Entity target, float partialTick) {
        double d0 = Mth.m_14139_((double)partialTick, (double)target.f_19790_, (double)target.m_20185_());
        double d1 = Mth.m_14139_((double)partialTick, (double)target.f_19791_, (double)target.m_20186_()) + 0.01;
        double d2 = Mth.m_14139_((double)partialTick, (double)target.f_19792_, (double)target.m_20189_());
        return new Vec3(d0 - entity.m_20185_(), d1 - entity.m_20186_(), d2 - entity.m_20189_());
    }

    public void render(LightExtinguisher entity, float p_115374_, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        if (!(entity.killed || !MiscUtils.inSurvivalMode(entity.getPulledEntity()) && LightExtinguisherTrackingEvent.extinguishers.containsValue(entity.m_20183_().m_7494_()) && LightExtinguisherTrackingEvent.extinguishers.containsValue(entity.m_20183_().m_7495_()) && LightExtinguisherTrackingEvent.extinguishers.containsValue(entity.m_20183_().m_122012_()) && LightExtinguisherTrackingEvent.extinguishers.containsValue(entity.m_20183_().m_122019_()) && LightExtinguisherTrackingEvent.extinguishers.containsValue(entity.m_20183_().m_122029_()) && LightExtinguisherTrackingEvent.extinguishers.containsValue(entity.m_20183_().m_122024_()))) {
            Level level;
            BlockState blockstate;
            LivingEntity target = entity.getPulledEntity();
            if (target != null && (double)entity.m_20270_((Entity)target) >= 1.25) {
                stack.m_85836_();
                VertexConsumer vertexconsumer = buffer.m_6299_(PULL_RENDER_TYPE);
                PoseStack.Pose posestack$pose = stack.m_85850_();
                Matrix4f matrix4f = posestack$pose.m_252922_();
                Matrix3f matrix3f = posestack$pose.m_252943_();
                float pullLengthLerp = Mth.m_14179_((float)partialTick, (float)entity.pullLengthLerpO, (float)entity.pullLengthLerp);
                Vec3 entityPos = this.getPosition(entity, entity, partialTick);
                Vec3 targetPos = entityPos.m_165921_(this.getPosition(entity, (Entity)target, partialTick), (double)pullLengthLerp);
                float dist = Mth.m_14179_((float)pullLengthLerp, (float)0.0f, (float)((float)Mth.m_14139_((double)partialTick, (double)entity.pullTargetDistO, (double)entity.pullTargetDist)));
                float rollSpeed = 0.01f;
                float roll = -Mth.m_14179_((float)partialTick, (float)((float)entity.pullO * rollSpeed), (float)((float)entity.pull * rollSpeed));
                int targetLight = this.f_114476_.m_114394_((Entity)target, partialTick);
                Vec3 vec3 = PositionUtils.getOffsetPos(entityPos, (double)(entity.m_20205_() / 2.0f), 0.0, (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec31 = PositionUtils.getOffsetPos(targetPos, (double)(target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec31.f_82479_, (float)vec31.f_82480_, (float)vec31.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec32 = PositionUtils.getOffsetPos(targetPos, (double)(target.m_20205_() / 2.0f), (double)target.m_20192_() - 0.2, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec32.f_82479_, (float)vec32.f_82480_, (float)vec32.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec33 = PositionUtils.getOffsetPos(entityPos, (double)(entity.m_20205_() / 2.0f), (double)entity.m_20206_(), (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec33.f_82479_, (float)vec33.f_82480_, (float)vec33.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec34 = PositionUtils.getOffsetPos(entityPos, (double)(-entity.m_20205_() / 2.0f), 0.0, (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec34.f_82479_, (float)vec34.f_82480_, (float)vec34.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec35 = PositionUtils.getOffsetPos(targetPos, (double)(-target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec35.f_82479_, (float)vec35.f_82480_, (float)vec35.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec36 = PositionUtils.getOffsetPos(targetPos, (double)(-target.m_20205_() / 2.0f), (double)target.m_20192_() - 0.2, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec36.f_82479_, (float)vec36.f_82480_, (float)vec36.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec37 = PositionUtils.getOffsetPos(entityPos, (double)(-entity.m_20205_() / 2.0f), (double)entity.m_20206_(), (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec37.f_82479_, (float)vec37.f_82480_, (float)vec37.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec38 = PositionUtils.getOffsetPos(entityPos, (double)(-entity.m_20205_() / 2.0f), 0.0, (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec38.f_82479_, (float)vec38.f_82480_, (float)vec38.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec39 = PositionUtils.getOffsetPos(targetPos, (double)(-target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec39.f_82479_, (float)vec39.f_82480_, (float)vec39.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec310 = PositionUtils.getOffsetPos(targetPos, (double)(target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec310.f_82479_, (float)vec310.f_82480_, (float)vec310.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec311 = PositionUtils.getOffsetPos(entityPos, (double)(entity.m_20205_() / 2.0f), 0.0, (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec311.f_82479_, (float)vec311.f_82480_, (float)vec311.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec312 = PositionUtils.getOffsetPos(entityPos, (double)(-entity.m_20205_() / 2.0f), (double)entity.m_20206_(), (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec312.f_82479_, (float)vec312.f_82480_, (float)vec312.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec313 = PositionUtils.getOffsetPos(targetPos, (double)(-target.m_20205_() / 2.0f), (double)target.m_20192_() - 0.2, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec313.f_82479_, (float)vec313.f_82480_, (float)vec313.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec314 = PositionUtils.getOffsetPos(targetPos, (double)(target.m_20205_() / 2.0f), (double)target.m_20192_() - 0.2, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec314.f_82479_, (float)vec314.f_82480_, (float)vec314.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec315 = PositionUtils.getOffsetPos(entityPos, (double)(entity.m_20205_() / 2.0f), (double)entity.m_20206_(), (double)(-entity.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec315.f_82479_, (float)vec315.f_82480_, (float)vec315.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, dist + roll).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec316 = PositionUtils.getOffsetPos(targetPos, (double)(target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec316.f_82479_, (float)vec316.f_82480_, (float)vec316.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec317 = PositionUtils.getOffsetPos(targetPos, (double)(target.m_20205_() / 2.0f), (double)target.m_20192_() - 0.2, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec317.f_82479_, (float)vec317.f_82480_, (float)vec317.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec318 = PositionUtils.getOffsetPos(targetPos, (double)(-target.m_20205_() / 2.0f), (double)target.m_20192_() - 0.2, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec318.f_82479_, (float)vec318.f_82480_, (float)vec318.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 vec319 = PositionUtils.getOffsetPos(targetPos, (double)(-target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f), 0.0f, Mth.m_14179_((float)partialTick, (float)entity.facingAngleO.f_82471_, (float)entity.facingAngle.f_82471_));
                vertexconsumer.m_252986_(matrix4f, (float)vec319.f_82479_, (float)vec319.f_82480_, (float)vec319.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(targetLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                stack.m_85849_();
            }
            if (entity.getExtinguishedPos().isPresent() && entity.getExtinguishedState().isPresent() && entity.getExtinguishedState().get().m_60799_() == RenderShape.MODEL && (blockstate = entity.getExtinguishedState().get()) != (level = entity.m_9236_()).m_8055_(entity.m_20183_()) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                stack.m_85836_();
                BlockPos blockpos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20191_().f_82292_, (double)entity.m_20189_());
                stack.m_85837_(-0.5, 0.0, -0.5);
                BakedModel model = this.blockRenderDispatcher.m_110910_(blockstate);
                for (RenderType renderType : model.getRenderTypes(blockstate, RandomSource.m_216335_((long)blockstate.m_60726_(entity.getExtinguishedPos().get())), ModelData.EMPTY)) {
                    renderType = RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType);
                    this.blockRenderDispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, blockstate, blockpos, stack, buffer.m_6299_(renderType), false, RandomSource.m_216327_(), blockstate.m_60726_(entity.getExtinguishedPos().get()), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
                }
                stack.m_85849_();
            }
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.5f, 0.0f);
            stack.m_252781_(entity.attachDirection.m_253075_());
            stack.m_252880_(0.0f, 1.001f, 0.0f);
            stack.m_85841_(-1.0f, -1.0f, 1.0f);
            float f = (float)entity.f_19797_ + partialTick;
            this.model.setupAnim(entity, partialTick, 0.0f, f, 0.0f, 0.0f);
            VertexConsumer vertexconsumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
            this.model.m_7695_(stack, vertexconsumer, packedLight, entity.hurtCooldown > 0 ? 3 : OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (entity.getExtinguishedPos().isPresent() && entity.getExtinguishedState().isPresent()) {
                VertexConsumer vertexconsumer2 = buffer.m_6299_(RoFRenderTypes.solidSwirl(DARKNESS_TEXTURE, f * 0.01f % 1.0f, f * 0.001f % 1.0f));
                this.darknessModel.m_7695_(stack, vertexconsumer2, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, Mth.m_14179_((float)partialTick, (float)entity.darknessO, (float)entity.darkness));
            }
            stack.m_85849_();
            super.m_7392_((Entity)entity, p_115374_, partialTick, stack, buffer, packedLight);
        }
    }

    private static void vertex(VertexConsumer p_253637_, Matrix4f p_253920_, Matrix3f p_253881_, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        p_253637_.m_252986_(p_253920_, p_253994_, p_254492_, p_254474_).m_6122_(p_254080_, p_253655_, p_254133_, 255).m_7421_(p_254233_, p_253939_).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(p_253881_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(LightExtinguisher entity) {
        return TEXTURE;
    }
}

