/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.particles;

import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.particles.AdvancedParticleOption;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class WiltedLeafParticle<T extends AdvancedParticleOption>
extends TextureSheetParticle {
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private float rotSpeed;
    private final float particleRandom;
    private final float spinAcceleration;
    private final float landedHeightModifier;

    public WiltedLeafParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, T particleOptions) {
        super(level, ((AdvancedParticleOption)particleOptions).v1, ((AdvancedParticleOption)particleOptions).v2, ((AdvancedParticleOption)particleOptions).v3);
        float size;
        this.m_108335_(spriteSet);
        this.rotSpeed = (float)Math.toRadians(this.f_107223_.m_188499_() ? -30.0 : 30.0);
        this.particleRandom = this.f_107223_.m_188501_();
        this.spinAcceleration = (float)Math.toRadians(this.f_107223_.m_188499_() ? -5.0 : 5.0);
        this.f_107225_ = ((AdvancedParticleOption)particleOptions).v4 > 0.0 ? 100 + this.f_107223_.m_188503_(100) : 1200;
        this.f_107226_ = 0.01f;
        this.f_107663_ = size = 0.2f;
        this.m_107250_(size, size);
        this.f_172258_ = 1.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        Color col = new Color((int)((AdvancedParticleOption)particleOptions).v0);
        this.f_107227_ = (float)col.getRed() / 255.0f;
        this.f_107228_ = (float)col.getGreen() / 255.0f;
        this.f_107229_ = (float)col.getBlue() / 255.0f;
        this.landedHeightModifier = 0.001f + this.f_107223_.m_188501_() * 0.01f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
        if (!this.f_107220_) {
            if (this.f_107225_ < 1180) {
                float transitionSpeed = 0.05f;
                this.f_107227_ = Mth.m_14179_((float)transitionSpeed, (float)this.f_107227_, (float)((float)Wilted.revealedLeafColour.getRed() / 255.0f));
                this.f_107228_ = Mth.m_14179_((float)transitionSpeed, (float)this.f_107228_, (float)((float)Wilted.revealedLeafColour.getGreen() / 255.0f));
                this.f_107229_ = Mth.m_14179_((float)transitionSpeed, (float)this.f_107229_, (float)((float)Wilted.revealedLeafColour.getBlue() / 255.0f));
            }
            float f = 1200 - this.f_107225_;
            float f1 = Math.min(f / 1200.0f, 1.0f);
            double d0 = Math.cos(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(f1, 1.25);
            double d1 = Math.sin(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(f1, 1.25);
            this.f_107215_ += d0 * (double)0.0025f;
            this.f_107217_ += d1 * (double)0.0025f;
            this.f_107216_ -= (double)this.f_107226_;
            if (!this.f_107218_) {
                this.rotSpeed += this.spinAcceleration / 20.0f;
            }
            this.f_107204_ = this.f_107231_;
            if (!this.f_107218_) {
                this.f_107231_ += this.rotSpeed / 20.0f;
            }
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (!this.f_107220_) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        if (this.f_107218_) {
            Vec3 vec3 = camera.m_90583_();
            float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
            float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
            float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
            Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
            quaternionf.rotateX((float)Math.toRadians(90.0));
            quaternionf.rotateZ(Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_));
            quaternionf.transform(TRANSFORM_VECTOR);
            Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            float f3 = this.m_5902_(partialTick);
            for (int i = 0; i < 4; ++i) {
                Vector3f vector3f = avector3f[i];
                vector3f.rotate((Quaternionfc)quaternionf);
                vector3f.mul(f3);
                vector3f.add(f, f1 + this.landedHeightModifier, f2);
            }
            float f7 = this.m_5970_();
            float f8 = this.m_5952_();
            float f5 = this.m_5951_();
            float f6 = this.m_5950_();
            int j = this.m_6355_(partialTick);
            consumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            consumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            consumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            consumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        } else {
            super.m_5744_(consumer, camera, partialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<AdvancedParticleOption> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(AdvancedParticleOption particleOptions, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new WiltedLeafParticle<AdvancedParticleOption>(level, x, y, z, this.sprites, particleOptions);
        }
    }
}

