/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.particles;

import com.alexander.rootoffear.entities.Wilted;
import java.awt.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WiltedGlowParticle
extends TextureSheetParticle {
    public static final int[] PARTICLE_COLOURS = new int[]{15704887, 15495700, 12342561};
    private float glowAmount;

    protected WiltedGlowParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.f_107215_ *= 0.25;
        this.f_107217_ *= 0.25;
        this.f_107216_ += 0.01;
        this.glowAmount = Math.max((7.5f - (float)level.m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)this.getPos()))) / 7.5f, 0.0f);
        this.f_172258_ = 0.975f;
        this.f_107663_ = 0.075f;
        this.f_107225_ = 10 + this.f_107223_.m_188503_(5);
        Color glowColour = new Color(PARTICLE_COLOURS[this.f_107223_.m_188503_(PARTICLE_COLOURS.length)]);
        this.f_107227_ = Mth.m_14179_((float)this.glowAmount, (float)((float)Wilted.revealedLeafColour.getRed() / 255.0f), (float)((float)glowColour.getRed() / 255.0f));
        this.f_107228_ = Mth.m_14179_((float)this.glowAmount, (float)((float)Wilted.revealedLeafColour.getGreen() / 255.0f), (float)((float)glowColour.getGreen() / 255.0f));
        this.f_107229_ = Mth.m_14179_((float)this.glowAmount, (float)((float)Wilted.revealedLeafColour.getBlue() / 255.0f), (float)((float)glowColour.getBlue() / 255.0f));
        this.m_108335_(spriteSet);
    }

    protected int m_6355_(float p_107249_) {
        return (int)(255.0f * this.glowAmount);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleOptions, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new WiltedGlowParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

