/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.particles;

import com.alexander.rootoffear.utils.PositionUtils;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WiltedBreakParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;
    private final double targetX;
    private final double targetZ;
    private final boolean isMoving;
    private final float movementSpeedMultiplier;

    protected WiltedBreakParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.f_107226_ = 1.0f;
        this.f_107663_ /= 2.0f;
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.targetX = xd;
        this.isMoving = yd > 0.0;
        this.targetZ = zd;
        if (this.isMoving) {
            this.f_107225_ = 200;
        }
        this.m_108337_(spriteSet.m_5819_(this.isMoving ? 1 : 0, 1));
        this.movementSpeedMultiplier = 0.01f + this.f_107223_.m_188501_() * 0.04f;
    }

    protected int m_6355_(float p_107249_) {
        return this.isMoving ? 255 : super.m_6355_(p_107249_);
    }

    public void m_5989_() {
        if (this.isMoving && this.f_107218_) {
            double distance = PositionUtils.distanceTo(this.getPos(), new Vec3(this.targetX, this.f_107213_, this.targetZ));
            this.f_107215_ = (this.targetX - this.f_107212_) / distance * (double)this.movementSpeedMultiplier;
            this.f_107217_ = (this.targetZ - this.f_107214_) / distance * (double)this.movementSpeedMultiplier;
            if (distance <= 0.05) {
                this.m_107274_();
            }
        }
        super.m_5989_();
    }

    public void m_6257_(double p_107246_, double p_107247_, double p_107248_) {
        double d0 = p_107246_;
        double d1 = p_107247_;
        double d2 = p_107248_;
        if (this.f_107219_ && (p_107246_ != 0.0 || p_107247_ != 0.0 || p_107248_ != 0.0) && p_107246_ * p_107246_ + p_107247_ * p_107247_ + p_107248_ * p_107248_ < Mth.m_144952_((double)100.0)) {
            Vec3 vec3 = Entity.m_198894_((Entity)null, (Vec3)new Vec3(p_107246_, p_107247_, p_107248_), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            p_107246_ = vec3.f_82479_;
            p_107247_ = vec3.f_82480_;
            p_107248_ = vec3.f_82481_;
        }
        if (p_107246_ != 0.0 || p_107247_ != 0.0 || p_107248_ != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(p_107246_, p_107247_, p_107248_));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = d1 != p_107247_ && d1 < 0.0;
        if (d0 != p_107246_) {
            this.f_107215_ = 0.0;
        }
        if (d2 != p_107248_) {
            this.f_107217_ = 0.0;
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uo + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uo / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vo / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vo + 1.0f) / 4.0f * 16.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new WiltedBreakParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

