/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.particles;

import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.particles.AdvancedParticleOption;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LeafStormParticle<T extends AdvancedParticleOption>
extends TextureSheetParticle {
    private float rollSpeed;
    private double circleRange;
    private float circleProgress;
    private float circleSpeed;
    private int followedEntityID;
    private Vec3 circleCentrePos;
    private double yOffset;
    public double startX;
    public double startY;
    public double startZ;
    public float lerp = 0.0f;

    protected LeafStormParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd, T particleOptions) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.startX = xCoord;
        this.startY = yCoord;
        this.startZ = zCoord;
        this.circleRange = 0.5 + (double)(this.f_107223_.m_188501_() * 5.0f);
        this.circleProgress = this.f_107223_.m_188501_() * 360.0f;
        this.circleSpeed = this.f_107223_.m_188501_() * 0.25f;
        this.followedEntityID = (int)((AdvancedParticleOption)particleOptions).v0;
        this.rollSpeed = this.f_107223_.m_188501_() * 0.1f;
        this.f_172258_ = 0.8f;
        this.f_107663_ = 0.2f;
        this.f_107225_ = 100 + this.f_107223_.m_188503_(200);
        this.yOffset = this.f_107223_.m_188500_() * 3.0;
        this.f_107230_ = 0.0f;
        this.f_107227_ = (float)Wilted.revealedLeafColour.getRed() / 255.0f;
        this.f_107228_ = (float)Wilted.revealedLeafColour.getGreen() / 255.0f;
        this.f_107229_ = (float)Wilted.revealedLeafColour.getBlue() / 255.0f;
        this.m_108335_(spriteSet);
        this.circleCentrePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107214_ = this.circleCentrePos.f_82481_ + this.circleRange * (double)Mth.m_14031_((float)this.circleProgress);
        this.m_107264_(Mth.m_14139_((double)this.lerp, (double)this.startX, (double)(this.circleCentrePos.f_82479_ + this.circleRange * (double)Mth.m_14089_((float)this.circleProgress))), Mth.m_14139_((double)this.lerp, (double)this.startY, (double)this.circleCentrePos.f_82480_), Mth.m_14139_((double)this.lerp, (double)this.startZ, (double)this.f_107214_));
        this.lerp = Mth.m_14179_((float)0.1f, (float)this.lerp, (float)1.0f);
        this.circleProgress += this.circleSpeed;
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.rollSpeed;
        this.f_107230_ = this.f_107224_ <= 2 ? 0.0f : 1.0f;
        if (this.followedEntityID != 0 && this.f_107208_.m_6815_(this.followedEntityID) == null) {
            this.m_107274_();
        }
        if (this.followedEntityID != 0 && this.f_107208_.m_6815_(this.followedEntityID) != null) {
            Entity entity = this.f_107208_.m_6815_(this.followedEntityID);
            this.circleCentrePos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * this.yOffset - (double)(entity.m_20206_() / 2.0f), 0.0);
        }
    }

    public void m_107274_() {
        super.m_107274_();
        this.f_107208_.m_7107_((ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.WILTED_LEAF, List.of(Double.valueOf(Wilted.revealedLeafColour.getRGB()), Double.valueOf(this.f_107212_), Double.valueOf(this.f_107213_), Double.valueOf(this.f_107214_), Double.valueOf(1.0))), this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<AdvancedParticleOption> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(AdvancedParticleOption particleOptions, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new LeafStormParticle<AdvancedParticleOption>(level, x, y, z, this.sprites, dx, dy, dz, particleOptions);
        }
    }
}

