/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.network;

import com.alexander.rootoffear.config.RoFClientConfig;
import com.alexander.rootoffear.events.HandleClientEffectsEvent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundTWClientEffectsPacket {
    private final boolean addExtraFog;
    private final boolean changeMusic;

    public ClientboundTWClientEffectsPacket(boolean addExtraFog, boolean changeMusic) {
        this.addExtraFog = addExtraFog;
        this.changeMusic = changeMusic;
    }

    public ClientboundTWClientEffectsPacket(FriendlyByteBuf buf) {
        this.addExtraFog = buf.readBoolean();
        this.changeMusic = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.addExtraFog);
        buf.writeBoolean(this.changeMusic);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            HandleClientEffectsEvent.addExtraFog = this.addExtraFog && (Boolean)RoFClientConfig.wilted_fog.get() != false;
            HandleClientEffectsEvent.changeMusic = this.changeMusic && (Boolean)RoFClientConfig.wilted_overrides_music.get() != false;
        });
        return true;
    }
}

