/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.network;

import com.alexander.rootoffear.events.PlayerMovementEvents;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundStartPlayerMovementPacket {
    private final int playerID;
    private final int causeID;
    private final int movementType;

    public ClientboundStartPlayerMovementPacket(Entity player, Entity cause, int movementType) {
        this.playerID = player.m_19879_();
        this.causeID = cause.m_19879_();
        this.movementType = movementType;
    }

    public ClientboundStartPlayerMovementPacket(FriendlyByteBuf buf) {
        this.playerID = buf.readInt();
        this.causeID = buf.readInt();
        this.movementType = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.playerID);
        buf.writeInt(this.causeID);
        buf.writeInt(this.movementType);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> PlayerMovementEvents.addClientPlayerMovement(this.playerID, this.causeID, this.movementType));
        return true;
    }
}

